/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx.extensions;

import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaders;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.websocketx.extensions.WebSocketExtension;
import io.netty5.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty5.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty5.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.netty5.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import io.netty5.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty5.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class WebSocketServerExtensionHandler
implements ChannelHandler {
    private final List<WebSocketServerExtensionHandshaker> extensionHandshakers;
    private List<WebSocketServerExtension> validExtensions;

    public WebSocketServerExtensionHandler(WebSocketServerExtensionHandshaker ... extensionHandshakers) {
        this.extensionHandshakers = Arrays.asList((WebSocketServerExtensionHandshaker[])ObjectUtil.checkNonEmpty((Object[])extensionHandshakers, (String)"extensionHandshakers"));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        String extensionsHeader;
        HttpRequest request;
        if (msg instanceof HttpRequest && WebSocketExtensionUtil.isWebsocketUpgrade((request = (HttpRequest)msg).headers()) && (extensionsHeader = request.headers().getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS)) != null) {
            List<WebSocketExtensionData> extensions = WebSocketExtensionUtil.extractExtensions(extensionsHeader);
            int rsv = 0;
            for (WebSocketExtensionData extensionData : extensions) {
                Iterator<WebSocketServerExtensionHandshaker> extensionHandshakersIterator = this.extensionHandshakers.iterator();
                WebSocketExtension validExtension = null;
                while (validExtension == null && extensionHandshakersIterator.hasNext()) {
                    WebSocketServerExtensionHandshaker extensionHandshaker = extensionHandshakersIterator.next();
                    validExtension = extensionHandshaker.handshakeExtension(extensionData);
                }
                if (validExtension == null || (validExtension.rsv() & rsv) != 0) continue;
                if (this.validExtensions == null) {
                    this.validExtensions = new ArrayList<WebSocketServerExtension>(1);
                }
                rsv |= validExtension.rsv();
                this.validExtensions.add((WebSocketServerExtension)validExtension);
            }
        }
        ctx.fireChannelRead(msg);
    }

    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        HttpResponse httpResponse;
        if (msg instanceof HttpResponse && HttpResponseStatus.SWITCHING_PROTOCOLS.equals((httpResponse = (HttpResponse)msg).status())) {
            HttpHeaders headers = httpResponse.headers();
            FutureListener listener = null;
            if (WebSocketExtensionUtil.isWebsocketUpgrade(headers)) {
                if (this.validExtensions != null) {
                    String headerValue = headers.getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
                    ArrayList<WebSocketExtensionData> extraExtensions = new ArrayList<WebSocketExtensionData>(this.extensionHandshakers.size());
                    for (WebSocketServerExtension extension : this.validExtensions) {
                        extraExtensions.add(extension.newResponseData());
                    }
                    String newHeaderValue = WebSocketExtensionUtil.computeMergeExtensionsHeaderValue(headerValue, extraExtensions);
                    listener = future -> {
                        if (future.isSuccess()) {
                            for (WebSocketServerExtension extension : this.validExtensions) {
                                WebSocketExtensionDecoder decoder = extension.newExtensionDecoder();
                                WebSocketExtensionEncoder encoder = extension.newExtensionEncoder();
                                String name = ctx.name();
                                ctx.pipeline().addAfter(name, ((Object)((Object)decoder)).getClass().getName(), (ChannelHandler)decoder).addAfter(name, ((Object)((Object)encoder)).getClass().getName(), (ChannelHandler)encoder);
                            }
                        }
                    };
                    if (newHeaderValue != null) {
                        headers.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)newHeaderValue);
                    }
                }
                Future f = ctx.write((Object)httpResponse);
                if (listener != null) {
                    f.addListener(listener);
                }
                f.addListener(future -> {
                    if (future.isSuccess()) {
                        ctx.pipeline().remove((ChannelHandler)this);
                    }
                });
                return f;
            }
        }
        return ctx.write(msg);
    }
}

