/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.rtsp;

import io.netty5.buffer.api.Buffer;
import io.netty5.handler.codec.UnsupportedMessageTypeException;
import io.netty5.handler.codec.http.HttpMessage;
import io.netty5.handler.codec.http.HttpObjectEncoder;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.util.CharsetUtil;
import io.netty5.util.internal.StringUtil;

public class RtspEncoder
extends HttpObjectEncoder<HttpMessage> {
    private static final short CRLF_SHORT = 3338;

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return super.acceptOutboundMessage(msg) && (msg instanceof HttpRequest || msg instanceof HttpResponse);
    }

    @Override
    protected void encodeInitialLine(Buffer buf, HttpMessage message) throws Exception {
        if (message instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)message;
            buf.writeCharSequence((CharSequence)request.method().asciiName(), CharsetUtil.US_ASCII);
            buf.writeByte((byte)32);
            buf.writeCharSequence((CharSequence)request.uri(), CharsetUtil.UTF_8);
            buf.writeByte((byte)32);
            buf.writeCharSequence((CharSequence)request.protocolVersion().toString(), CharsetUtil.US_ASCII);
            buf.writeShort((short)3338);
        } else if (message instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)message;
            buf.writeCharSequence((CharSequence)response.protocolVersion().toString(), CharsetUtil.US_ASCII);
            buf.writeByte((byte)32);
            buf.writeCharSequence((CharSequence)response.status().codeAsText(), CharsetUtil.US_ASCII);
            buf.writeByte((byte)32);
            buf.writeCharSequence((CharSequence)response.status().reasonPhrase(), CharsetUtil.US_ASCII);
            buf.writeShort((short)3338);
        } else {
            throw new UnsupportedMessageTypeException("Unsupported type " + StringUtil.simpleClassName((Object)message));
        }
    }
}

