/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelOption;
import io.netty5.handler.codec.CodecException;
import io.netty5.handler.codec.MessageToMessageDecoder;
import io.netty5.handler.codec.compression.Decompressor;
import io.netty5.handler.codec.http.DefaultHttpContent;
import io.netty5.handler.codec.http.DefaultHttpMessage;
import io.netty5.handler.codec.http.DefaultHttpRequest;
import io.netty5.handler.codec.http.DefaultHttpResponse;
import io.netty5.handler.codec.http.DefaultLastHttpContent;
import io.netty5.handler.codec.http.EmptyLastHttpContent;
import io.netty5.handler.codec.http.HttpContent;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.netty5.handler.codec.http.HttpMessage;
import io.netty5.handler.codec.http.HttpObject;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.handler.codec.http.LastHttpContent;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.util.AsciiString;
import io.netty5.util.Resource;

public abstract class HttpContentDecoder
extends MessageToMessageDecoder<HttpObject> {
    static final String IDENTITY = HttpHeaderValues.IDENTITY.toString();
    protected ChannelHandlerContext ctx;
    private Decompressor decompressor;
    private boolean continueResponse;
    private boolean needRead = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeAndClose(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        boolean dispose = true;
        try {
            if (msg instanceof HttpResponse && ((HttpResponse)msg).status().code() == 100) {
                if (!(msg instanceof LastHttpContent)) {
                    this.continueResponse = true;
                }
                this.fireChannelRead(ctx, msg);
                return;
            }
            if (this.continueResponse) {
                if (msg instanceof LastHttpContent) {
                    this.continueResponse = false;
                }
                this.fireChannelRead(ctx, msg);
                return;
            }
            if (msg instanceof HttpMessage) {
                String targetContentEncoding;
                int idx;
                CharSequence transferEncoding;
                this.cleanup();
                HttpMessage message = (HttpMessage)msg;
                HttpHeaders headers = message.headers();
                CharSequence contentEncoding = headers.get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
                contentEncoding = contentEncoding != null ? AsciiString.trim((CharSequence)contentEncoding) : ((transferEncoding = headers.get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) != null ? ((idx = AsciiString.indexOf((CharSequence)transferEncoding, (char)',', (int)0)) != -1 ? AsciiString.trim((CharSequence)AsciiString.substring((CharSequence)transferEncoding, (int)0, (int)idx)) : AsciiString.trim((CharSequence)transferEncoding)) : IDENTITY);
                this.decompressor = this.newContentDecoder(contentEncoding);
                if (this.decompressor == null) {
                    dispose = false;
                    this.fireChannelRead(ctx, message);
                    return;
                }
                if (headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                    headers.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                    headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (CharSequence)HttpHeaderValues.CHUNKED);
                }
                if (HttpHeaderValues.IDENTITY.contentEquals((CharSequence)(targetContentEncoding = this.getTargetContentEncoding(contentEncoding)))) {
                    headers.remove((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
                } else {
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (CharSequence)targetContentEncoding);
                }
                if (message instanceof HttpContent) {
                    DefaultHttpMessage copy;
                    if (message instanceof HttpRequest) {
                        HttpRequest r = (HttpRequest)message;
                        copy = new DefaultHttpRequest(r.protocolVersion(), r.method(), r.uri());
                    } else if (message instanceof HttpResponse) {
                        HttpResponse r = (HttpResponse)message;
                        copy = new DefaultHttpResponse(r.protocolVersion(), r.status());
                    } else {
                        throw new CodecException("Object of class " + message.getClass().getName() + " is not an HttpRequest or HttpResponse");
                    }
                    copy.headers().set(message.headers());
                    copy.setDecoderResult(message.decoderResult());
                    this.fireChannelRead(ctx, copy);
                } else {
                    this.fireChannelRead(ctx, message);
                }
            }
            if (msg instanceof HttpContent) {
                HttpContent c = (HttpContent)msg;
                if (this.decompressor == null) {
                    dispose = false;
                    this.fireChannelRead(ctx, c);
                } else {
                    this.decodeContent(ctx, c);
                }
            }
        }
        finally {
            if (dispose) {
                Resource.dispose((Object)msg);
            }
        }
    }

    private void decodeContent(ChannelHandlerContext ctx, HttpContent<?> c) {
        Buffer payload = c.payload();
        assert (this.decompressor != null);
        while (!this.decompressor.isFinished()) {
            int idx = payload.readerOffset();
            Buffer decompressed = this.decompressor.decompress(payload, ctx.bufferAllocator());
            if (decompressed != null) {
                if (decompressed.readableBytes() == 0) {
                    decompressed.close();
                    return;
                }
                ctx.fireChannelRead((Object)new DefaultHttpContent(decompressed));
                continue;
            }
            if (idx != payload.readerOffset()) continue;
            break;
        }
        if (c instanceof LastHttpContent) {
            this.decompressor.close();
            this.decompressor = null;
            LastHttpContent last = (LastHttpContent)c;
            HttpHeaders headers = last.trailingHeaders();
            if (headers.isEmpty()) {
                this.fireChannelRead(ctx, new EmptyLastHttpContent(ctx.bufferAllocator()));
            } else {
                this.fireChannelRead(ctx, new DefaultLastHttpContent(ctx.bufferAllocator().allocate(0), headers));
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        boolean needRead = this.needRead;
        this.needRead = true;
        try {
            ctx.fireChannelReadComplete();
        }
        finally {
            if (needRead && !((Boolean)ctx.channel().getOption(ChannelOption.AUTO_READ)).booleanValue()) {
                ctx.read();
            }
        }
    }

    protected abstract Decompressor newContentDecoder(CharSequence var1) throws Exception;

    protected String getTargetContentEncoding(CharSequence contentEncoding) throws Exception {
        return IDENTITY;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.cleanupSafely(ctx);
        super.handlerRemoved(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.cleanupSafely(ctx);
        super.channelInactive(ctx);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        super.handlerAdded(ctx);
    }

    private void cleanup() {
        if (this.decompressor != null) {
            this.decompressor.close();
            this.decompressor = null;
        }
    }

    private void cleanupSafely(ChannelHandlerContext ctx) {
        try {
            this.cleanup();
        }
        catch (Throwable cause) {
            ctx.fireChannelExceptionCaught(cause);
        }
    }

    private void fireChannelRead(ChannelHandlerContext ctx, Object msg) {
        this.needRead = false;
        ctx.fireChannelRead(msg);
    }
}

