/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.Buffer;
import io.netty5.handler.codec.http.HttpObjectEncoder;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpResponse;
import java.nio.charset.StandardCharsets;

public class HttpRequestEncoder
extends HttpObjectEncoder<HttpRequest> {
    private static final char SLASH = '/';
    private static final char QUESTION_MARK = '?';
    private static final short SLASH_AND_SPACE_SHORT = 12064;
    private static final int SPACE_SLASH_AND_SPACE_MEDIUM = 0x202F20;

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return super.acceptOutboundMessage(msg) && !(msg instanceof HttpResponse);
    }

    @Override
    protected void encodeInitialLine(Buffer buf, HttpRequest request) throws Exception {
        buf.writeCharSequence((CharSequence)request.method().asciiName(), StandardCharsets.US_ASCII);
        String uri = request.uri();
        if (uri.isEmpty()) {
            buf.writeMedium(0x202F20);
        } else {
            CharSequence uriCharSequence = uri;
            boolean needSlash = false;
            int start = uri.indexOf("://");
            if (start != -1 && uri.charAt(0) != '/') {
                int index = uri.indexOf(63, start += 3);
                if (index == -1) {
                    if (uri.lastIndexOf(47) < start) {
                        needSlash = true;
                    }
                } else if (uri.lastIndexOf(47, index) < start) {
                    uriCharSequence = new StringBuilder(uri).insert(index, '/');
                }
            }
            buf.writeByte((byte)32).writeCharSequence(uriCharSequence, StandardCharsets.UTF_8);
            if (needSlash) {
                buf.writeShort((short)12064);
            } else {
                buf.writeByte((byte)32);
            }
        }
        request.protocolVersion().encode(buf);
        buf.writeShort((short)3338);
    }
}

