/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.cors;

import io.netty5.handler.codec.DateFormatter;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpMethod;
import io.netty5.handler.codec.http.cors.CorsConfig;
import io.netty5.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public final class CorsConfigBuilder {
    final Set<String> origins;
    final boolean anyOrigin;
    boolean allowNullOrigin;
    boolean enabled = true;
    boolean allowCredentials;
    final Set<String> exposeHeaders = new HashSet<String>();
    long maxAge;
    final Set<HttpMethod> requestMethods = new HashSet<HttpMethod>();
    final Set<String> requestHeaders = new HashSet<String>();
    final Map<CharSequence, List<Callable<CharSequence>>> preflightHeaders = new HashMap<CharSequence, List<Callable<CharSequence>>>();
    private boolean noPreflightHeaders;
    boolean shortCircuit;
    boolean allowPrivateNetwork;

    public static CorsConfigBuilder forAnyOrigin() {
        return new CorsConfigBuilder();
    }

    public static CorsConfigBuilder forOrigin(String origin) {
        if ("*".equals(origin)) {
            return new CorsConfigBuilder();
        }
        return new CorsConfigBuilder(origin);
    }

    public static CorsConfigBuilder forOrigins(String ... origins) {
        return new CorsConfigBuilder(origins);
    }

    CorsConfigBuilder(String ... origins) {
        this.origins = new LinkedHashSet<String>(Arrays.asList(origins));
        this.anyOrigin = false;
    }

    CorsConfigBuilder() {
        this.anyOrigin = true;
        this.origins = Collections.emptySet();
    }

    public CorsConfigBuilder allowNullOrigin() {
        this.allowNullOrigin = true;
        return this;
    }

    public CorsConfigBuilder disable() {
        this.enabled = false;
        return this;
    }

    public CorsConfigBuilder exposeHeaders(String ... headers) {
        this.exposeHeaders.addAll(Arrays.asList(headers));
        return this;
    }

    public CorsConfigBuilder exposeHeaders(CharSequence ... headers) {
        for (CharSequence header : headers) {
            this.exposeHeaders.add(header.toString());
        }
        return this;
    }

    public CorsConfigBuilder allowCredentials() {
        this.allowCredentials = true;
        return this;
    }

    public CorsConfigBuilder maxAge(long max) {
        this.maxAge = max;
        return this;
    }

    public CorsConfigBuilder allowedRequestMethods(HttpMethod ... methods) {
        this.requestMethods.addAll(Arrays.asList(methods));
        return this;
    }

    public CorsConfigBuilder allowedRequestHeaders(String ... headers) {
        this.requestHeaders.addAll(Arrays.asList(headers));
        return this;
    }

    public CorsConfigBuilder allowedRequestHeaders(CharSequence ... headers) {
        for (CharSequence header : headers) {
            this.requestHeaders.add(header.toString());
        }
        return this;
    }

    public CorsConfigBuilder preflightResponseHeader(CharSequence name, CharSequence ... values) {
        List<Callable<CharSequence>> callables = this.preflightHeader(name);
        for (CharSequence value : values) {
            callables.add(new ConstantValueGenerator(value));
        }
        return this;
    }

    public <T> CorsConfigBuilder preflightResponseHeader(CharSequence name, Iterable<CharSequence> values) {
        List<Callable<CharSequence>> callables = this.preflightHeader(name);
        for (CharSequence value : values) {
            callables.add(new ConstantValueGenerator(value));
        }
        return this;
    }

    public <T> CorsConfigBuilder preflightResponseHeader(CharSequence name, Callable<CharSequence> valueGenerator) {
        this.preflightHeader(name).add(valueGenerator);
        return this;
    }

    public CorsConfigBuilder noPreflightResponseHeaders() {
        this.noPreflightHeaders = true;
        return this;
    }

    public CorsConfigBuilder shortCircuit() {
        this.shortCircuit = true;
        return this;
    }

    public CorsConfigBuilder allowPrivateNetwork() {
        this.allowPrivateNetwork = true;
        return this;
    }

    public CorsConfig build() {
        if (this.preflightHeaders.isEmpty() && !this.noPreflightHeaders) {
            this.preflightHeader((CharSequence)HttpHeaderNames.DATE).add(DateValueGenerator.INSTANCE);
            this.preflightHeader((CharSequence)HttpHeaderNames.CONTENT_LENGTH).add(new ConstantValueGenerator("0"));
        }
        return new CorsConfig(this);
    }

    private List<Callable<CharSequence>> preflightHeader(CharSequence name) {
        return this.preflightHeaders.computeIfAbsent(name, k -> new ArrayList());
    }

    private static final class DateValueGenerator
    implements Callable<CharSequence> {
        static final DateValueGenerator INSTANCE = new DateValueGenerator();

        private DateValueGenerator() {
        }

        @Override
        public CharSequence call() throws Exception {
            return DateFormatter.format((Date)new Date());
        }
    }

    private static final class ConstantValueGenerator
    implements Callable<CharSequence> {
        private final CharSequence value;

        private ConstantValueGenerator(CharSequence value) {
            this.value = (CharSequence)ObjectUtil.checkNotNullWithIAE((Object)value, (String)"value");
        }

        @Override
        public CharSequence call() {
            return this.value;
        }
    }
}

