/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.headers;

import io.netty5.handler.codec.http.headers.HeaderUtils;
import io.netty5.handler.codec.http.headers.HeaderValidationException;
import io.netty5.handler.codec.http.headers.HttpHeaderValidationUtil;
import io.netty5.handler.codec.http.headers.HttpSetCookie;
import io.netty5.util.AsciiString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultHttpSetCookie
implements HttpSetCookie {
    private static final String ENCODED_LABEL_DOMAIN = "; domain=";
    private static final String ENCODED_LABEL_PATH = "; path=";
    private static final String ENCODED_LABEL_EXPIRES = "; expires=";
    private static final String ENCODED_LABEL_MAX_AGE = "; max-age=";
    private static final String ENCODED_LABEL_HTTP_ONLY = "; httponly";
    private static final String ENCODED_LABEL_SECURE = "; secure";
    private static final String ENCODED_LABEL_SAMESITE = "; samesite=";
    private final CharSequence name;
    private final CharSequence value;
    @Nullable
    private final CharSequence path;
    @Nullable
    private final CharSequence domain;
    @Nullable
    private final CharSequence expires;
    @Nullable
    private final Long maxAge;
    @Nullable
    private final HttpSetCookie.SameSite sameSite;
    private final boolean wrapped;
    private final boolean secure;
    private final boolean httpOnly;

    private static ParseState parseStateOf(CharSequence fieldName) {
        int len = fieldName.length();
        if (len >= 4 && len <= 8) {
            if (len < 7) {
                if (len == 4) {
                    if (AsciiString.contentEqualsIgnoreCase((CharSequence)"path", (CharSequence)fieldName)) {
                        return ParseState.ParsingPath;
                    }
                } else if (len == 6 && AsciiString.contentEqualsIgnoreCase((CharSequence)"domain", (CharSequence)fieldName)) {
                    return ParseState.ParsingDomain;
                }
            } else if (len == 7) {
                if (AsciiString.contentEqualsIgnoreCase((CharSequence)"expires", (CharSequence)fieldName)) {
                    return ParseState.ParsingExpires;
                }
                if (AsciiString.contentEqualsIgnoreCase((CharSequence)"max-age", (CharSequence)fieldName)) {
                    return ParseState.ParsingMaxAge;
                }
            } else if (AsciiString.contentEqualsIgnoreCase((CharSequence)"samesite", (CharSequence)fieldName)) {
                return ParseState.ParsingSameSite;
            }
        }
        return ParseState.Unknown;
    }

    public DefaultHttpSetCookie(CharSequence name, CharSequence value) {
        this(name, value, false, false, false);
    }

    public DefaultHttpSetCookie(CharSequence name, CharSequence value, boolean wrapped, boolean secure, boolean httpOnly) {
        this(name, value, null, null, null, null, null, wrapped, secure, httpOnly);
    }

    public DefaultHttpSetCookie(CharSequence name, CharSequence value, @Nullable CharSequence path, @Nullable CharSequence domain, @Nullable CharSequence expires, @Nullable Long maxAge, @Nullable HttpSetCookie.SameSite sameSite, boolean wrapped, boolean secure, boolean httpOnly) {
        HeaderUtils.validateCookieNameAndValue(name, value);
        this.name = name;
        this.value = value;
        this.path = path;
        this.domain = domain;
        this.expires = expires;
        this.maxAge = maxAge;
        this.sameSite = sameSite;
        this.wrapped = wrapped;
        this.secure = secure;
        this.httpOnly = httpOnly;
    }

    static HttpSetCookie parseSetCookie(CharSequence setCookieString, boolean validateContent, @Nullable CharSequence name, int i) {
        int begin;
        ParseState parseState;
        CharSequence value = null;
        CharSequence path = null;
        CharSequence domain = null;
        CharSequence expires = null;
        Long maxAge = null;
        HttpSetCookie.SameSite sameSite = null;
        boolean isWrapped = false;
        boolean isSecure = false;
        boolean isHttpOnly = false;
        if (name != null) {
            parseState = ParseState.ParsingValue;
            begin = i;
        } else {
            parseState = ParseState.Unknown;
            begin = 0;
        }
        int length = setCookieString.length();
        block27: while (i < length) {
            char c = setCookieString.charAt(i);
            switch (c) {
                case '=': {
                    if (name == null) {
                        int index;
                        if (i <= begin) {
                            throw new IllegalArgumentException("cookie name cannot be null or empty");
                        }
                        name = setCookieString.subSequence(begin, i);
                        if (validateContent && (index = HttpHeaderValidationUtil.validateToken(name)) != -1) {
                            throw new HeaderValidationException("a cookie name can only contain \"token\" characters, but found invalid character 0x" + Integer.toHexString(c) + " at index " + index + " of header '" + name + "'.");
                        }
                        parseState = ParseState.ParsingValue;
                    } else if (parseState == ParseState.Unknown) {
                        CharSequence avName = setCookieString.subSequence(begin, i);
                        parseState = DefaultHttpSetCookie.parseStateOf(avName);
                    } else {
                        if (parseState == ParseState.ParsingValue) {
                            ++i;
                            continue block27;
                        }
                        throw new IllegalArgumentException("unexpected = at index: " + i);
                    }
                    begin = ++i;
                    continue block27;
                }
                case '\"': {
                    if (parseState == ParseState.ParsingValue) {
                        if (isWrapped) {
                            parseState = ParseState.Unknown;
                            value = setCookieString.subSequence(begin, i);
                            i = validateContent ? (i += 3) : (i += i + 2 < length && setCookieString.charAt(i + 2) == ' ' ? 3 : 2);
                        } else {
                            isWrapped = true;
                        }
                        begin = ++i;
                        continue block27;
                    }
                    if (value == null) {
                        throw new IllegalArgumentException("unexpected quote at index: " + i);
                    }
                    ++i;
                    continue block27;
                }
                case ';': {
                    if (i + 1 == length && validateContent) {
                        throw new IllegalArgumentException("unexpected trailing ';'");
                    }
                    switch (parseState) {
                        case ParsingValue: {
                            value = setCookieString.subSequence(begin, i);
                            break;
                        }
                        case ParsingPath: {
                            path = setCookieString.subSequence(begin, i);
                            break;
                        }
                        case ParsingDomain: {
                            domain = setCookieString.subSequence(begin, i);
                            break;
                        }
                        case ParsingExpires: {
                            expires = setCookieString.subSequence(begin, i);
                            break;
                        }
                        case ParsingMaxAge: {
                            maxAge = Long.parseLong(setCookieString, begin, i, 10);
                            break;
                        }
                        case ParsingSameSite: {
                            sameSite = DefaultHttpSetCookie.fromSequence(setCookieString, begin, i);
                            break;
                        }
                        default: {
                            if (name == null) {
                                throw new IllegalArgumentException("cookie value not found at index " + i);
                            }
                            CharSequence avName = setCookieString.subSequence(begin, i);
                            if (AsciiString.contentEqualsIgnoreCase((CharSequence)avName, (CharSequence)"secure")) {
                                isSecure = true;
                                break;
                            }
                            if (!AsciiString.contentEqualsIgnoreCase((CharSequence)avName, (CharSequence)"httponly")) break;
                            isHttpOnly = true;
                        }
                    }
                    parseState = ParseState.Unknown;
                    if (validateContent) {
                        if (i + 1 >= length || ' ' != setCookieString.charAt(i + 1)) {
                            throw new IllegalArgumentException("a space is required after ; in cookie attribute-value lists");
                        }
                        i += 2;
                    } else if (++i >= length || ' ' == setCookieString.charAt(i)) {
                        // empty if block
                    }
                    begin = ++i;
                    continue block27;
                }
            }
            if (validateContent) {
                if (parseState == ParseState.ParsingValue) {
                    DefaultHttpSetCookie.validateCookieOctetHexValue(c, i);
                } else {
                    DefaultHttpSetCookie.validateCookieAttributeValue(c, i);
                }
            }
            ++i;
        }
        if (begin < i) {
            switch (parseState) {
                case ParsingValue: {
                    value = setCookieString.subSequence(begin, i);
                    break;
                }
                case ParsingPath: {
                    path = setCookieString.subSequence(begin, i);
                    break;
                }
                case ParsingDomain: {
                    domain = setCookieString.subSequence(begin, i);
                    break;
                }
                case ParsingExpires: {
                    expires = setCookieString.subSequence(begin, i);
                    break;
                }
                case ParsingSameSite: {
                    sameSite = DefaultHttpSetCookie.fromSequence(setCookieString, begin, i);
                    break;
                }
                case ParsingMaxAge: {
                    maxAge = Long.parseLong(setCookieString, begin, i, 10);
                    break;
                }
                default: {
                    if (name == null) {
                        throw new IllegalArgumentException("cookie value not found at index " + i);
                    }
                    CharSequence avName = setCookieString.subSequence(begin, i);
                    if (AsciiString.contentEqualsIgnoreCase((CharSequence)avName, (CharSequence)"secure")) {
                        isSecure = true;
                        break;
                    }
                    if (AsciiString.contentEqualsIgnoreCase((CharSequence)avName, (CharSequence)"httponly")) {
                        isHttpOnly = true;
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (begin == i) {
            switch (parseState) {
                case ParsingValue: {
                    if (isWrapped) break;
                    value = "";
                    break;
                }
                case ParsingPath: {
                    path = "";
                    break;
                }
                case ParsingDomain: {
                    domain = "";
                    break;
                }
                case Unknown: {
                    break;
                }
                default: {
                    throw new Error("Unhandled parse state: " + parseState);
                }
            }
        }
        assert (name != null && value != null);
        return new DefaultHttpSetCookie(name, value, path, domain, expires, maxAge, sameSite, isWrapped, isSecure, isHttpOnly);
    }

    public static HttpSetCookie parseSetCookie(CharSequence setCookieString, boolean validateContent) {
        return DefaultHttpSetCookie.parseSetCookie(setCookieString, validateContent, null, 0);
    }

    @Override
    public CharSequence name() {
        return this.name;
    }

    @Override
    public CharSequence value() {
        return this.value;
    }

    @Override
    public boolean isWrapped() {
        return this.wrapped;
    }

    @Override
    @Nullable
    public CharSequence domain() {
        return this.domain;
    }

    @Override
    @Nullable
    public CharSequence path() {
        return this.path;
    }

    @Override
    @Nullable
    public Long maxAge() {
        return this.maxAge;
    }

    @Override
    @Nullable
    public CharSequence expires() {
        return this.expires;
    }

    @Override
    @Nullable
    public HttpSetCookie.SameSite sameSite() {
        return this.sameSite;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Override
    public CharSequence encoded() {
        StringBuilder sb = new StringBuilder(1 + this.name.length() + this.value.length() + (this.wrapped ? 2 : 0) + (this.domain != null ? ENCODED_LABEL_DOMAIN.length() + this.domain.length() : 0) + (this.path != null ? ENCODED_LABEL_PATH.length() + this.path.length() : 0) + (this.expires != null ? ENCODED_LABEL_EXPIRES.length() + this.expires.length() : 0) + (this.maxAge != null ? ENCODED_LABEL_MAX_AGE.length() + 11 : 0) + (this.sameSite != null ? ENCODED_LABEL_SAMESITE.length() + HttpSetCookie.SameSite.Strict.toString().length() : 0) + (this.httpOnly ? ENCODED_LABEL_HTTP_ONLY.length() : 0) + (this.secure ? ENCODED_LABEL_SECURE.length() : 0));
        sb.append(this.name).append('=');
        if (this.wrapped) {
            sb.append('\"').append(this.value).append('\"');
        } else {
            sb.append(this.value);
        }
        if (this.domain != null) {
            sb.append(ENCODED_LABEL_DOMAIN);
            sb.append(this.domain);
        }
        if (this.path != null) {
            sb.append(ENCODED_LABEL_PATH);
            sb.append(this.path);
        }
        if (this.expires != null) {
            sb.append(ENCODED_LABEL_EXPIRES);
            sb.append(this.expires);
        }
        if (this.maxAge != null) {
            sb.append(ENCODED_LABEL_MAX_AGE);
            sb.append(this.maxAge);
        }
        if (this.sameSite != null) {
            sb.append(ENCODED_LABEL_SAMESITE);
            sb.append((Object)this.sameSite);
        }
        if (this.httpOnly) {
            sb.append(ENCODED_LABEL_HTTP_ONLY);
        }
        if (this.secure) {
            sb.append(ENCODED_LABEL_SECURE);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpSetCookie)) {
            return false;
        }
        HttpSetCookie rhs = (HttpSetCookie)o;
        return AsciiString.contentEquals((CharSequence)this.name, (CharSequence)rhs.name()) && AsciiString.contentEquals((CharSequence)this.value, (CharSequence)rhs.value()) && AsciiString.contentEqualsIgnoreCase((CharSequence)this.domain, (CharSequence)rhs.domain()) && AsciiString.contentEquals((CharSequence)this.path, (CharSequence)rhs.path());
    }

    public int hashCode() {
        int hash = 31 + AsciiString.hashCode((CharSequence)this.name);
        hash = 31 * hash + AsciiString.hashCode((CharSequence)this.value);
        if (this.domain != null) {
            hash = 31 * hash + AsciiString.hashCode((CharSequence)this.domain);
        }
        if (this.path != null) {
            hash = 31 * hash + AsciiString.hashCode((CharSequence)this.path);
        }
        return hash;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + "]";
    }

    @Nullable
    private static HttpSetCookie.SameSite fromSequence(CharSequence cs, int begin, int end) {
        switch (end - begin) {
            case 3: {
                if (!DefaultHttpSetCookie.equalsIgnoreCaseLower(cs.charAt(begin), 'l') || !DefaultHttpSetCookie.equalsIgnoreCaseLower(cs.charAt(begin + 1), 'a') || !DefaultHttpSetCookie.equalsIgnoreCaseLower(cs.charAt(begin + 2), 'x')) break;
                return HttpSetCookie.SameSite.Lax;
            }
            case 4: {
                if (!DefaultHttpSetCookie.equalsIgnoreCaseLower(cs.charAt(begin), 'n') || !DefaultHttpSetCookie.equalsIgnoreCaseLower(cs.charAt(begin + 1), 'o') || !DefaultHttpSetCookie.equalsIgnoreCaseLower(cs.charAt(begin + 2), 'n') || !DefaultHttpSetCookie.equalsIgnoreCaseLower(cs.charAt(begin + 3), 'e')) break;
                return HttpSetCookie.SameSite.None;
            }
            case 6: {
                if (!DefaultHttpSetCookie.equalsIgnoreCaseLower(cs.charAt(begin), 's') || !DefaultHttpSetCookie.equalsIgnoreCaseLower(cs.charAt(begin + 1), 't') || !DefaultHttpSetCookie.equalsIgnoreCaseLower(cs.charAt(begin + 2), 'r') || !DefaultHttpSetCookie.equalsIgnoreCaseLower(cs.charAt(begin + 3), 'i') || !DefaultHttpSetCookie.equalsIgnoreCaseLower(cs.charAt(begin + 4), 'c') || !DefaultHttpSetCookie.equalsIgnoreCaseLower(cs.charAt(begin + 5), 't')) break;
                return HttpSetCookie.SameSite.Strict;
            }
        }
        return null;
    }

    private static boolean equalsIgnoreCaseLower(char c, char k) {
        return c == k || c >= 'A' && c <= 'Z' && c == k - 32;
    }

    private static void validateCookieOctetHexValue(int hexValue, int index) {
        if (!(hexValue == 33 || hexValue >= 35 && hexValue <= 43 || hexValue >= 45 && hexValue <= 58 || hexValue >= 60 && hexValue <= 91 || hexValue >= 93 && hexValue <= 126)) {
            throw DefaultHttpSetCookie.unexpectedHexValue(hexValue, index);
        }
    }

    private static void validateCookieAttributeValue(int hexValue, int index) {
        if (hexValue == 59 || hexValue == 127 || hexValue <= 31) {
            throw DefaultHttpSetCookie.unexpectedHexValue(hexValue, index);
        }
    }

    @NotNull
    private static IllegalArgumentException unexpectedHexValue(int hexValue, int index) {
        return new IllegalArgumentException("Unexpected hex value at index " + index + ": 0x" + Integer.toHexString(hexValue));
    }

    private static enum ParseState {
        ParsingValue,
        ParsingPath,
        ParsingDomain,
        ParsingExpires,
        ParsingMaxAge,
        ParsingSameSite,
        Unknown;

    }
}

