/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.headers;

import io.netty5.handler.codec.http.headers.DefaultHttpCookiePair;
import io.netty5.handler.codec.http.headers.DefaultHttpHeaders;
import io.netty5.handler.codec.http.headers.DefaultHttpSetCookie;
import io.netty5.handler.codec.http.headers.HeaderUtils;
import io.netty5.handler.codec.http.headers.HttpCookiePair;
import io.netty5.handler.codec.http.headers.HttpSetCookie;
import io.netty5.util.AsciiString;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nullable;

public interface HttpHeaders
extends Iterable<Map.Entry<CharSequence, CharSequence>> {
    public static HttpHeaders emptyHeaders() {
        return HttpHeaders.newHeaders(2, false, false, false);
    }

    public static HttpHeaders newHeaders() {
        return HttpHeaders.newHeaders(true);
    }

    public static HttpHeaders newHeaders(boolean validate) {
        return HttpHeaders.newHeaders(16, validate, validate, validate);
    }

    public static HttpHeaders newHeaders(int sizeHint, boolean checkNames, boolean checkCookies, boolean checkValues) {
        return new DefaultHttpHeaders(sizeHint, checkNames, checkCookies, checkValues);
    }

    public HttpHeaders copy();

    @Nullable
    public CharSequence get(CharSequence var1);

    default public CharSequence get(CharSequence name, CharSequence defaultValue) {
        CharSequence value = this.get(name);
        return value != null ? value : defaultValue;
    }

    @Nullable
    public CharSequence getAndRemove(CharSequence var1);

    default public CharSequence getAndRemove(CharSequence name, CharSequence defaultValue) {
        CharSequence value = this.getAndRemove(name);
        return value == null ? defaultValue : value;
    }

    default public Iterable<CharSequence> values(CharSequence name) {
        return () -> this.valuesIterator(name);
    }

    public Iterator<CharSequence> valuesIterator(CharSequence var1);

    default public boolean contains(CharSequence name) {
        return this.get(name) != null;
    }

    default public boolean contains(CharSequence name, CharSequence value) {
        return AsciiString.contentEquals((CharSequence)this.get(name), (CharSequence)value);
    }

    default public boolean containsIgnoreCase(CharSequence name, CharSequence value) {
        return AsciiString.contentEqualsIgnoreCase((CharSequence)this.get(name), (CharSequence)value);
    }

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set<CharSequence> names();

    public HttpHeaders add(CharSequence var1, CharSequence var2);

    public HttpHeaders add(CharSequence var1, Iterable<? extends CharSequence> var2);

    default public HttpHeaders add(CharSequence name, Iterator<? extends CharSequence> valuesItr) {
        while (valuesItr.hasNext()) {
            this.add(name, valuesItr.next());
        }
        return this;
    }

    public HttpHeaders add(CharSequence var1, CharSequence ... var2);

    public HttpHeaders add(HttpHeaders var1);

    public HttpHeaders set(CharSequence var1, CharSequence var2);

    public HttpHeaders set(CharSequence var1, Iterable<? extends CharSequence> var2);

    default public HttpHeaders set(CharSequence name, Iterator<? extends CharSequence> valueItr) {
        this.remove(name);
        while (valueItr.hasNext()) {
            this.add(name, valueItr.next());
        }
        return this;
    }

    default public HttpHeaders set(CharSequence name, CharSequence ... values) {
        this.remove(name);
        for (CharSequence value : values) {
            this.add(name, value);
        }
        return this;
    }

    default public HttpHeaders set(HttpHeaders headers) {
        if (headers != this) {
            this.clear();
            this.add(headers);
        }
        return this;
    }

    default public HttpHeaders replace(HttpHeaders headers) {
        if (headers != this) {
            for (CharSequence key : headers.names()) {
                this.remove(key);
            }
            this.add(headers);
        }
        return this;
    }

    public boolean remove(CharSequence var1);

    public boolean remove(CharSequence var1, CharSequence var2);

    public boolean removeIgnoreCase(CharSequence var1, CharSequence var2);

    public HttpHeaders clear();

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator();

    @Override
    default public Spliterator<Map.Entry<CharSequence, CharSequence>> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 64);
    }

    public String toString();

    default public String toString(BiFunction<? super CharSequence, ? super CharSequence, CharSequence> filter) {
        return HeaderUtils.toString(this, filter);
    }

    @Nullable
    public HttpCookiePair getCookie(CharSequence var1);

    @Nullable
    public HttpSetCookie getSetCookie(CharSequence var1);

    default public Iterable<HttpCookiePair> getCookies() {
        return () -> this.getCookiesIterator();
    }

    public Iterator<HttpCookiePair> getCookiesIterator();

    default public Iterable<HttpCookiePair> getCookies(CharSequence name) {
        return () -> this.getCookiesIterator(name);
    }

    public Iterator<HttpCookiePair> getCookiesIterator(CharSequence var1);

    default public Iterable<HttpSetCookie> getSetCookies() {
        return () -> this.getSetCookiesIterator();
    }

    public Iterator<HttpSetCookie> getSetCookiesIterator();

    default public Iterable<HttpSetCookie> getSetCookies(CharSequence name) {
        return () -> this.getSetCookiesIterator(name);
    }

    public Iterator<HttpSetCookie> getSetCookiesIterator(CharSequence var1);

    default public Iterable<HttpSetCookie> getSetCookies(CharSequence name, CharSequence domain, CharSequence path) {
        return () -> this.getSetCookiesIterator(name, domain, path);
    }

    public Iterator<HttpSetCookie> getSetCookiesIterator(CharSequence var1, CharSequence var2, CharSequence var3);

    public HttpHeaders addCookie(HttpCookiePair var1);

    default public HttpHeaders addCookie(CharSequence name, CharSequence value) {
        return this.addCookie(new DefaultHttpCookiePair(name, value));
    }

    public HttpHeaders addSetCookie(HttpSetCookie var1);

    default public HttpHeaders addSetCookie(CharSequence name, CharSequence value) {
        return this.addSetCookie(new DefaultHttpSetCookie(name, value));
    }

    public boolean removeCookies(CharSequence var1);

    public boolean removeSetCookies(CharSequence var1);

    public boolean removeSetCookies(CharSequence var1, CharSequence var2, CharSequence var3);
}

