/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.headers;

import io.netty5.handler.codec.DateFormatter;
import io.netty5.handler.codec.http.headers.HttpCookiePair;
import java.util.Date;
import org.jetbrains.annotations.Nullable;

public interface HttpSetCookie
extends HttpCookiePair {
    @Nullable
    public CharSequence domain();

    @Nullable
    public CharSequence path();

    @Nullable
    public Long maxAge();

    @Nullable
    public CharSequence expires();

    @Nullable
    default public Long expiresAsMaxAge() {
        Date expiresDate;
        CharSequence expires = this.expires();
        if (expires != null && (expiresDate = DateFormatter.parseHttpDate((CharSequence)expires)) != null) {
            long maxAgeMillis = expiresDate.getTime() - System.currentTimeMillis();
            return maxAgeMillis / 1000L + (long)(maxAgeMillis % 1000L != 0L ? 1 : 0);
        }
        return null;
    }

    @Nullable
    public SameSite sameSite();

    public boolean isSecure();

    public boolean isHttpOnly();

    public static enum SameSite {
        Lax,
        Strict,
        None;

    }
}

