/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx;

import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.http.FullHttpResponse;
import io.netty5.handler.codec.http.websocketx.WebSocketClientHandshakeCompletionEvent;
import io.netty5.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty5.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty5.handler.codec.http.websocketx.WebSocketHandshakeTimeoutException;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

class WebSocketClientProtocolHandshakeHandler
implements ChannelHandler {
    private static final long DEFAULT_HANDSHAKE_TIMEOUT_MS = 10000L;
    private final WebSocketClientHandshaker handshaker;
    private final long handshakeTimeoutMillis;
    private ChannelHandlerContext ctx;
    private Promise<Void> handshakePromise;

    WebSocketClientProtocolHandshakeHandler(WebSocketClientHandshaker handshaker) {
        this(handshaker, 10000L);
    }

    WebSocketClientProtocolHandshakeHandler(WebSocketClientHandshaker handshaker, long handshakeTimeoutMillis) {
        this.handshaker = handshaker;
        this.handshakeTimeoutMillis = ObjectUtil.checkPositive((long)handshakeTimeoutMillis, (String)"handshakeTimeoutMillis");
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        this.handshakePromise = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelActive();
        this.handshaker.handshake(ctx.channel()).addListener(future -> {
            if (future.isFailed()) {
                this.handshakePromise.tryFailure(future.cause());
                ctx.fireChannelExceptionCaught(future.cause());
            }
        });
        this.applyHandshakeTimeout();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (!this.handshakePromise.isDone()) {
            this.handshakePromise.tryFailure((Throwable)new WebSocketClientHandshakeException("channel closed with handshake in progress"));
        }
        ctx.fireChannelInactive();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof FullHttpResponse)) {
            ctx.fireChannelRead(msg);
            return;
        }
        try (FullHttpResponse response = (FullHttpResponse)msg;){
            if (!this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(ctx.channel(), response);
                this.handshakePromise.trySuccess(null);
                ctx.fireChannelInboundEvent((Object)new WebSocketClientHandshakeCompletionEvent(this.handshaker.version()));
                ctx.pipeline().remove((ChannelHandler)this);
                return;
            }
            throw new IllegalStateException("WebSocketClientHandshaker should have been non finished yet");
        }
    }

    private void applyHandshakeTimeout() {
        Promise<Void> localHandshakePromise = this.handshakePromise;
        if (this.handshakeTimeoutMillis <= 0L || localHandshakePromise.isDone()) {
            return;
        }
        Future timeoutFuture = this.ctx.executor().schedule(() -> {
            if (localHandshakePromise.isDone()) {
                return;
            }
            WebSocketHandshakeTimeoutException exception = new WebSocketHandshakeTimeoutException("handshake timed out after " + this.handshakeTimeoutMillis + "ms");
            if (localHandshakePromise.tryFailure((Throwable)exception)) {
                this.ctx.flush().fireChannelInboundEvent((Object)new WebSocketClientHandshakeCompletionEvent(exception)).close();
            }
        }, this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
        localHandshakePromise.asFuture().addListener(f -> timeoutFuture.cancel());
    }

    Future<Void> getHandshakeFuture() {
        return this.handshakePromise.asFuture();
    }
}

