/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelOption;
import io.netty5.handler.codec.MessageToMessageDecoder;
import io.netty5.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty5.handler.codec.http.websocketx.WebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty5.util.Resource;
import io.netty5.util.Send;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;

abstract class WebSocketProtocolHandler
extends MessageToMessageDecoder<WebSocketFrame> {
    private final boolean dropPongFrames;
    private final WebSocketCloseStatus closeStatus;
    private final long forceCloseTimeoutMillis;
    private Promise<Void> closeSent;

    WebSocketProtocolHandler() {
        this(true);
    }

    WebSocketProtocolHandler(boolean dropPongFrames) {
        this(dropPongFrames, null, 0L);
    }

    WebSocketProtocolHandler(boolean dropPongFrames, WebSocketCloseStatus closeStatus, long forceCloseTimeoutMillis) {
        this.dropPongFrames = dropPongFrames;
        this.closeStatus = closeStatus;
        this.forceCloseTimeoutMillis = forceCloseTimeoutMillis;
    }

    protected void decode(ChannelHandlerContext ctx, WebSocketFrame msg) throws Exception {
        throw new UnsupportedOperationException("WebSocketProtocolHandler use decodeAndClose().");
    }

    protected void decodeAndClose(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        if (frame instanceof PingWebSocketFrame) {
            try (WebSocketFrame webSocketFrame = frame;){
                ctx.writeAndFlush((Object)new PongWebSocketFrame((Send<Buffer>)frame.binaryData().send()));
            }
            WebSocketProtocolHandler.readIfNeeded(ctx);
            return;
        }
        if (frame instanceof PongWebSocketFrame && this.dropPongFrames) {
            frame.close();
            WebSocketProtocolHandler.readIfNeeded(ctx);
            return;
        }
        ctx.fireChannelRead((Object)frame);
    }

    private static void readIfNeeded(ChannelHandlerContext ctx) {
        if (!((Boolean)ctx.channel().getOption(ChannelOption.AUTO_READ)).booleanValue()) {
            ctx.read();
        }
    }

    public Future<Void> close(ChannelHandlerContext ctx) {
        if (this.closeStatus == null || !ctx.channel().isActive()) {
            return ctx.close();
        }
        Future<Void> future = this.closeSent == null ? this.write(ctx, (Object)new CloseWebSocketFrame(ctx.bufferAllocator(), this.closeStatus)) : this.closeSent.asFuture();
        this.flush(ctx);
        this.applyCloseSentTimeout(ctx);
        Promise promise = ctx.newPromise();
        future.addListener(f -> ctx.close().cascadeTo(promise));
        return promise.asFuture();
    }

    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        if (this.closeSent != null) {
            Resource.dispose((Object)msg);
            return ctx.newFailedFuture((Throwable)new ClosedChannelException());
        }
        if (msg instanceof CloseWebSocketFrame) {
            Promise promise = ctx.newPromise();
            this.closeSent((Promise<Void>)promise);
            ctx.write(msg).cascadeTo(this.closeSent);
            return promise.asFuture();
        }
        return ctx.write(msg);
    }

    void closeSent(Promise<Void> promise) {
        this.closeSent = promise;
    }

    private void applyCloseSentTimeout(ChannelHandlerContext ctx) {
        if (this.closeSent.isDone() || this.forceCloseTimeoutMillis < 0L) {
            return;
        }
        Future timeoutTask = ctx.executor().schedule(() -> {
            if (!this.closeSent.isDone()) {
                this.closeSent.tryFailure((Throwable)this.buildHandshakeException("send close frame timed out"));
            }
        }, this.forceCloseTimeoutMillis, TimeUnit.MILLISECONDS);
        this.closeSent.asFuture().addListener(future -> timeoutTask.cancel());
    }

    protected WebSocketHandshakeException buildHandshakeException(String message) {
        return new WebSocketHandshakeException(message);
    }

    public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.fireChannelExceptionCaught(cause);
        ctx.close();
    }
}

