/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferUtil;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.http.HttpServerCodec;
import io.netty5.handler.codec.http.HttpServerUpgradeHandler;
import io.netty5.handler.codec.http2.Http2CodecUtil;
import io.netty5.util.internal.UnstableApi;
import java.util.Objects;

@UnstableApi
public final class CleartextHttp2ServerUpgradeHandler
extends ByteToMessageDecoder {
    private final HttpServerCodec httpServerCodec;
    private final HttpServerUpgradeHandler<?> httpServerUpgradeHandler;
    private final ChannelHandler http2ServerHandler;

    public CleartextHttp2ServerUpgradeHandler(HttpServerCodec httpServerCodec, HttpServerUpgradeHandler<?> httpServerUpgradeHandler, ChannelHandler http2ServerHandler) {
        this.httpServerCodec = Objects.requireNonNull(httpServerCodec, "httpServerCodec");
        this.httpServerUpgradeHandler = Objects.requireNonNull(httpServerUpgradeHandler, "httpServerUpgradeHandler");
        this.http2ServerHandler = Objects.requireNonNull(http2ServerHandler, "http2ServerHandler");
    }

    public void handlerAdded0(ChannelHandlerContext ctx) throws Exception {
        ctx.pipeline().addAfter(ctx.name(), null, this.httpServerUpgradeHandler).addAfter(ctx.name(), null, (ChannelHandler)this.httpServerCodec);
    }

    protected void decode(ChannelHandlerContext ctx, Buffer in) throws Exception {
        try (Buffer connectionPreface = Http2CodecUtil.CONNECTION_PREFACE_BUFFER.get();){
            int prefaceLength = connectionPreface.readableBytes();
            int bytesRead = Math.min(in.readableBytes(), prefaceLength);
            if (!BufferUtil.equals((Buffer)connectionPreface, (int)connectionPreface.readerOffset(), (Buffer)in, (int)in.readerOffset(), (int)bytesRead)) {
                ctx.pipeline().remove((ChannelHandler)this);
            } else if (bytesRead == prefaceLength) {
                ctx.pipeline().remove((ChannelHandler)this.httpServerCodec).remove(this.httpServerUpgradeHandler);
                ctx.pipeline().addAfter(ctx.name(), null, this.http2ServerHandler);
                ctx.fireChannelInboundEvent((Object)PriorKnowledgeUpgradeEvent.INSTANCE);
                ctx.pipeline().remove((ChannelHandler)this);
            }
        }
    }

    public static final class PriorKnowledgeUpgradeEvent {
        private static final PriorKnowledgeUpgradeEvent INSTANCE = new PriorKnowledgeUpgradeEvent();

        private PriorKnowledgeUpgradeEvent() {
        }
    }
}

