/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import com.aayushatharva.brotli4j.encoder.Encoder;
import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.compression.Brotli;
import io.netty5.handler.codec.compression.BrotliCompressor;
import io.netty5.handler.codec.compression.BrotliOptions;
import io.netty5.handler.codec.compression.CompressionOptions;
import io.netty5.handler.codec.compression.Compressor;
import io.netty5.handler.codec.compression.DeflateOptions;
import io.netty5.handler.codec.compression.GzipOptions;
import io.netty5.handler.codec.compression.StandardCompressionOptions;
import io.netty5.handler.codec.compression.ZlibCompressor;
import io.netty5.handler.codec.compression.ZlibWrapper;
import io.netty5.handler.codec.compression.ZstdCompressor;
import io.netty5.handler.codec.compression.ZstdOptions;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.netty5.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import io.netty5.handler.codec.http2.Http2Connection;
import io.netty5.handler.codec.http2.Http2ConnectionAdapter;
import io.netty5.handler.codec.http2.Http2ConnectionEncoder;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2Stream;
import io.netty5.handler.codec.http2.headers.Http2Headers;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.concurrent.PromiseCombiner;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.UnstableApi;
import java.util.Objects;

@UnstableApi
public class CompressorHttp2ConnectionEncoder
extends DecoratingHttp2ConnectionEncoder {
    private final Http2Connection.PropertyKey propertyKey;
    private final boolean supportsCompressionOptions;
    private BrotliOptions brotliOptions;
    private GzipOptions gzipCompressionOptions;
    private DeflateOptions deflateOptions;
    private ZstdOptions zstdOptions;

    public CompressorHttp2ConnectionEncoder(Http2ConnectionEncoder delegate) {
        this(delegate, CompressorHttp2ConnectionEncoder.defaultCompressionOptions());
    }

    public CompressorHttp2ConnectionEncoder(Http2ConnectionEncoder delegate, CompressionOptions ... compressionOptionsArgs) {
        super(delegate);
        Objects.requireNonNull(compressionOptionsArgs, "CompressionOptions");
        ObjectUtil.deepCheckNotNull((String)"CompressionOptions", (Object[])compressionOptionsArgs);
        for (CompressionOptions compressionOptions : compressionOptionsArgs) {
            if (Brotli.isAvailable() && compressionOptions instanceof BrotliOptions) {
                this.brotliOptions = (BrotliOptions)compressionOptions;
                continue;
            }
            if (compressionOptions instanceof GzipOptions) {
                this.gzipCompressionOptions = (GzipOptions)compressionOptions;
                continue;
            }
            if (compressionOptions instanceof DeflateOptions) {
                this.deflateOptions = (DeflateOptions)compressionOptions;
                continue;
            }
            if (compressionOptions instanceof ZstdOptions) {
                this.zstdOptions = (ZstdOptions)compressionOptions;
                continue;
            }
            throw new IllegalArgumentException("Unsupported " + CompressionOptions.class.getSimpleName() + ": " + compressionOptions);
        }
        this.supportsCompressionOptions = true;
        this.propertyKey = this.connection().newKey();
        this.connection().addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamRemoved(Http2Stream stream) {
                Compressor compressor = (Compressor)stream.getProperty(CompressorHttp2ConnectionEncoder.this.propertyKey);
                if (compressor != null) {
                    CompressorHttp2ConnectionEncoder.this.cleanup(stream, compressor);
                }
            }
        });
    }

    private static CompressionOptions[] defaultCompressionOptions() {
        if (Brotli.isAvailable()) {
            return new CompressionOptions[]{StandardCompressionOptions.brotli(), StandardCompressionOptions.gzip(), StandardCompressionOptions.deflate()};
        }
        return new CompressionOptions[]{StandardCompressionOptions.gzip(), StandardCompressionOptions.deflate()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> writeData(ChannelHandlerContext ctx, int streamId, Buffer data, int padding, boolean endOfStream) {
        Compressor compressor;
        Http2Stream stream = this.connection().stream(streamId);
        Compressor compressor2 = compressor = stream == null ? null : (Compressor)stream.getProperty(this.propertyKey);
        if (compressor == null) {
            return super.writeData(ctx, streamId, data, padding, endOfStream);
        }
        try {
            Future<Void> future;
            block25: {
                Future<Void> future2;
                Buffer buffer;
                block23: {
                    Future future3;
                    block24: {
                        Buffer buf;
                        block19: {
                            Future future4;
                            block22: {
                                block20: {
                                    Future<Void> future5;
                                    block21: {
                                        buffer = data;
                                        try {
                                            buf = compressor.compress(data, ctx.bufferAllocator());
                                            if (buf.readableBytes() != 0) break block19;
                                            buf.close();
                                            if (!endOfStream) break block20;
                                            buf = compressor.finish(ctx.bufferAllocator());
                                            future5 = super.writeData(ctx, streamId, buf, padding, true);
                                            if (buffer == null) break block21;
                                        }
                                        catch (Throwable throwable) {
                                            try {
                                                if (buffer != null) {
                                                    try {
                                                        buffer.close();
                                                    }
                                                    catch (Throwable throwable2) {
                                                        throwable.addSuppressed(throwable2);
                                                    }
                                                }
                                                throw throwable;
                                            }
                                            catch (Throwable cause) {
                                                Future future6 = ctx.newFailedFuture(cause);
                                                return future6;
                                            }
                                        }
                                        buffer.close();
                                    }
                                    return future5;
                                }
                                future4 = ctx.newSucceededFuture();
                                if (buffer == null) break block22;
                                buffer.close();
                            }
                            return future4;
                        }
                        future2 = super.writeData(ctx, streamId, buf, padding, false);
                        if (!endOfStream) break block23;
                        Promise promise = ctx.newPromise();
                        PromiseCombiner combiner = new PromiseCombiner(ctx.executor());
                        combiner.add(future2);
                        buf = compressor.finish(ctx.bufferAllocator());
                        future2 = super.writeData(ctx, streamId, buf, 0, true);
                        combiner.add(future2);
                        combiner.finish(promise);
                        future3 = promise.asFuture();
                        if (buffer == null) break block24;
                        buffer.close();
                    }
                    return future3;
                }
                future = future2;
                if (buffer == null) break block25;
                buffer.close();
            }
            return future;
        }
        finally {
            if (endOfStream) {
                this.cleanup(stream, compressor);
            }
        }
    }

    @Override
    public Future<Void> writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) {
        try {
            Compressor compressor = this.newCompressor(ctx, headers, endStream);
            Future<Void> future = super.writeHeaders(ctx, streamId, headers, padding, endStream);
            this.bindCompressorToStream(compressor, streamId);
            return future;
        }
        catch (Throwable e) {
            return ctx.newFailedFuture(e);
        }
    }

    @Override
    public Future<Void> writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
        try {
            Compressor compressor = this.newCompressor(ctx, headers, endOfStream);
            Future<Void> future = super.writeHeaders(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endOfStream);
            this.bindCompressorToStream(compressor, streamId);
            return future;
        }
        catch (Throwable e) {
            return ctx.newFailedFuture(e);
        }
    }

    protected Compressor newContentCompressor(ChannelHandlerContext ctx, CharSequence contentEncoding) throws Http2Exception {
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(contentEncoding)) {
            return this.newCompressionChannel(ctx, ZlibWrapper.GZIP);
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(contentEncoding)) {
            return this.newCompressionChannel(ctx, ZlibWrapper.ZLIB);
        }
        if (Brotli.isAvailable() && this.brotliOptions != null && HttpHeaderValues.BR.contentEqualsIgnoreCase(contentEncoding)) {
            return (Compressor)BrotliCompressor.newFactory((Encoder.Parameters)this.brotliOptions.parameters()).get();
        }
        if (this.zstdOptions != null && HttpHeaderValues.ZSTD.contentEqualsIgnoreCase(contentEncoding)) {
            return (Compressor)ZstdCompressor.newFactory((int)this.zstdOptions.compressionLevel(), (int)this.zstdOptions.blockSize(), (int)this.zstdOptions.maxEncodeSize()).get();
        }
        return null;
    }

    protected CharSequence getTargetContentEncoding(CharSequence contentEncoding) throws Http2Exception {
        return contentEncoding;
    }

    private Compressor newCompressionChannel(ChannelHandlerContext ctx, ZlibWrapper wrapper) {
        if (this.supportsCompressionOptions) {
            if (wrapper == ZlibWrapper.GZIP && this.gzipCompressionOptions != null) {
                return (Compressor)ZlibCompressor.newFactory((ZlibWrapper)wrapper, (int)this.gzipCompressionOptions.compressionLevel()).get();
            }
            if (wrapper == ZlibWrapper.ZLIB && this.deflateOptions != null) {
                return (Compressor)ZlibCompressor.newFactory((ZlibWrapper)wrapper, (int)this.deflateOptions.compressionLevel()).get();
            }
            throw new IllegalArgumentException("Unsupported ZlibWrapper: " + wrapper);
        }
        return (Compressor)ZlibCompressor.newFactory((ZlibWrapper)wrapper).get();
    }

    private Compressor newCompressor(ChannelHandlerContext ctx, Http2Headers headers, boolean endOfStream) throws Http2Exception {
        Compressor compressor;
        if (endOfStream) {
            return null;
        }
        CharSequence encoding = headers.get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        if (encoding == null) {
            encoding = HttpHeaderValues.IDENTITY;
        }
        if ((compressor = this.newContentCompressor(ctx, encoding)) != null) {
            CharSequence targetContentEncoding = this.getTargetContentEncoding(encoding);
            if (HttpHeaderValues.IDENTITY.contentEqualsIgnoreCase(targetContentEncoding)) {
                headers.remove((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
            } else {
                headers.set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, targetContentEncoding);
            }
            headers.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        }
        return compressor;
    }

    private void bindCompressorToStream(Compressor compressor, int streamId) {
        Http2Stream stream;
        if (compressor != null && (stream = this.connection().stream(streamId)) != null) {
            stream.setProperty(this.propertyKey, compressor);
        }
    }

    void cleanup(Http2Stream stream, Compressor compressor) {
        compressor.close();
        stream.removeProperty(this.propertyKey);
    }
}

