/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.channel.AbstractCoalescingBufferQueue;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.CoalescingBufferQueue;
import io.netty5.handler.codec.http.HttpStatusClass;
import io.netty5.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.netty5.handler.codec.http2.Http2CodecUtil;
import io.netty5.handler.codec.http2.Http2Connection;
import io.netty5.handler.codec.http2.Http2ConnectionEncoder;
import io.netty5.handler.codec.http2.Http2Error;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2Flags;
import io.netty5.handler.codec.http2.Http2FrameSizePolicy;
import io.netty5.handler.codec.http2.Http2FrameWriter;
import io.netty5.handler.codec.http2.Http2HeadersEncoder;
import io.netty5.handler.codec.http2.Http2LifecycleManager;
import io.netty5.handler.codec.http2.Http2RemoteFlowController;
import io.netty5.handler.codec.http2.Http2Settings;
import io.netty5.handler.codec.http2.Http2SettingsReceivedConsumer;
import io.netty5.handler.codec.http2.Http2Stream;
import io.netty5.handler.codec.http2.headers.Http2Headers;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.UnstableApi;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;

@UnstableApi
public class DefaultHttp2ConnectionEncoder
implements Http2ConnectionEncoder,
Http2SettingsReceivedConsumer {
    private final Http2FrameWriter frameWriter;
    private final Http2Connection connection;
    private Http2LifecycleManager lifecycleManager;
    private final Queue<Http2Settings> outstandingLocalSettingsQueue = new ArrayDeque<Http2Settings>(4);
    private Queue<Http2Settings> outstandingRemoteSettingsQueue;

    public DefaultHttp2ConnectionEncoder(Http2Connection connection, Http2FrameWriter frameWriter) {
        this.connection = Objects.requireNonNull(connection, "connection");
        this.frameWriter = Objects.requireNonNull(frameWriter, "frameWriter");
        if (connection.remote().flowController() == null) {
            connection.remote().flowController(new DefaultHttp2RemoteFlowController(connection));
        }
    }

    @Override
    public void lifecycleManager(Http2LifecycleManager lifecycleManager) {
        this.lifecycleManager = Objects.requireNonNull(lifecycleManager, "lifecycleManager");
    }

    @Override
    public Http2FrameWriter frameWriter() {
        return this.frameWriter;
    }

    @Override
    public Http2Connection connection() {
        return this.connection;
    }

    @Override
    public final Http2RemoteFlowController flowController() {
        return this.connection().remote().flowController();
    }

    @Override
    public void remoteSettings(Http2Settings settings) throws Http2Exception {
        Integer initialWindowSize;
        Integer maxFrameSize;
        Long maxHeaderListSize;
        Long headerTableSize;
        Long maxConcurrentStreams;
        Boolean pushEnabled = settings.pushEnabled();
        Http2FrameWriter.Configuration config = this.configuration();
        Http2HeadersEncoder.Configuration outboundHeaderConfig = config.headersConfiguration();
        Http2FrameSizePolicy outboundFrameSizePolicy = config.frameSizePolicy();
        if (pushEnabled != null) {
            if (!this.connection.isServer() && pushEnabled.booleanValue()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Client received a value of ENABLE_PUSH specified to other than 0", new Object[0]);
            }
            this.connection.remote().allowPushTo(pushEnabled);
        }
        if ((maxConcurrentStreams = settings.maxConcurrentStreams()) != null) {
            this.connection.local().maxActiveStreams((int)Math.min(maxConcurrentStreams, Integer.MAX_VALUE));
        }
        if ((headerTableSize = settings.headerTableSize()) != null) {
            outboundHeaderConfig.maxHeaderTableSize((int)Math.min(headerTableSize, Integer.MAX_VALUE));
        }
        if ((maxHeaderListSize = settings.maxHeaderListSize()) != null) {
            outboundHeaderConfig.maxHeaderListSize(maxHeaderListSize);
        }
        if ((maxFrameSize = settings.maxFrameSize()) != null) {
            outboundFrameSizePolicy.maxFrameSize(maxFrameSize);
        }
        if ((initialWindowSize = settings.initialWindowSize()) != null) {
            this.flowController().initialWindowSize(initialWindowSize);
        }
    }

    @Override
    public Future<Void> writeData(ChannelHandlerContext ctx, int streamId, Buffer data, int padding, boolean endOfStream) {
        Http2Stream stream;
        try {
            stream = this.requireStream(streamId);
            switch (stream.state()) {
                case OPEN: 
                case HALF_CLOSED_REMOTE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Stream " + stream.id() + " in unexpected state " + stream.state());
                }
            }
        }
        catch (Throwable e) {
            data.close();
            return ctx.newFailedFuture(e);
        }
        Promise promise = ctx.newPromise();
        this.flowController().addFlowControlled(stream, new FlowControlledData(stream, data, padding, endOfStream, (Promise<Void>)promise, ctx.channel()));
        return promise.asFuture();
    }

    @Override
    public Future<Void> writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) {
        return this.writeHeaders0(ctx, streamId, headers, false, 0, (short)0, false, padding, endStream);
    }

    private static boolean validateHeadersSentState(Http2Stream stream, Http2Headers headers, boolean isServer, boolean endOfStream) {
        boolean isInformational;
        boolean bl = isInformational = isServer && HttpStatusClass.valueOf((CharSequence)headers.status()) == HttpStatusClass.INFORMATIONAL;
        if ((isInformational || !endOfStream) && stream.isHeadersSent() || stream.isTrailersSent()) {
            throw new IllegalStateException("Stream " + stream.id() + " sent too many headers EOS: " + endOfStream);
        }
        return isInformational;
    }

    @Override
    public Future<Void> writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
        return this.writeHeaders0(ctx, streamId, headers, true, streamDependency, weight, exclusive, padding, endOfStream);
    }

    private static Future<Void> sendHeaders(Http2FrameWriter frameWriter, ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean hasPriority, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
        if (hasPriority) {
            return frameWriter.writeHeaders(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endOfStream);
        }
        return frameWriter.writeHeaders(ctx, streamId, headers, padding, endOfStream);
    }

    private Future<Void> writeHeaders0(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean hasPriority, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
        try {
            Http2Stream stream = this.connection.stream(streamId);
            if (stream == null) {
                try {
                    stream = this.connection.local().createStream(streamId, false);
                }
                catch (Http2Exception cause) {
                    if (this.connection.remote().mayHaveCreatedStream(streamId)) {
                        return ctx.newFailedFuture((Throwable)new IllegalStateException("Stream no longer exists: " + streamId, cause));
                    }
                    throw cause;
                }
            } else {
                switch (stream.state()) {
                    case RESERVED_LOCAL: {
                        stream.open(endOfStream);
                        break;
                    }
                    case OPEN: 
                    case HALF_CLOSED_REMOTE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Stream " + stream.id() + " in unexpected state " + stream.state());
                    }
                }
            }
            Http2RemoteFlowController flowController = this.flowController();
            if (!endOfStream || !flowController.hasFlowControlled(stream)) {
                boolean isInformational = DefaultHttp2ConnectionEncoder.validateHeadersSentState(stream, headers, this.connection.isServer(), endOfStream);
                Future<Void> future = DefaultHttp2ConnectionEncoder.sendHeaders(this.frameWriter, ctx, streamId, headers, hasPriority, streamDependency, weight, exclusive, padding, endOfStream);
                if (future.isSuccess() || !future.isDone()) {
                    stream.headersSent(isInformational);
                    if (!future.isSuccess()) {
                        this.notifyLifecycleManagerOnError(future, ctx);
                    }
                } else {
                    Throwable failureCause = future.cause();
                    this.lifecycleManager.onError(ctx, true, failureCause);
                }
                if (endOfStream) {
                    this.lifecycleManager.closeStreamLocal(stream, future);
                }
                return future;
            }
            Promise promise = ctx.newPromise();
            flowController.addFlowControlled(stream, new FlowControlledHeaders(stream, headers, hasPriority, streamDependency, weight, exclusive, padding, true, (Promise<Void>)promise));
            return promise.asFuture();
        }
        catch (Throwable t) {
            this.lifecycleManager.onError(ctx, true, t);
            return ctx.newFailedFuture(t);
        }
    }

    @Override
    public Future<Void> writePriority(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
        return this.frameWriter.writePriority(ctx, streamId, streamDependency, weight, exclusive);
    }

    @Override
    public Future<Void> writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode) {
        return this.lifecycleManager.resetStream(ctx, streamId, errorCode);
    }

    @Override
    public Future<Void> writeSettings(ChannelHandlerContext ctx, Http2Settings settings) {
        this.outstandingLocalSettingsQueue.add(settings);
        try {
            Boolean pushEnabled = settings.pushEnabled();
            if (pushEnabled != null && this.connection.isServer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server sending SETTINGS frame with ENABLE_PUSH specified", new Object[0]);
            }
        }
        catch (Throwable e) {
            return ctx.newFailedFuture(e);
        }
        return this.frameWriter.writeSettings(ctx, settings);
    }

    @Override
    public Future<Void> writeSettingsAck(ChannelHandlerContext ctx) {
        if (this.outstandingRemoteSettingsQueue == null) {
            return this.frameWriter.writeSettingsAck(ctx);
        }
        Http2Settings settings = this.outstandingRemoteSettingsQueue.poll();
        if (settings == null) {
            return ctx.newFailedFuture((Throwable)new Http2Exception(Http2Error.INTERNAL_ERROR, "attempted to write a SETTINGS ACK with no  pending SETTINGS"));
        }
        Http2CodecUtil.SimpleChannelPromiseAggregator aggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator((Promise<Void>)ctx.newPromise(), ctx.executor());
        this.frameWriter.writeSettingsAck(ctx).cascadeTo(aggregator.newPromise());
        Promise<Void> applySettingsPromise = aggregator.newPromise();
        try {
            this.remoteSettings(settings);
            applySettingsPromise.setSuccess(null);
        }
        catch (Throwable e) {
            applySettingsPromise.setFailure(e);
            this.lifecycleManager.onError(ctx, true, e);
        }
        return aggregator.doneAllocatingPromises();
    }

    @Override
    public Future<Void> writePing(ChannelHandlerContext ctx, boolean ack, long data) {
        return this.frameWriter.writePing(ctx, ack, data);
    }

    @Override
    public Future<Void> writePushPromise(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
        try {
            if (this.connection.goAwayReceived()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Sending PUSH_PROMISE after GO_AWAY received.", new Object[0]);
            }
            Http2Stream stream = this.requireStream(streamId);
            this.connection.local().reservePushStream(promisedStreamId, stream);
            Future<Void> future = this.frameWriter.writePushPromise(ctx, streamId, promisedStreamId, headers, padding);
            if (future.isSuccess() || !future.isDone()) {
                stream.pushPromiseSent();
                if (!future.isSuccess()) {
                    this.notifyLifecycleManagerOnError(future, ctx);
                }
            } else {
                Throwable failureCause = future.cause();
                this.lifecycleManager.onError(ctx, true, failureCause);
            }
            return future;
        }
        catch (Throwable t) {
            this.lifecycleManager.onError(ctx, true, t);
            return ctx.newFailedFuture(t);
        }
    }

    @Override
    public Future<Void> writeGoAway(ChannelHandlerContext ctx, int lastStreamId, long errorCode, Buffer debugData) {
        return this.lifecycleManager.goAway(ctx, lastStreamId, errorCode, debugData);
    }

    @Override
    public Future<Void> writeWindowUpdate(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
        return ctx.newFailedFuture((Throwable)new UnsupportedOperationException("Use the Http2[Inbound|Outbound]FlowController objects to control window sizes"));
    }

    @Override
    public Future<Void> writeFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, Buffer payload) {
        return this.frameWriter.writeFrame(ctx, frameType, streamId, flags, payload);
    }

    @Override
    public void close() {
        this.frameWriter.close();
    }

    @Override
    public Http2Settings pollSentSettings() {
        return this.outstandingLocalSettingsQueue.poll();
    }

    @Override
    public Http2FrameWriter.Configuration configuration() {
        return this.frameWriter.configuration();
    }

    private Http2Stream requireStream(int streamId) {
        Http2Stream stream = this.connection.stream(streamId);
        if (stream == null) {
            String message = this.connection.streamMayHaveExisted(streamId) ? "Stream no longer exists: " + streamId : "Stream does not exist: " + streamId;
            throw new IllegalArgumentException(message);
        }
        return stream;
    }

    @Override
    public void consumeReceivedSettings(Http2Settings settings) {
        if (this.outstandingRemoteSettingsQueue == null) {
            this.outstandingRemoteSettingsQueue = new ArrayDeque<Http2Settings>(2);
        }
        this.outstandingRemoteSettingsQueue.add(settings);
    }

    private void notifyLifecycleManagerOnError(Future<Void> future, ChannelHandlerContext ctx) {
        future.addListener(future1 -> {
            Throwable cause = future1.cause();
            if (cause != null) {
                this.lifecycleManager.onError(ctx, true, cause);
            }
        });
    }

    public abstract class FlowControlledBase
    implements Http2RemoteFlowController.FlowControlled,
    FutureListener<Void> {
        protected final Http2Stream stream;
        protected Promise<Void> promise;
        protected boolean endOfStream;
        protected int padding;

        FlowControlledBase(Http2Stream stream, int padding, boolean endOfStream, Promise<Void> promise) {
            ObjectUtil.checkPositiveOrZero((int)padding, (String)"padding");
            this.padding = padding;
            this.endOfStream = endOfStream;
            this.stream = stream;
            this.promise = promise;
        }

        @Override
        public void writeComplete() {
            if (this.endOfStream) {
                DefaultHttp2ConnectionEncoder.this.lifecycleManager.closeStreamLocal(this.stream, (Future<Void>)this.promise.asFuture());
            }
        }

        public void operationComplete(Future<? extends Void> future) {
            if (future.isFailed()) {
                this.error(DefaultHttp2ConnectionEncoder.this.flowController().channelHandlerContext(), future.cause());
            }
        }
    }

    private final class FlowControlledHeaders
    extends FlowControlledBase {
        private final Http2Headers headers;
        private final boolean hasPriority;
        private final int streamDependency;
        private final short weight;
        private final boolean exclusive;

        FlowControlledHeaders(Http2Stream stream, Http2Headers headers, boolean hasPriority, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream, Promise<Void> promise) {
            super(stream, padding, endOfStream, promise);
            this.headers = headers;
            this.hasPriority = hasPriority;
            this.streamDependency = streamDependency;
            this.weight = weight;
            this.exclusive = exclusive;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void error(ChannelHandlerContext ctx, Throwable cause) {
            if (ctx != null) {
                DefaultHttp2ConnectionEncoder.this.lifecycleManager.onError(ctx, true, cause);
            }
            this.promise.tryFailure(cause);
        }

        @Override
        public void write(ChannelHandlerContext ctx, int allowedBytes) {
            boolean isInformational = DefaultHttp2ConnectionEncoder.validateHeadersSentState(this.stream, this.headers, DefaultHttp2ConnectionEncoder.this.connection.isServer(), this.endOfStream);
            this.promise.asFuture().addListener((FutureListener)this);
            Future<Void> f = DefaultHttp2ConnectionEncoder.sendHeaders(DefaultHttp2ConnectionEncoder.this.frameWriter, ctx, this.stream.id(), this.headers, this.hasPriority, this.streamDependency, this.weight, this.exclusive, this.padding, this.endOfStream);
            f.cascadeTo(this.promise);
            if (!f.isFailed()) {
                this.stream.headersSent(isInformational);
            }
        }

        @Override
        public boolean merge(ChannelHandlerContext ctx, Http2RemoteFlowController.FlowControlled next) {
            return false;
        }
    }

    private final class FlowControlledData
    extends FlowControlledBase {
        private final CoalescingBufferQueue queue;
        private int dataSize;

        FlowControlledData(Http2Stream stream, Buffer buf, int padding, boolean endOfStream, Promise<Void> promise, Channel channel) {
            super(stream, padding, endOfStream, promise);
            this.queue = new CoalescingBufferQueue(channel);
            this.queue.add(buf, promise);
            this.dataSize = this.queue.readableBytes();
        }

        @Override
        public int size() {
            return this.dataSize + this.padding;
        }

        @Override
        public void error(ChannelHandlerContext ctx, Throwable cause) {
            this.queue.releaseAndFailAll(cause);
            DefaultHttp2ConnectionEncoder.this.lifecycleManager.onError(ctx, true, cause);
        }

        @Override
        public void write(ChannelHandlerContext ctx, int allowedBytes) {
            int queuedData = this.queue.readableBytes();
            if (!this.endOfStream) {
                if (queuedData == 0) {
                    if (this.queue.isEmpty()) {
                        this.dataSize = 0;
                        this.padding = 0;
                    } else {
                        Promise writePromise = ctx.newPromise();
                        writePromise.asFuture().addListener((FutureListener)this);
                        ctx.write((Object)this.queue.remove(0, writePromise)).cascadeTo(writePromise);
                    }
                    return;
                }
                if (allowedBytes == 0) {
                    return;
                }
            }
            int writableData = Math.min(queuedData, allowedBytes);
            Promise writePromise = ctx.newPromise();
            writePromise.asFuture().addListener((FutureListener)this);
            Buffer toWrite = this.queue.remove(writableData, writePromise);
            this.dataSize = this.queue.readableBytes();
            int writablePadding = Math.min(allowedBytes - writableData, this.padding);
            this.padding -= writablePadding;
            DefaultHttp2ConnectionEncoder.this.frameWriter().writeData(ctx, this.stream.id(), toWrite, writablePadding, this.endOfStream && this.size() == 0).cascadeTo(writePromise);
        }

        @Override
        public boolean merge(ChannelHandlerContext ctx, Http2RemoteFlowController.FlowControlled next) {
            FlowControlledData nextData;
            if (FlowControlledData.class != next.getClass() || Integer.MAX_VALUE - (nextData = (FlowControlledData)next).size() < this.size()) {
                return false;
            }
            nextData.queue.copyTo((AbstractCoalescingBufferQueue)this.queue);
            this.dataSize = this.queue.readableBytes();
            this.padding = Math.max(this.padding, nextData.padding);
            this.endOfStream = nextData.endOfStream;
            return true;
        }
    }
}

