/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferClosedException;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.handler.codec.http2.AbstractHttp2StreamFrame;
import io.netty5.handler.codec.http2.Http2CodecUtil;
import io.netty5.handler.codec.http2.Http2DataFrame;
import io.netty5.handler.codec.http2.Http2FrameStream;
import io.netty5.util.Send;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.UnstableApi;
import java.util.Objects;

@UnstableApi
public final class DefaultHttp2DataFrame
extends AbstractHttp2StreamFrame
implements Http2DataFrame {
    private final Buffer content;
    private final boolean endStream;
    private final int padding;
    private final int initialFlowControlledBytes;

    public DefaultHttp2DataFrame(Send<Buffer> content) {
        this(content, false);
    }

    public DefaultHttp2DataFrame(boolean endStream) {
        this(DefaultBufferAllocators.onHeapAllocator().allocate(0), endStream, 0);
    }

    public DefaultHttp2DataFrame(Send<Buffer> content, boolean endStream) {
        this(content, endStream, 0);
    }

    public DefaultHttp2DataFrame(Send<Buffer> content, boolean endStream, int padding) {
        this((Buffer)content.receive(), endStream, padding);
    }

    private DefaultHttp2DataFrame(Buffer content, boolean endStream, int padding) {
        this.content = Objects.requireNonNull(content, "content");
        this.endStream = endStream;
        Http2CodecUtil.verifyPadding(padding);
        this.padding = padding;
        if ((long)this.content().readableBytes() + (long)padding > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("content + padding must be <= Integer.MAX_VALUE");
        }
        this.initialFlowControlledBytes = this.content().readableBytes() + padding;
    }

    @Override
    public DefaultHttp2DataFrame stream(Http2FrameStream stream) {
        super.stream(stream);
        return this;
    }

    @Override
    public String name() {
        return "DATA";
    }

    @Override
    public boolean isEndStream() {
        return this.endStream;
    }

    @Override
    public int padding() {
        return this.padding;
    }

    @Override
    public Buffer content() {
        if (this.content.isAccessible()) {
            return this.content;
        }
        throw new BufferClosedException();
    }

    @Override
    public int initialFlowControlledBytes() {
        return this.initialFlowControlledBytes;
    }

    @Override
    public DefaultHttp2DataFrame copy() {
        return new DefaultHttp2DataFrame(this.content.copy(), this.endStream, this.padding);
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "(stream=" + this.stream() + ", content=" + this.content + ", endStream=" + this.endStream + ", padding=" + this.padding + ")";
    }

    public Send<Http2DataFrame> send() {
        return this.content.send().map(Http2DataFrame.class, content -> new DefaultHttp2DataFrame((Buffer)content, this.endStream, this.padding));
    }

    public void close() {
        this.content.close();
    }

    public boolean isAccessible() {
        return this.content.isAccessible();
    }

    public DefaultHttp2DataFrame touch(Object hint) {
        this.content.touch(hint);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DefaultHttp2DataFrame)) {
            return false;
        }
        DefaultHttp2DataFrame other = (DefaultHttp2DataFrame)o;
        return super.equals(other) && this.content.equals(other.content()) && this.endStream == other.endStream && this.padding == other.padding;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + this.content.hashCode();
        hash = hash * 31 + (this.endStream ? 0 : 1);
        hash = hash * 31 + this.padding;
        return hash;
    }
}

