/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.http2.DefaultHttp2HeadersEncoder;
import io.netty5.handler.codec.http2.Http2CodecUtil;
import io.netty5.handler.codec.http2.Http2Error;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2Flags;
import io.netty5.handler.codec.http2.Http2FrameSizePolicy;
import io.netty5.handler.codec.http2.Http2FrameWriter;
import io.netty5.handler.codec.http2.Http2HeadersEncoder;
import io.netty5.handler.codec.http2.Http2Settings;
import io.netty5.handler.codec.http2.headers.Http2Headers;
import io.netty5.util.collection.CharObjectMap;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.UnstableApi;
import java.util.Objects;

@UnstableApi
public class DefaultHttp2FrameWriter
implements Http2FrameWriter,
Http2FrameSizePolicy,
Http2FrameWriter.Configuration {
    private static final String STREAM_ID = "Stream ID";
    private static final String STREAM_DEPENDENCY = "Stream Dependency";
    private static final Buffer ZERO_BUFFER = BufferAllocator.onHeapUnpooled().allocate(255).fill((byte)0).writerOffset(255).makeReadOnly();
    private final Http2HeadersEncoder headersEncoder;
    private int maxFrameSize;

    public DefaultHttp2FrameWriter() {
        this(new DefaultHttp2HeadersEncoder());
    }

    public DefaultHttp2FrameWriter(Http2HeadersEncoder.SensitivityDetector headersSensitivityDetector) {
        this(new DefaultHttp2HeadersEncoder(headersSensitivityDetector));
    }

    public DefaultHttp2FrameWriter(Http2HeadersEncoder.SensitivityDetector headersSensitivityDetector, boolean ignoreMaxHeaderListSize) {
        this(new DefaultHttp2HeadersEncoder(headersSensitivityDetector, ignoreMaxHeaderListSize));
    }

    public DefaultHttp2FrameWriter(Http2HeadersEncoder headersEncoder) {
        this.headersEncoder = headersEncoder;
        this.maxFrameSize = 16384;
    }

    @Override
    public Http2FrameWriter.Configuration configuration() {
        return this;
    }

    @Override
    public Http2HeadersEncoder.Configuration headersConfiguration() {
        return this.headersEncoder.configuration();
    }

    @Override
    public Http2FrameSizePolicy frameSizePolicy() {
        return this;
    }

    @Override
    public void maxFrameSize(int max) throws Http2Exception {
        if (!Http2CodecUtil.isMaxFrameSizeValid(max)) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Invalid MAX_FRAME_SIZE specified in sent settings: %d", max);
        }
        this.maxFrameSize = max;
    }

    @Override
    public int maxFrameSize() {
        return this.maxFrameSize;
    }

    @Override
    public void close() {
        this.headersEncoder.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> writeData(ChannelHandlerContext ctx, int streamId, Buffer data, int padding, boolean endStream) {
        Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator((Promise<Void>)ctx.newPromise(), ctx.executor());
        Buffer frameHeader = null;
        try {
            DefaultHttp2FrameWriter.verifyStreamId(streamId, STREAM_ID);
            Http2CodecUtil.verifyPadding(padding);
            int remainingData = data.readableBytes();
            Http2Flags flags = new Http2Flags();
            flags.endOfStream(false);
            flags.paddingPresent(false);
            if (remainingData > this.maxFrameSize) {
                frameHeader = ctx.bufferAllocator().allocate(9);
                Http2CodecUtil.writeFrameHeaderInternal(frameHeader, this.maxFrameSize, (byte)0, flags, streamId);
                frameHeader.makeReadOnly();
                do {
                    ctx.write((Object)frameHeader.copy(true)).cascadeTo(promiseAggregator.newPromise());
                    ctx.write((Object)data.readSplit(this.maxFrameSize)).cascadeTo(promiseAggregator.newPromise());
                } while ((remainingData -= this.maxFrameSize) > this.maxFrameSize);
            }
            if (padding == 0) {
                if (frameHeader != null) {
                    frameHeader.close();
                    frameHeader = null;
                }
                Buffer frameHeader2 = ctx.bufferAllocator().allocate(9);
                flags.endOfStream(endStream);
                Http2CodecUtil.writeFrameHeaderInternal(frameHeader2, remainingData, (byte)0, flags, streamId);
                ctx.write((Object)frameHeader2).cascadeTo(promiseAggregator.newPromise());
                Buffer lastFrame = data.readSplit(remainingData);
                data.close();
                data = null;
                ctx.write((Object)lastFrame).cascadeTo(promiseAggregator.newPromise());
            } else {
                if (remainingData != this.maxFrameSize) {
                    if (frameHeader != null) {
                        frameHeader.close();
                        frameHeader = null;
                    }
                } else {
                    Buffer lastFrame;
                    remainingData -= this.maxFrameSize;
                    if (frameHeader == null) {
                        lastFrame = ctx.bufferAllocator().allocate(9);
                        Http2CodecUtil.writeFrameHeaderInternal(lastFrame, this.maxFrameSize, (byte)0, flags, streamId);
                    } else {
                        lastFrame = frameHeader;
                        frameHeader = null;
                    }
                    ctx.write((Object)lastFrame).cascadeTo(promiseAggregator.newPromise());
                    if (data.readableBytes() != this.maxFrameSize) {
                        lastFrame = data.readSplit(this.maxFrameSize);
                        data.close();
                    } else {
                        lastFrame = data;
                    }
                    data = null;
                    ctx.write((Object)lastFrame).cascadeTo(promiseAggregator.newPromise());
                }
                do {
                    int frameDataBytes = Math.min(remainingData, this.maxFrameSize);
                    int framePaddingBytes = Math.min(padding, Math.max(0, this.maxFrameSize - 1 - frameDataBytes));
                    Buffer frameHeader2 = ctx.bufferAllocator().allocate(10);
                    flags.endOfStream(endStream && (remainingData -= frameDataBytes) == 0 && (padding -= framePaddingBytes) == 0);
                    flags.paddingPresent(framePaddingBytes > 0);
                    Http2CodecUtil.writeFrameHeaderInternal(frameHeader2, framePaddingBytes + frameDataBytes, (byte)0, flags, streamId);
                    DefaultHttp2FrameWriter.writePaddingLength(frameHeader2, framePaddingBytes);
                    ctx.write((Object)frameHeader2).cascadeTo(promiseAggregator.newPromise());
                    if (data != null) {
                        if (remainingData == 0) {
                            Buffer lastFrame = data.readSplit(frameDataBytes);
                            data.close();
                            data = null;
                            ctx.write((Object)lastFrame).cascadeTo(promiseAggregator.newPromise());
                        } else {
                            ctx.write((Object)data.readSplit(frameDataBytes)).cascadeTo(promiseAggregator.newPromise());
                        }
                    }
                    if (DefaultHttp2FrameWriter.paddingBytes(framePaddingBytes) <= 0) continue;
                    ctx.write((Object)ZERO_BUFFER.copy(0, DefaultHttp2FrameWriter.paddingBytes(framePaddingBytes), true)).cascadeTo(promiseAggregator.newPromise());
                } while (remainingData != 0 || padding != 0);
            }
        }
        catch (Throwable cause) {
            if (frameHeader != null) {
                frameHeader.close();
            }
            try {
                if (data != null && data.isAccessible()) {
                    data.close();
                }
            }
            finally {
                promiseAggregator.setFailure(cause);
                promiseAggregator.doneAllocatingPromises();
            }
            return promiseAggregator;
        }
        return promiseAggregator.doneAllocatingPromises();
    }

    @Override
    public Future<Void> writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) {
        return this.writeHeadersInternal(ctx, streamId, headers, padding, endStream, false, 0, (short)0, false);
    }

    @Override
    public Future<Void> writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
        return this.writeHeadersInternal(ctx, streamId, headers, padding, endStream, true, streamDependency, weight, exclusive);
    }

    @Override
    public Future<Void> writePriority(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
        try {
            DefaultHttp2FrameWriter.verifyStreamId(streamId, STREAM_ID);
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(streamDependency, STREAM_DEPENDENCY);
            DefaultHttp2FrameWriter.verifyWeight(weight);
            Buffer buf = ctx.bufferAllocator().allocate(14);
            Http2CodecUtil.writeFrameHeaderInternal(buf, 5, (byte)2, new Http2Flags(), streamId);
            buf.writeInt(exclusive ? (int)(0x80000000L | (long)streamDependency) : streamDependency);
            buf.writeByte((byte)(weight - 1));
            return ctx.write((Object)buf);
        }
        catch (Throwable t) {
            return ctx.newFailedFuture(t);
        }
    }

    @Override
    public Future<Void> writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode) {
        try {
            DefaultHttp2FrameWriter.verifyStreamId(streamId, STREAM_ID);
            DefaultHttp2FrameWriter.verifyErrorCode(errorCode);
            Buffer buf = ctx.bufferAllocator().allocate(13);
            Http2CodecUtil.writeFrameHeaderInternal(buf, 4, (byte)3, new Http2Flags(), streamId);
            buf.writeInt((int)errorCode);
            return ctx.write((Object)buf);
        }
        catch (Throwable t) {
            return ctx.newFailedFuture(t);
        }
    }

    @Override
    public Future<Void> writeSettings(ChannelHandlerContext ctx, Http2Settings settings) {
        try {
            Objects.requireNonNull(settings, "settings");
            int payloadLength = 6 * settings.size();
            Buffer buf = ctx.bufferAllocator().allocate(9 + payloadLength);
            Http2CodecUtil.writeFrameHeaderInternal(buf, payloadLength, (byte)4, new Http2Flags(), 0);
            for (CharObjectMap.PrimitiveEntry entry : settings.entries()) {
                buf.writeChar(entry.key());
                buf.writeInt(((Long)entry.value()).intValue());
            }
            return ctx.write((Object)buf);
        }
        catch (Throwable t) {
            return ctx.newFailedFuture(t);
        }
    }

    @Override
    public Future<Void> writeSettingsAck(ChannelHandlerContext ctx) {
        try {
            Buffer buf = ctx.bufferAllocator().allocate(9);
            Http2CodecUtil.writeFrameHeaderInternal(buf, 0, (byte)4, new Http2Flags().ack(true), 0);
            return ctx.write((Object)buf);
        }
        catch (Throwable t) {
            return ctx.newFailedFuture(t);
        }
    }

    @Override
    public Future<Void> writePing(ChannelHandlerContext ctx, boolean ack, long data) {
        Http2Flags flags = ack ? new Http2Flags().ack(true) : new Http2Flags();
        Buffer buf = ctx.bufferAllocator().allocate(17);
        Http2CodecUtil.writeFrameHeaderInternal(buf, 8, (byte)6, flags, 0);
        buf.writeLong(data);
        return ctx.write((Object)buf);
    }

    @Override
    public Future<Void> writePushPromise(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
        Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator((Promise<Void>)ctx.newPromise(), ctx.executor());
        try (Buffer headerBlock = null;){
            DefaultHttp2FrameWriter.verifyStreamId(streamId, STREAM_ID);
            DefaultHttp2FrameWriter.verifyStreamId(promisedStreamId, "Promised Stream ID");
            Http2CodecUtil.verifyPadding(padding);
            headerBlock = ctx.bufferAllocator().allocate(256);
            this.headersEncoder.encodeHeaders(streamId, headers, headerBlock);
            Http2Flags flags = new Http2Flags().paddingPresent(padding > 0);
            int nonFragmentLength = 4 + padding;
            int maxFragmentLength = this.maxFrameSize - nonFragmentLength;
            Buffer fragment = headerBlock.readSplit(Math.min(headerBlock.readableBytes(), maxFragmentLength));
            flags.endOfHeaders(headerBlock.readableBytes() == 0);
            int payloadLength = fragment.readableBytes() + nonFragmentLength;
            Buffer buf = ctx.bufferAllocator().allocate(14);
            Http2CodecUtil.writeFrameHeaderInternal(buf, payloadLength, (byte)5, flags, streamId);
            DefaultHttp2FrameWriter.writePaddingLength(buf, padding);
            buf.writeInt(promisedStreamId);
            ctx.write((Object)buf).cascadeTo(promiseAggregator.newPromise());
            ctx.write((Object)fragment).cascadeTo(promiseAggregator.newPromise());
            if (DefaultHttp2FrameWriter.paddingBytes(padding) > 0) {
                ctx.write((Object)ZERO_BUFFER.copy(0, DefaultHttp2FrameWriter.paddingBytes(padding), true)).cascadeTo(promiseAggregator.newPromise());
            }
            if (!flags.endOfHeaders()) {
                this.writeContinuationFrames(ctx, streamId, headerBlock, promiseAggregator);
            }
        }
        return promiseAggregator.doneAllocatingPromises();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> writeGoAway(ChannelHandlerContext ctx, int lastStreamId, long errorCode, Buffer debugData) {
        Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator((Promise<Void>)ctx.newPromise(), ctx.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(lastStreamId, "Last Stream ID");
            DefaultHttp2FrameWriter.verifyErrorCode(errorCode);
            int payloadLength = 8 + debugData.readableBytes();
            Buffer buf = ctx.bufferAllocator().allocate(17);
            Http2CodecUtil.writeFrameHeaderInternal(buf, payloadLength, (byte)7, new Http2Flags(), 0);
            buf.writeInt(lastStreamId);
            buf.writeInt((int)errorCode);
            ctx.write((Object)buf).cascadeTo(promiseAggregator.newPromise());
        }
        catch (Throwable t) {
            try {
                debugData.close();
            }
            finally {
                promiseAggregator.setFailure(t);
                promiseAggregator.doneAllocatingPromises();
            }
            return promiseAggregator;
        }
        try {
            ctx.write((Object)debugData).cascadeTo(promiseAggregator.newPromise());
        }
        catch (Throwable t) {
            promiseAggregator.setFailure(t);
        }
        return promiseAggregator.doneAllocatingPromises();
    }

    @Override
    public Future<Void> writeWindowUpdate(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
        try {
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(streamId, STREAM_ID);
            DefaultHttp2FrameWriter.verifyWindowSizeIncrement(windowSizeIncrement);
            Buffer buf = ctx.bufferAllocator().allocate(13);
            Http2CodecUtil.writeFrameHeaderInternal(buf, 4, (byte)8, new Http2Flags(), streamId);
            buf.writeInt(windowSizeIncrement);
            return ctx.write((Object)buf);
        }
        catch (Throwable t) {
            return ctx.newFailedFuture(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> writeFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, Buffer payload) {
        Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator((Promise<Void>)ctx.newPromise(), ctx.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(streamId, STREAM_ID);
            Buffer buf = ctx.bufferAllocator().allocate(9);
            Http2CodecUtil.writeFrameHeaderInternal(buf, payload.readableBytes(), frameType, flags, streamId);
            ctx.write((Object)buf).cascadeTo(promiseAggregator.newPromise());
        }
        catch (Throwable t) {
            try {
                payload.close();
            }
            finally {
                promiseAggregator.setFailure(t);
                promiseAggregator.doneAllocatingPromises();
            }
            return promiseAggregator;
        }
        try {
            ctx.write((Object)payload).cascadeTo(promiseAggregator.newPromise());
        }
        catch (Throwable t) {
            promiseAggregator.setFailure(t);
        }
        return promiseAggregator.doneAllocatingPromises();
    }

    private Future<Void> writeHeadersInternal(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, boolean hasPriority, int streamDependency, short weight, boolean exclusive) {
        Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator((Promise<Void>)ctx.newPromise(), ctx.executor());
        try (Buffer headerBlock = null;){
            DefaultHttp2FrameWriter.verifyStreamId(streamId, STREAM_ID);
            if (hasPriority) {
                DefaultHttp2FrameWriter.verifyStreamOrConnectionId(streamDependency, STREAM_DEPENDENCY);
                Http2CodecUtil.verifyPadding(padding);
                DefaultHttp2FrameWriter.verifyWeight(weight);
            }
            headerBlock = ctx.bufferAllocator().allocate(256);
            this.headersEncoder.encodeHeaders(streamId, headers, headerBlock);
            Http2Flags flags = new Http2Flags().endOfStream(endStream).priorityPresent(hasPriority).paddingPresent(padding > 0);
            int nonFragmentBytes = padding + flags.getNumPriorityBytes();
            int maxFragmentLength = this.maxFrameSize - nonFragmentBytes;
            Buffer fragment = headerBlock.readSplit(Math.min(headerBlock.readableBytes(), maxFragmentLength));
            flags.endOfHeaders(headerBlock.readableBytes() == 0);
            int payloadLength = fragment.readableBytes() + nonFragmentBytes;
            Buffer buf = ctx.bufferAllocator().allocate(15);
            Http2CodecUtil.writeFrameHeaderInternal(buf, payloadLength, (byte)1, flags, streamId);
            DefaultHttp2FrameWriter.writePaddingLength(buf, padding);
            if (hasPriority) {
                buf.writeInt(exclusive ? (int)(0x80000000L | (long)streamDependency) : streamDependency);
                buf.writeByte((byte)(weight - 1));
            }
            ctx.write((Object)buf).cascadeTo(promiseAggregator.newPromise());
            ctx.write((Object)fragment).cascadeTo(promiseAggregator.newPromise());
            if (DefaultHttp2FrameWriter.paddingBytes(padding) > 0) {
                ctx.write((Object)ZERO_BUFFER.copy(0, DefaultHttp2FrameWriter.paddingBytes(padding), true)).cascadeTo(promiseAggregator.newPromise());
            }
            if (!flags.endOfHeaders()) {
                this.writeContinuationFrames(ctx, streamId, headerBlock, promiseAggregator);
            }
        }
        return promiseAggregator.doneAllocatingPromises();
    }

    private Future<Void> writeContinuationFrames(ChannelHandlerContext ctx, int streamId, Buffer headerBlock, Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator) {
        Http2Flags flags = new Http2Flags();
        if (headerBlock.readableBytes() > 0) {
            int fragmentReadableBytes = Math.min(headerBlock.readableBytes(), this.maxFrameSize);
            Buffer buf = ctx.bufferAllocator().allocate(10);
            Http2CodecUtil.writeFrameHeaderInternal(buf, fragmentReadableBytes, (byte)9, flags, streamId);
            buf.makeReadOnly();
            do {
                fragmentReadableBytes = Math.min(headerBlock.readableBytes(), this.maxFrameSize);
                Buffer fragment = headerBlock.readSplit(fragmentReadableBytes);
                if (headerBlock.readableBytes() > 0) {
                    ctx.write((Object)buf.copy(true)).cascadeTo(promiseAggregator.newPromise());
                } else {
                    flags = flags.endOfHeaders(true);
                    buf.close();
                    buf = ctx.bufferAllocator().allocate(10);
                    Http2CodecUtil.writeFrameHeaderInternal(buf, fragmentReadableBytes, (byte)9, flags, streamId);
                    ctx.write((Object)buf).cascadeTo(promiseAggregator.newPromise());
                }
                ctx.write((Object)fragment).cascadeTo(promiseAggregator.newPromise());
            } while (headerBlock.readableBytes() > 0);
        }
        return promiseAggregator;
    }

    private static int paddingBytes(int padding) {
        return padding - 1;
    }

    private static void writePaddingLength(Buffer buf, int padding) {
        if (padding > 0) {
            buf.writeByte((byte)(padding - 1));
        }
    }

    private static void verifyStreamId(int streamId, String argumentName) {
        ObjectUtil.checkPositive((int)streamId, (String)argumentName);
    }

    private static void verifyStreamOrConnectionId(int streamId, String argumentName) {
        ObjectUtil.checkPositiveOrZero((int)streamId, (String)argumentName);
    }

    private static void verifyWeight(short weight) {
        if (weight < 1 || weight > 256) {
            throw new IllegalArgumentException("Invalid weight: " + weight);
        }
    }

    private static void verifyErrorCode(long errorCode) {
        if (errorCode < 0L || errorCode > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid errorCode: " + errorCode);
        }
    }

    private static void verifyWindowSizeIncrement(int windowSizeIncrement) {
        ObjectUtil.checkPositiveOrZero((int)windowSizeIncrement, (String)"windowSizeIncrement");
    }
}

