/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferHolder;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.handler.codec.http2.Http2Error;
import io.netty5.handler.codec.http2.Http2GoAwayFrame;
import io.netty5.util.Send;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.UnstableApi;

@UnstableApi
public final class DefaultHttp2GoAwayFrame
extends BufferHolder<Http2GoAwayFrame>
implements Http2GoAwayFrame {
    private final long errorCode;
    private final int lastStreamId;
    private int extraStreamIds;

    public DefaultHttp2GoAwayFrame(Http2Error error) {
        this(error.code());
    }

    public DefaultHttp2GoAwayFrame(long errorCode) {
        this(-1, errorCode, DefaultBufferAllocators.onHeapAllocator().allocate(0));
    }

    public DefaultHttp2GoAwayFrame(Http2Error error, Send<Buffer> content) {
        this(error.code(), content);
    }

    public DefaultHttp2GoAwayFrame(long errorCode, Send<Buffer> content) {
        this(-1, errorCode, (Buffer)content.receive());
    }

    DefaultHttp2GoAwayFrame(int lastStreamId, long errorCode, Send<Buffer> content) {
        this(lastStreamId, errorCode, (Buffer)content.receive());
    }

    private DefaultHttp2GoAwayFrame(int lastStreamId, long errorCode, Buffer content) {
        super(content);
        this.errorCode = errorCode;
        this.lastStreamId = lastStreamId;
    }

    @Override
    public String name() {
        return "GOAWAY";
    }

    @Override
    public long errorCode() {
        return this.errorCode;
    }

    @Override
    public int extraStreamIds() {
        return this.extraStreamIds;
    }

    @Override
    public Http2GoAwayFrame setExtraStreamIds(int extraStreamIds) {
        ObjectUtil.checkPositiveOrZero((int)extraStreamIds, (String)"extraStreamIds");
        this.extraStreamIds = extraStreamIds;
        return this;
    }

    @Override
    public int lastStreamId() {
        return this.lastStreamId;
    }

    @Override
    public Buffer content() {
        return this.getBuffer();
    }

    @Override
    public Http2GoAwayFrame copy() {
        return new DefaultHttp2GoAwayFrame(this.lastStreamId, this.errorCode, this.content().copy());
    }

    protected Http2GoAwayFrame receive(Buffer buf) {
        return new DefaultHttp2GoAwayFrame(this.lastStreamId, this.errorCode, buf);
    }

    public Http2GoAwayFrame touch(Object hint) {
        super.touch(hint);
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultHttp2GoAwayFrame)) {
            return false;
        }
        DefaultHttp2GoAwayFrame other = (DefaultHttp2GoAwayFrame)o;
        return this.errorCode == other.errorCode && this.extraStreamIds == other.extraStreamIds && super.equals((Object)other);
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + (int)(this.errorCode ^ this.errorCode >>> 32);
        hash = hash * 31 + this.extraStreamIds;
        return hash;
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "(errorCode=" + this.errorCode + ", content=" + this.content() + ", extraStreamIds=" + this.extraStreamIds + ", lastStreamId=" + this.lastStreamId + ")";
    }
}

