/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.compression.Brotli;
import io.netty5.handler.codec.compression.BrotliDecompressor;
import io.netty5.handler.codec.compression.Decompressor;
import io.netty5.handler.codec.compression.ZlibDecompressor;
import io.netty5.handler.codec.compression.ZlibWrapper;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.netty5.handler.codec.http2.Http2Connection;
import io.netty5.handler.codec.http2.Http2ConnectionAdapter;
import io.netty5.handler.codec.http2.Http2Error;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2FrameListener;
import io.netty5.handler.codec.http2.Http2FrameListenerDecorator;
import io.netty5.handler.codec.http2.Http2FrameWriter;
import io.netty5.handler.codec.http2.Http2LocalFlowController;
import io.netty5.handler.codec.http2.Http2Stream;
import io.netty5.handler.codec.http2.headers.Http2Headers;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.UnstableApi;
import java.util.Objects;

@UnstableApi
public class DelegatingDecompressorFrameListener
extends Http2FrameListenerDecorator {
    private final Http2Connection connection;
    private final boolean strict;
    private boolean flowControllerInitialized;
    private final Http2Connection.PropertyKey propertyKey;

    public DelegatingDecompressorFrameListener(Http2Connection connection, Http2FrameListener listener) {
        this(connection, listener, true);
    }

    public DelegatingDecompressorFrameListener(Http2Connection connection, Http2FrameListener listener, boolean strict) {
        super(listener);
        this.connection = connection;
        this.strict = strict;
        this.propertyKey = connection.newKey();
        connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamRemoved(Http2Stream stream) {
                Http2Decompressor decompressor = DelegatingDecompressorFrameListener.this.decompressor(stream);
                if (decompressor != null) {
                    DelegatingDecompressorFrameListener.cleanup(decompressor);
                }
            }
        });
    }

    @Override
    public int onDataRead(ChannelHandlerContext ctx, int streamId, Buffer data, int padding, boolean endOfStream) throws Http2Exception {
        Http2Stream stream = this.connection.stream(streamId);
        Http2Decompressor decompressor = this.decompressor(stream);
        if (decompressor == null) {
            return this.listener.onDataRead(ctx, streamId, data, padding, endOfStream);
        }
        Decompressor decomp = decompressor.decompressor();
        int compressedBytes = data.readableBytes() + padding;
        decompressor.incrementCompressedBytes(compressedBytes);
        try (Buffer decompressed = null;){
            Http2LocalFlowController flowController = this.connection.local().flowController();
            decompressor.incrementDecompressedBytes(padding);
            while (true) {
                if (decomp.isFinished()) {
                    try (Buffer empty = ctx.bufferAllocator().allocate(0);){
                        int bytes = this.listener.onDataRead(ctx, streamId, empty, padding, endOfStream);
                        flowController.consumeBytes(stream, bytes);
                        break;
                    }
                }
                int idx = data.readerOffset();
                decompressed = decomp.decompress(data, ctx.bufferAllocator());
                if (decompressed == null || idx == data.readerOffset()) {
                    try (Buffer empty = ctx.bufferAllocator().allocate(0);){
                        int bytes = this.listener.onDataRead(ctx, streamId, empty, padding, endOfStream);
                        flowController.consumeBytes(stream, bytes);
                        break;
                    }
                }
                decompressor.incrementDecompressedBytes(decompressed.readableBytes());
                flowController.consumeBytes(stream, this.listener.onDataRead(ctx, streamId, decompressed, padding, false));
                decompressed.close();
                decompressed = null;
                padding = 0;
            }
            int n = 0;
            return n;
        }
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) throws Http2Exception {
        this.initDecompressor(ctx, streamId, headers, endStream);
        this.listener.onHeadersRead(ctx, streamId, headers, padding, endStream);
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
        this.initDecompressor(ctx, streamId, headers, endStream);
        this.listener.onHeadersRead(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream);
    }

    protected Decompressor newContentDecompressor(ChannelHandlerContext ctx, CharSequence contentEncoding) throws Http2Exception {
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(contentEncoding)) {
            return (Decompressor)ZlibDecompressor.newFactory((ZlibWrapper)ZlibWrapper.GZIP).get();
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(contentEncoding)) {
            ZlibWrapper wrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return (Decompressor)ZlibDecompressor.newFactory((ZlibWrapper)wrapper).get();
        }
        if (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase(contentEncoding)) {
            return (Decompressor)BrotliDecompressor.newFactory().get();
        }
        return null;
    }

    protected CharSequence getTargetContentEncoding(CharSequence contentEncoding) throws Http2Exception {
        return HttpHeaderValues.IDENTITY;
    }

    private void initDecompressor(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) throws Http2Exception {
        Http2Stream stream = this.connection.stream(streamId);
        if (stream == null) {
            return;
        }
        Http2Decompressor decompressor = this.decompressor(stream);
        if (decompressor == null && !endOfStream) {
            Decompressor decomp;
            CharSequence contentEncoding = headers.get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
            if (contentEncoding == null) {
                contentEncoding = HttpHeaderValues.IDENTITY;
            }
            if ((decomp = this.newContentDecompressor(ctx, contentEncoding)) != null) {
                decompressor = new Http2Decompressor(decomp);
                stream.setProperty(this.propertyKey, decompressor);
                CharSequence targetContentEncoding = this.getTargetContentEncoding(contentEncoding);
                if (HttpHeaderValues.IDENTITY.contentEqualsIgnoreCase(targetContentEncoding)) {
                    headers.remove((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
                } else {
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, targetContentEncoding);
                }
            }
        }
        if (decompressor != null) {
            headers.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            if (!this.flowControllerInitialized) {
                this.flowControllerInitialized = true;
                this.connection.local().flowController(new ConsumedBytesConverter(this.connection.local().flowController()));
            }
        }
    }

    Http2Decompressor decompressor(Http2Stream stream) {
        return stream == null ? null : (Http2Decompressor)stream.getProperty(this.propertyKey);
    }

    private static void cleanup(Http2Decompressor decompressor) {
        decompressor.decompressor().close();
    }

    private static final class Http2Decompressor {
        private final Decompressor decompressor;
        private int compressed;
        private int decompressed;

        Http2Decompressor(Decompressor decompressor) {
            this.decompressor = decompressor;
        }

        Decompressor decompressor() {
            return this.decompressor;
        }

        void incrementCompressedBytes(int delta) {
            assert (delta >= 0);
            this.compressed += delta;
        }

        void incrementDecompressedBytes(int delta) {
            assert (delta >= 0);
            this.decompressed += delta;
        }

        int consumeBytes(int streamId, int decompressedBytes) throws Http2Exception {
            ObjectUtil.checkPositiveOrZero((int)decompressedBytes, (String)"decompressedBytes");
            if (this.decompressed - decompressedBytes < 0) {
                throw Http2Exception.streamError(streamId, Http2Error.INTERNAL_ERROR, "Attempting to return too many bytes for stream %d. decompressed: %d decompressedBytes: %d", streamId, this.decompressed, decompressedBytes);
            }
            double consumedRatio = (double)decompressedBytes / (double)this.decompressed;
            int consumedCompressed = Math.min(this.compressed, (int)Math.ceil((double)this.compressed * consumedRatio));
            if (this.compressed - consumedCompressed < 0) {
                throw Http2Exception.streamError(streamId, Http2Error.INTERNAL_ERROR, "overflow when converting decompressed bytes to compressed bytes for stream %d.decompressedBytes: %d decompressed: %d compressed: %d consumedCompressed: %d", streamId, decompressedBytes, this.decompressed, this.compressed, consumedCompressed);
            }
            this.decompressed -= decompressedBytes;
            this.compressed -= consumedCompressed;
            return consumedCompressed;
        }
    }

    private final class ConsumedBytesConverter
    implements Http2LocalFlowController {
        private final Http2LocalFlowController flowController;

        ConsumedBytesConverter(Http2LocalFlowController flowController) {
            this.flowController = Objects.requireNonNull(flowController, "flowController");
        }

        @Override
        public Http2LocalFlowController frameWriter(Http2FrameWriter frameWriter) {
            return this.flowController.frameWriter(frameWriter);
        }

        @Override
        public void channelHandlerContext(ChannelHandlerContext ctx) throws Http2Exception {
            this.flowController.channelHandlerContext(ctx);
        }

        @Override
        public void initialWindowSize(int newWindowSize) throws Http2Exception {
            this.flowController.initialWindowSize(newWindowSize);
        }

        @Override
        public int initialWindowSize() {
            return this.flowController.initialWindowSize();
        }

        @Override
        public int windowSize(Http2Stream stream) {
            return this.flowController.windowSize(stream);
        }

        @Override
        public void incrementWindowSize(Http2Stream stream, int delta) throws Http2Exception {
            this.flowController.incrementWindowSize(stream, delta);
        }

        @Override
        public void receiveFlowControlledFrame(Http2Stream stream, Buffer data, int padding, boolean endOfStream) throws Http2Exception {
            this.flowController.receiveFlowControlledFrame(stream, data, padding, endOfStream);
        }

        @Override
        public boolean consumeBytes(Http2Stream stream, int numBytes) throws Http2Exception {
            Http2Decompressor decompressor = DelegatingDecompressorFrameListener.this.decompressor(stream);
            if (decompressor != null) {
                numBytes = decompressor.consumeBytes(stream.id(), numBytes);
            }
            try {
                return this.flowController.consumeBytes(stream, numBytes);
            }
            catch (Http2Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw Http2Exception.streamError(stream.id(), Http2Error.INTERNAL_ERROR, t, "Error while returning bytes to flow control window", new Object[0]);
            }
        }

        @Override
        public int unconsumedBytes(Http2Stream stream) {
            return this.flowController.unconsumedBytes(stream);
        }

        @Override
        public int initialWindowSize(Http2Stream stream) {
            return this.flowController.initialWindowSize(stream);
        }
    }
}

