/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.base64.Base64;
import io.netty5.handler.codec.base64.Base64Dialect;
import io.netty5.handler.codec.http.FullHttpResponse;
import io.netty5.handler.codec.http.HttpClientUpgradeHandler;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http2.Http2CodecUtil;
import io.netty5.handler.codec.http2.Http2ConnectionHandler;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2FrameCodec;
import io.netty5.handler.codec.http2.Http2MultiplexHandler;
import io.netty5.handler.codec.http2.Http2Settings;
import io.netty5.util.Send;
import io.netty5.util.collection.CharObjectMap;
import io.netty5.util.internal.UnstableApi;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@UnstableApi
public class Http2ClientUpgradeCodec
implements HttpClientUpgradeHandler.UpgradeCodec {
    private static final List<CharSequence> UPGRADE_HEADERS = Collections.singletonList(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
    private final String handlerName;
    private final Http2ConnectionHandler connectionHandler;
    private final ChannelHandler upgradeToHandler;
    private final ChannelHandler http2MultiplexHandler;

    public Http2ClientUpgradeCodec(Http2FrameCodec frameCodec, ChannelHandler upgradeToHandler) {
        this(null, frameCodec, upgradeToHandler);
    }

    public Http2ClientUpgradeCodec(String handlerName, Http2FrameCodec frameCodec, ChannelHandler upgradeToHandler) {
        this(handlerName, frameCodec, upgradeToHandler, null);
    }

    public Http2ClientUpgradeCodec(Http2ConnectionHandler connectionHandler) {
        this((String)null, connectionHandler);
    }

    public Http2ClientUpgradeCodec(Http2ConnectionHandler connectionHandler, Http2MultiplexHandler http2MultiplexHandler) {
        this(null, connectionHandler, http2MultiplexHandler);
    }

    public Http2ClientUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler) {
        this(handlerName, connectionHandler, (ChannelHandler)connectionHandler, null);
    }

    public Http2ClientUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler, Http2MultiplexHandler http2MultiplexHandler) {
        this(handlerName, connectionHandler, (ChannelHandler)connectionHandler, http2MultiplexHandler);
    }

    private Http2ClientUpgradeCodec(String handlerName, Http2ConnectionHandler connectionHandler, ChannelHandler upgradeToHandler, Http2MultiplexHandler http2MultiplexHandler) {
        this.handlerName = handlerName;
        this.connectionHandler = Objects.requireNonNull(connectionHandler, "connectionHandler");
        this.upgradeToHandler = Objects.requireNonNull(upgradeToHandler, "upgradeToHandler");
        this.http2MultiplexHandler = http2MultiplexHandler;
    }

    public CharSequence protocol() {
        return Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME;
    }

    public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext ctx, HttpRequest upgradeRequest) {
        CharSequence settingsValue = this.getSettingsHeaderValue(ctx);
        upgradeRequest.headers().set(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER, settingsValue);
        return UPGRADE_HEADERS;
    }

    public void upgradeTo(ChannelHandlerContext ctx, Send<FullHttpResponse> upgradeResponse) throws Exception {
        upgradeResponse.close();
        try {
            ctx.pipeline().addAfter(ctx.name(), this.handlerName, this.upgradeToHandler);
            if (this.http2MultiplexHandler != null) {
                String name = ctx.pipeline().context((ChannelHandler)this.connectionHandler).name();
                ctx.pipeline().addAfter(name, null, this.http2MultiplexHandler);
            }
            this.connectionHandler.onHttpClientUpgrade();
        }
        catch (Http2Exception e) {
            ctx.fireChannelExceptionCaught((Throwable)e);
            ctx.close();
        }
    }

    private CharSequence getSettingsHeaderValue(ChannelHandlerContext ctx) {
        Http2Settings settings = this.connectionHandler.decoder().localSettings();
        int payloadLength = 6 * settings.size();
        try (Buffer buf = ctx.bufferAllocator().allocate(payloadLength);){
            String string;
            block13: {
                for (CharObjectMap.PrimitiveEntry entry : settings.entries()) {
                    buf.writeChar(entry.key());
                    buf.writeInt(((Long)entry.value()).intValue());
                }
                Buffer encodedBuf = Base64.encode((Buffer)buf, (Base64Dialect)Base64Dialect.URL_SAFE);
                try {
                    string = encodedBuf.toString(StandardCharsets.UTF_8);
                    if (encodedBuf == null) break block13;
                }
                catch (Throwable throwable) {
                    if (encodedBuf != null) {
                        try {
                            encodedBuf.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                encodedBuf.close();
            }
            return string;
        }
    }
}

