/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.http2.Http2Error;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2Flags;
import io.netty5.handler.codec.http2.StreamByteDistributor;
import io.netty5.util.AsciiString;
import io.netty5.util.concurrent.DefaultPromise;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.UnstableApi;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@UnstableApi
public final class Http2CodecUtil {
    public static final int CONNECTION_STREAM_ID = 0;
    public static final int HTTP_UPGRADE_STREAM_ID = 1;
    public static final CharSequence HTTP_UPGRADE_SETTINGS_HEADER = AsciiString.cached((String)"HTTP2-Settings");
    public static final CharSequence HTTP_UPGRADE_PROTOCOL_NAME = "h2c";
    public static final CharSequence TLS_UPGRADE_PROTOCOL_NAME = "h2";
    public static final int PING_FRAME_PAYLOAD_LENGTH = 8;
    public static final short MAX_UNSIGNED_BYTE = 255;
    public static final int MAX_PADDING = 256;
    public static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    public static final int FRAME_HEADER_LENGTH = 9;
    public static final int SETTING_ENTRY_LENGTH = 6;
    public static final int PRIORITY_ENTRY_LENGTH = 5;
    public static final int INT_FIELD_LENGTH = 4;
    public static final short MAX_WEIGHT = 256;
    public static final short MIN_WEIGHT = 1;
    public static final Supplier<Buffer> CONNECTION_PREFACE_BUFFER = DefaultBufferAllocators.offHeapAllocator().constBufferSupplier("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(StandardCharsets.UTF_8));
    private static final int MAX_PADDING_LENGTH_LENGTH = 1;
    public static final int DATA_FRAME_HEADER_LENGTH = 10;
    public static final int HEADERS_FRAME_HEADER_LENGTH = 15;
    public static final int PRIORITY_FRAME_LENGTH = 14;
    public static final int RST_STREAM_FRAME_LENGTH = 13;
    public static final int PUSH_PROMISE_FRAME_HEADER_LENGTH = 14;
    public static final int GO_AWAY_FRAME_HEADER_LENGTH = 17;
    public static final int WINDOW_UPDATE_FRAME_LENGTH = 13;
    public static final int CONTINUATION_FRAME_HEADER_LENGTH = 10;
    public static final char SETTINGS_HEADER_TABLE_SIZE = '\u0001';
    public static final char SETTINGS_ENABLE_PUSH = '\u0002';
    public static final char SETTINGS_MAX_CONCURRENT_STREAMS = '\u0003';
    public static final char SETTINGS_INITIAL_WINDOW_SIZE = '\u0004';
    public static final char SETTINGS_MAX_FRAME_SIZE = '\u0005';
    public static final char SETTINGS_MAX_HEADER_LIST_SIZE = '\u0006';
    public static final int NUM_STANDARD_SETTINGS = 6;
    public static final long MAX_HEADER_TABLE_SIZE = 0xFFFFFFFFL;
    public static final long MAX_CONCURRENT_STREAMS = 0xFFFFFFFFL;
    public static final int MAX_INITIAL_WINDOW_SIZE = Integer.MAX_VALUE;
    public static final int MAX_FRAME_SIZE_LOWER_BOUND = 16384;
    public static final int MAX_FRAME_SIZE_UPPER_BOUND = 0xFFFFFF;
    public static final long MAX_HEADER_LIST_SIZE = 0xFFFFFFFFL;
    public static final long MIN_HEADER_TABLE_SIZE = 0L;
    public static final long MIN_CONCURRENT_STREAMS = 0L;
    public static final int MIN_INITIAL_WINDOW_SIZE = 0;
    public static final long MIN_HEADER_LIST_SIZE = 0L;
    public static final int DEFAULT_WINDOW_SIZE = 65535;
    public static final short DEFAULT_PRIORITY_WEIGHT = 16;
    public static final int DEFAULT_HEADER_TABLE_SIZE = 4096;
    public static final long DEFAULT_HEADER_LIST_SIZE = 8192L;
    public static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    public static final int SMALLEST_MAX_CONCURRENT_STREAMS = 100;
    static final int DEFAULT_MAX_RESERVED_STREAMS = 100;
    static final int DEFAULT_MIN_ALLOCATION_CHUNK = 1024;
    public static final long DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT_MILLIS = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
    public static final int DEFAULT_MAX_QUEUED_CONTROL_FRAMES = 10000;

    public static long calculateMaxHeaderListSizeGoAway(long maxHeaderListSize) {
        return maxHeaderListSize + (maxHeaderListSize >>> 2);
    }

    public static boolean isOutboundStream(boolean server, int streamId) {
        boolean even = (streamId & 1) == 0;
        return streamId > 0 && server == even;
    }

    public static boolean isStreamIdValid(int streamId) {
        return streamId >= 0;
    }

    static boolean isStreamIdValid(int streamId, boolean server) {
        return Http2CodecUtil.isStreamIdValid(streamId) && server == ((streamId & 1) == 0);
    }

    public static boolean isMaxFrameSizeValid(int maxFrameSize) {
        return maxFrameSize >= 16384 && maxFrameSize <= 0xFFFFFF;
    }

    public static Buffer connectionPrefaceBuffer() {
        return CONNECTION_PREFACE_BUFFER.get();
    }

    public static Http2Exception getEmbeddedHttp2Exception(Throwable cause) {
        while (cause != null) {
            if (cause instanceof Http2Exception) {
                return (Http2Exception)cause;
            }
            cause = cause.getCause();
        }
        return null;
    }

    public static Buffer toBuffer(ChannelHandlerContext ctx, Throwable cause) {
        BufferAllocator allocator = ctx.bufferAllocator();
        if (cause == null || cause.getMessage() == null) {
            return allocator.allocate(0);
        }
        return allocator.copyOf(cause.getMessage().getBytes(StandardCharsets.UTF_8));
    }

    public static int readUnsignedInt(Buffer buf) {
        return buf.readInt() & Integer.MAX_VALUE;
    }

    public static void writeFrameHeader(Buffer out, int payloadLength, byte type, Http2Flags flags, int streamId) {
        out.ensureWritable(9 + payloadLength);
        Http2CodecUtil.writeFrameHeaderInternal(out, payloadLength, type, flags, streamId);
    }

    public static int streamableBytes(StreamByteDistributor.StreamState state) {
        return Math.max(0, (int)Math.min(state.pendingBytes(), (long)state.windowSize()));
    }

    public static void headerListSizeExceeded(int streamId, long maxHeaderListSize, boolean onDecode) throws Http2Exception {
        throw Http2Exception.headerListSizeError(streamId, Http2Error.PROTOCOL_ERROR, onDecode, "Header size exceeded max allowed size (%d)", maxHeaderListSize);
    }

    public static void headerListSizeExceeded(long maxHeaderListSize) throws Http2Exception {
        throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header size exceeded max allowed size (%d)", maxHeaderListSize);
    }

    static void writeFrameHeaderInternal(Buffer out, int payloadLength, byte type, Http2Flags flags, int streamId) {
        out.writeMedium(payloadLength);
        out.writeByte(type);
        out.writeByte((byte)flags.value());
        out.writeInt(streamId);
    }

    public static void verifyPadding(int padding) {
        if (padding < 0 || padding > 256) {
            throw new IllegalArgumentException(String.format("Invalid padding '%d'. Padding must be between 0 and %d (inclusive).", padding, 256));
        }
    }

    private Http2CodecUtil() {
    }

    static final class SimpleChannelPromiseAggregator
    extends DefaultPromise<Void> {
        private final Promise<Void> promise;
        private int expectedCount;
        private int doneCount;
        private Throwable aggregateFailure;
        private boolean doneAllocating;

        SimpleChannelPromiseAggregator(Promise<Void> promise, EventExecutor e) {
            super(e);
            assert (promise != null && !promise.isDone());
            this.promise = promise;
        }

        public Promise<Void> newPromise() {
            assert (!this.doneAllocating) : "Done allocating. No more promises can be allocated.";
            ++this.expectedCount;
            return this;
        }

        public Future<Void> doneAllocatingPromises() {
            if (!this.doneAllocating) {
                this.doneAllocating = true;
                if (this.doneCount == this.expectedCount || this.expectedCount == 0) {
                    return this.setPromise().asFuture();
                }
            }
            return this;
        }

        public boolean tryFailure(Throwable cause) {
            if (this.allowFailure()) {
                ++this.doneCount;
                this.setAggregateFailure(cause);
                if (this.allPromisesDone()) {
                    return this.tryPromise();
                }
                return true;
            }
            return false;
        }

        public Promise<Void> setFailure(Throwable cause) {
            if (this.allowFailure()) {
                ++this.doneCount;
                this.setAggregateFailure(cause);
                if (this.allPromisesDone()) {
                    this.setPromise();
                }
            }
            return this;
        }

        public Promise<Void> setSuccess(Void result) {
            if (this.awaitingPromises()) {
                ++this.doneCount;
                if (this.allPromisesDone()) {
                    this.setPromise();
                }
            }
            return this;
        }

        public boolean trySuccess(Void result) {
            if (this.awaitingPromises()) {
                ++this.doneCount;
                if (this.allPromisesDone()) {
                    return this.tryPromise();
                }
                return true;
            }
            return false;
        }

        private boolean allowFailure() {
            return this.awaitingPromises() || this.expectedCount == 0;
        }

        private boolean awaitingPromises() {
            return this.doneCount < this.expectedCount;
        }

        private boolean allPromisesDone() {
            return this.doneCount == this.expectedCount && this.doneAllocating;
        }

        private Promise<Void> setPromise() {
            if (this.aggregateFailure == null) {
                this.promise.setSuccess(null);
                super.setSuccess(null);
            } else {
                this.promise.setFailure(this.aggregateFailure);
                super.setFailure(this.aggregateFailure);
            }
            return this;
        }

        private boolean tryPromise() {
            if (this.aggregateFailure == null) {
                this.promise.trySuccess(null);
                return super.trySuccess(null);
            }
            this.promise.tryFailure(this.aggregateFailure);
            return super.tryFailure(this.aggregateFailure);
        }

        private void setAggregateFailure(Throwable cause) {
            if (this.aggregateFailure == null) {
                this.aggregateFailure = cause;
            }
        }
    }
}

