/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty5.handler.codec.http2.Http2DataFrame;
import io.netty5.handler.codec.http2.Http2FrameStream;
import io.netty5.handler.stream.ChunkedInput;
import io.netty5.util.Send;
import java.util.Objects;

public final class Http2DataChunkedInput
implements ChunkedInput<Http2DataFrame> {
    private final ChunkedInput<Buffer> input;
    private final Http2FrameStream stream;
    private boolean endStreamSent;

    public Http2DataChunkedInput(ChunkedInput<Buffer> input, Http2FrameStream stream) {
        this.input = Objects.requireNonNull(input, "input");
        this.stream = Objects.requireNonNull(stream, "stream");
    }

    public boolean isEndOfInput() throws Exception {
        if (this.input.isEndOfInput()) {
            return this.endStreamSent;
        }
        return false;
    }

    public void close() throws Exception {
        this.input.close();
    }

    public Http2DataFrame readChunk(BufferAllocator allocator) throws Exception {
        if (this.endStreamSent) {
            return null;
        }
        if (this.input.isEndOfInput()) {
            this.endStreamSent = true;
            return new DefaultHttp2DataFrame(true).stream(this.stream);
        }
        Buffer buf = (Buffer)this.input.readChunk(allocator);
        if (buf == null) {
            return null;
        }
        DefaultHttp2DataFrame dataFrame = new DefaultHttp2DataFrame((Send<Buffer>)buf.send(), this.input.isEndOfInput()).stream(this.stream);
        if (dataFrame.isEndStream()) {
            this.endStreamSent = true;
        }
        return dataFrame;
    }

    public long length() {
        return this.input.length();
    }

    public long progress() {
        return this.input.progress();
    }
}

