/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.UnsupportedMessageTypeException;
import io.netty5.handler.codec.http.HttpServerUpgradeHandler;
import io.netty5.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty5.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty5.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty5.handler.codec.http2.DefaultHttp2PingFrame;
import io.netty5.handler.codec.http2.DefaultHttp2PriorityFrame;
import io.netty5.handler.codec.http2.DefaultHttp2PushPromiseFrame;
import io.netty5.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty5.handler.codec.http2.DefaultHttp2SettingsFrame;
import io.netty5.handler.codec.http2.DefaultHttp2UnknownFrame;
import io.netty5.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.netty5.handler.codec.http2.Http2CodecUtil;
import io.netty5.handler.codec.http2.Http2Connection;
import io.netty5.handler.codec.http2.Http2ConnectionAdapter;
import io.netty5.handler.codec.http2.Http2ConnectionDecoder;
import io.netty5.handler.codec.http2.Http2ConnectionEncoder;
import io.netty5.handler.codec.http2.Http2ConnectionHandler;
import io.netty5.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty5.handler.codec.http2.Http2DataFrame;
import io.netty5.handler.codec.http2.Http2Error;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2Flags;
import io.netty5.handler.codec.http2.Http2Frame;
import io.netty5.handler.codec.http2.Http2FrameListener;
import io.netty5.handler.codec.http2.Http2FrameStream;
import io.netty5.handler.codec.http2.Http2FrameStreamEvent;
import io.netty5.handler.codec.http2.Http2FrameStreamException;
import io.netty5.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty5.handler.codec.http2.Http2GoAwayFrame;
import io.netty5.handler.codec.http2.Http2HeadersFrame;
import io.netty5.handler.codec.http2.Http2LocalFlowController;
import io.netty5.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty5.handler.codec.http2.Http2PingFrame;
import io.netty5.handler.codec.http2.Http2PriorityFrame;
import io.netty5.handler.codec.http2.Http2PushPromiseFrame;
import io.netty5.handler.codec.http2.Http2RemoteFlowController;
import io.netty5.handler.codec.http2.Http2ResetFrame;
import io.netty5.handler.codec.http2.Http2Settings;
import io.netty5.handler.codec.http2.Http2SettingsAckFrame;
import io.netty5.handler.codec.http2.Http2SettingsFrame;
import io.netty5.handler.codec.http2.Http2Stream;
import io.netty5.handler.codec.http2.Http2UnknownFrame;
import io.netty5.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty5.handler.codec.http2.HttpConversionUtil;
import io.netty5.handler.codec.http2.InboundHttpToHttp2Adapter;
import io.netty5.handler.codec.http2.headers.Http2Headers;
import io.netty5.util.Resource;
import io.netty5.util.Send;
import io.netty5.util.collection.IntObjectHashMap;
import io.netty5.util.collection.IntObjectMap;
import io.netty5.util.concurrent.Future;
import io.netty5.util.internal.UnstableApi;
import io.netty5.util.internal.logging.InternalLogLevel;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.nio.charset.StandardCharsets;

@UnstableApi
public class Http2FrameCodec
extends Http2ConnectionHandler {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(Http2FrameCodec.class);
    protected final Http2Connection.PropertyKey streamKey;
    private final Http2Connection.PropertyKey upgradeKey;
    private final Integer initialFlowControlWindowSize;
    ChannelHandlerContext ctx;
    private int numBufferedStreams;
    private final IntObjectMap<DefaultHttp2FrameStream> frameStreamToInitializeMap = new IntObjectHashMap(8);

    Http2FrameCodec(Http2ConnectionEncoder encoder, Http2ConnectionDecoder decoder, Http2Settings initialSettings, boolean decoupleCloseAndGoAway, boolean flushPreface) {
        super(decoder, encoder, initialSettings, decoupleCloseAndGoAway, flushPreface);
        decoder.frameListener(new FrameListener());
        this.connection().addListener(new ConnectionListener());
        this.connection().remote().flowController().listener(new Http2RemoteFlowControllerListener());
        this.streamKey = this.connection().newKey();
        this.upgradeKey = this.connection().newKey();
        this.initialFlowControlWindowSize = initialSettings.initialWindowSize();
    }

    DefaultHttp2FrameStream newStream() {
        return new DefaultHttp2FrameStream();
    }

    final void forEachActiveStream(Http2FrameStreamVisitor streamVisitor) throws Http2Exception {
        assert (this.ctx.executor().inEventLoop());
        if (this.connection().numActiveStreams() > 0) {
            this.connection().forEachActiveStream((Http2Stream stream) -> {
                try {
                    return streamVisitor.visit((Http2FrameStream)stream.getProperty(this.streamKey));
                }
                catch (Throwable cause) {
                    this.onError(this.ctx, false, cause);
                    return false;
                }
            });
        }
    }

    int numInitializingStreams() {
        return this.frameStreamToInitializeMap.size();
    }

    @Override
    public void handlerAdded0(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded0(ctx);
        this.ctx = ctx;
        Http2Connection connection = this.connection();
        if (connection.isServer()) {
            this.tryExpandConnectionFlowControlWindow(connection);
        }
    }

    private void tryExpandConnectionFlowControlWindow(Http2Connection connection) throws Http2Exception {
        if (this.initialFlowControlWindowSize != null) {
            Http2Stream connectionStream = connection.connectionStream();
            Http2LocalFlowController localFlowController = connection.local().flowController();
            int delta = this.initialFlowControlWindowSize - localFlowController.initialWindowSize(connectionStream);
            if (delta > 0) {
                localFlowController.incrementWindowSize(connectionStream, Math.max(delta << 1, delta));
                this.flush(this.ctx);
            }
        }
    }

    public final void channelInboundEvent(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE) {
            this.tryExpandConnectionFlowControlWindow(this.connection());
            ctx.executor().execute(() -> ctx.fireChannelInboundEvent(evt));
        } else if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            try (HttpServerUpgradeHandler.UpgradeEvent upgrade = (HttpServerUpgradeHandler.UpgradeEvent)evt;){
                ctx.fireChannelInboundEvent((Object)upgrade.copy());
                Http2Stream stream = this.connection().stream(1);
                if (stream.getProperty(this.streamKey) == null) {
                    this.onStreamActive0(stream);
                }
                upgrade.upgradeRequest().headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (CharSequence)String.valueOf(1));
                stream.setProperty(this.upgradeKey, true);
                InboundHttpToHttp2Adapter.handle(ctx, this.connection(), this.decoder().frameListener(), upgrade.upgradeRequest());
            }
        } else {
            ctx.fireChannelInboundEvent(evt);
        }
    }

    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Http2DataFrame) {
            Http2DataFrame dataFrame = (Http2DataFrame)msg;
            return this.encoder().writeData(ctx, dataFrame.stream().id(), dataFrame.content(), dataFrame.padding(), dataFrame.isEndStream());
        }
        if (msg instanceof Http2HeadersFrame) {
            return this.writeHeadersFrame(ctx, (Http2HeadersFrame)msg);
        }
        if (msg instanceof Http2WindowUpdateFrame) {
            Http2WindowUpdateFrame frame = (Http2WindowUpdateFrame)msg;
            Http2FrameStream frameStream = frame.stream();
            try {
                if (frameStream == null) {
                    this.increaseInitialConnectionWindow(frame.windowSizeIncrement());
                } else {
                    this.consumeBytes(frameStream.id(), frame.windowSizeIncrement());
                }
                return ctx.newSucceededFuture();
            }
            catch (Throwable t) {
                return ctx.newFailedFuture(t);
            }
        }
        if (msg instanceof Http2ResetFrame) {
            Http2ResetFrame rstFrame = (Http2ResetFrame)msg;
            int id = rstFrame.stream().id();
            if (this.connection().streamMayHaveExisted(id)) {
                return this.encoder().writeRstStream(ctx, rstFrame.stream().id(), rstFrame.errorCode());
            }
            Resource.dispose((Object)rstFrame);
            return ctx.newFailedFuture((Throwable)Http2Exception.streamError(rstFrame.stream().id(), Http2Error.PROTOCOL_ERROR, "Stream never existed", new Object[0]));
        }
        if (msg instanceof Http2PingFrame) {
            Http2PingFrame frame = (Http2PingFrame)msg;
            return this.encoder().writePing(ctx, frame.ack(), frame.content());
        }
        if (msg instanceof Http2SettingsFrame) {
            return this.encoder().writeSettings(ctx, ((Http2SettingsFrame)msg).settings());
        }
        if (msg instanceof Http2SettingsAckFrame) {
            return this.encoder().writeSettingsAck(ctx);
        }
        if (msg instanceof Http2GoAwayFrame) {
            return this.writeGoAwayFrame(ctx, (Http2GoAwayFrame)msg);
        }
        if (msg instanceof Http2PushPromiseFrame) {
            Http2PushPromiseFrame pushPromiseFrame = (Http2PushPromiseFrame)msg;
            return this.writePushPromise(ctx, pushPromiseFrame);
        }
        if (msg instanceof Http2PriorityFrame) {
            Http2PriorityFrame priorityFrame = (Http2PriorityFrame)msg;
            return this.encoder().writePriority(ctx, priorityFrame.stream().id(), priorityFrame.streamDependency(), priorityFrame.weight(), priorityFrame.exclusive());
        }
        if (msg instanceof Http2UnknownFrame) {
            Http2UnknownFrame unknownFrame = (Http2UnknownFrame)msg;
            return this.encoder().writeFrame(ctx, unknownFrame.frameType(), unknownFrame.stream().id(), unknownFrame.flags(), unknownFrame.content());
        }
        if (!(msg instanceof Http2Frame)) {
            return ctx.write(msg);
        }
        Resource.dispose((Object)msg);
        return ctx.newFailedFuture((Throwable)new UnsupportedMessageTypeException(msg, new Class[0]));
    }

    private void increaseInitialConnectionWindow(int deltaBytes) throws Http2Exception {
        this.connection().local().flowController().incrementWindowSize(this.connection().connectionStream(), deltaBytes);
    }

    final boolean consumeBytes(int streamId, int bytes) throws Http2Exception {
        Boolean upgraded;
        Http2Stream stream = this.connection().stream(streamId);
        if (stream != null && streamId == 1 && Boolean.TRUE.equals(upgraded = (Boolean)stream.getProperty(this.upgradeKey))) {
            return false;
        }
        return this.connection().local().flowController().consumeBytes(stream, bytes);
    }

    private Future<Void> writeGoAwayFrame(ChannelHandlerContext ctx, Http2GoAwayFrame frame) {
        if (frame.lastStreamId() > -1) {
            frame.close();
            return ctx.newFailedFuture((Throwable)new IllegalArgumentException("Last stream id must not be set on GOAWAY frame"));
        }
        int lastStreamCreated = this.connection().remote().lastStreamCreated();
        long lastStreamId = (long)lastStreamCreated + (long)frame.extraStreamIds() * 2L;
        if (lastStreamId > Integer.MAX_VALUE) {
            lastStreamId = Integer.MAX_VALUE;
        }
        return this.goAway(ctx, (int)lastStreamId, frame.errorCode(), frame.content());
    }

    private Future<Void> writeHeadersFrame(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) {
        if (Http2CodecUtil.isStreamIdValid(headersFrame.stream().id())) {
            return this.encoder().writeHeaders(ctx, headersFrame.stream().id(), headersFrame.headers(), headersFrame.padding(), headersFrame.isEndStream());
        }
        Future<Void> future = this.initializeNewStream(ctx, (DefaultHttp2FrameStream)headersFrame.stream());
        if (future == null) {
            int streamId = headersFrame.stream().id();
            future = this.encoder().writeHeaders(ctx, streamId, headersFrame.headers(), headersFrame.padding(), headersFrame.isEndStream());
            if (!future.isDone()) {
                ++this.numBufferedStreams;
                future.addListener(channelFuture -> {
                    --this.numBufferedStreams;
                    this.handleHeaderFuture(channelFuture, streamId);
                });
            } else {
                this.handleHeaderFuture(future, streamId);
            }
        }
        return future;
    }

    private Future<Void> writePushPromise(ChannelHandlerContext ctx, Http2PushPromiseFrame pushPromiseFrame) {
        if (Http2CodecUtil.isStreamIdValid(pushPromiseFrame.pushStream().id())) {
            return this.encoder().writePushPromise(ctx, pushPromiseFrame.stream().id(), pushPromiseFrame.pushStream().id(), pushPromiseFrame.http2Headers(), pushPromiseFrame.padding());
        }
        Future<Void> future = this.initializeNewStream(ctx, (DefaultHttp2FrameStream)pushPromiseFrame.pushStream());
        if (future == null) {
            int streamId = pushPromiseFrame.stream().id();
            future = this.encoder().writePushPromise(ctx, streamId, pushPromiseFrame.pushStream().id(), pushPromiseFrame.http2Headers(), pushPromiseFrame.padding());
            if (future.isDone()) {
                this.handleHeaderFuture(future, streamId);
            } else {
                ++this.numBufferedStreams;
                future.addListener(f -> {
                    --this.numBufferedStreams;
                    this.handleHeaderFuture(f, streamId);
                });
            }
            return future;
        }
        return future;
    }

    private Future<Void> initializeNewStream(ChannelHandlerContext ctx, DefaultHttp2FrameStream http2FrameStream) {
        Http2Connection connection = this.connection();
        int streamId = connection.local().incrementAndGetNextStreamId();
        if (streamId < 0) {
            Future f = ctx.newFailedFuture((Throwable)new Http2NoMoreStreamIdsException());
            this.onHttp2Frame(ctx, new DefaultHttp2GoAwayFrame(connection.isServer() ? Integer.MAX_VALUE : 0x7FFFFFFE, Http2Error.NO_ERROR.code(), (Send<Buffer>)ctx.bufferAllocator().copyOf("Stream IDs exhausted on local stream creation", StandardCharsets.US_ASCII).send()));
            return f;
        }
        http2FrameStream.id = streamId;
        Object old = this.frameStreamToInitializeMap.put(streamId, (Object)http2FrameStream);
        assert (old == null);
        return null;
    }

    private void handleHeaderFuture(Future<?> channelFuture, int streamId) {
        if (channelFuture.isFailed()) {
            this.frameStreamToInitializeMap.remove(streamId);
        }
    }

    private void onStreamActive0(Http2Stream stream) {
        if (stream.id() != 1 && this.connection().local().isValidStreamId(stream.id())) {
            return;
        }
        DefaultHttp2FrameStream stream2 = this.newStream().setStreamAndProperty(this.streamKey, stream);
        this.onHttp2StreamStateChanged(this.ctx, stream2);
    }

    @Override
    protected void onConnectionError(ChannelHandlerContext ctx, boolean outbound, Throwable cause, Http2Exception http2Ex) {
        if (!outbound) {
            ctx.fireChannelExceptionCaught(cause);
        }
        super.onConnectionError(ctx, outbound, cause, http2Ex);
    }

    @Override
    protected final void onStreamError(ChannelHandlerContext ctx, boolean outbound, Throwable cause, Http2Exception.StreamException streamException) {
        int streamId = streamException.streamId();
        Http2Stream connectionStream = this.connection().stream(streamId);
        if (connectionStream == null) {
            Http2FrameCodec.onHttp2UnknownStreamError(ctx, cause, streamException);
            super.onStreamError(ctx, outbound, cause, streamException);
            return;
        }
        Http2FrameStream stream = (Http2FrameStream)connectionStream.getProperty(this.streamKey);
        if (stream == null) {
            LOG.warn("Stream exception thrown without stream object attached.", cause);
            super.onStreamError(ctx, outbound, cause, streamException);
            return;
        }
        if (!outbound) {
            this.onHttp2FrameStreamException(ctx, new Http2FrameStreamException(stream, streamException.error(), cause));
        }
    }

    private static void onHttp2UnknownStreamError(ChannelHandlerContext ctx, Throwable cause, Http2Exception.StreamException streamException) {
        LOG.log(InternalLogLevel.DEBUG, "Stream exception thrown for unknown stream {}.", (Object)streamException.streamId(), (Object)cause);
    }

    @Override
    protected final boolean isGracefulShutdownComplete() {
        return super.isGracefulShutdownComplete() && this.numBufferedStreams == 0;
    }

    private void onHttp2StreamWritabilityChanged(ChannelHandlerContext ctx, DefaultHttp2FrameStream stream, boolean writable) {
        ctx.fireChannelInboundEvent((Object)stream.writabilityChanged);
    }

    void onHttp2StreamStateChanged(ChannelHandlerContext ctx, DefaultHttp2FrameStream stream) {
        ctx.fireChannelInboundEvent((Object)stream.stateChanged);
    }

    void onHttp2Frame(ChannelHandlerContext ctx, Http2Frame frame) {
        ctx.fireChannelRead((Object)frame);
    }

    void onHttp2FrameStreamException(ChannelHandlerContext ctx, Http2FrameStreamException cause) {
        ctx.fireChannelExceptionCaught((Throwable)cause);
    }

    static class DefaultHttp2FrameStream
    implements Http2FrameStream {
        private volatile int id = -1;
        private volatile Http2Stream stream;
        final Http2FrameStreamEvent stateChanged = Http2FrameStreamEvent.stateChanged(this);
        final Http2FrameStreamEvent writabilityChanged = Http2FrameStreamEvent.writabilityChanged(this);
        Channel attachment;

        DefaultHttp2FrameStream() {
        }

        DefaultHttp2FrameStream setStreamAndProperty(Http2Connection.PropertyKey streamKey, Http2Stream stream) {
            assert (this.id == -1 || stream.id() == this.id);
            this.stream = stream;
            stream.setProperty(streamKey, this);
            return this;
        }

        @Override
        public int id() {
            Http2Stream stream = this.stream;
            return stream == null ? this.id : stream.id();
        }

        @Override
        public Http2Stream.State state() {
            Http2Stream stream = this.stream;
            return stream == null ? Http2Stream.State.IDLE : stream.state();
        }

        public String toString() {
            return String.valueOf(this.id());
        }
    }

    private final class Http2RemoteFlowControllerListener
    implements Http2RemoteFlowController.Listener {
        private Http2RemoteFlowControllerListener() {
        }

        @Override
        public void writabilityChanged(Http2Stream stream) {
            DefaultHttp2FrameStream frameStream = (DefaultHttp2FrameStream)stream.getProperty(Http2FrameCodec.this.streamKey);
            if (frameStream == null) {
                return;
            }
            Http2FrameCodec.this.onHttp2StreamWritabilityChanged(Http2FrameCodec.this.ctx, frameStream, Http2FrameCodec.this.connection().remote().flowController().isWritable(stream));
        }
    }

    private final class FrameListener
    implements Http2FrameListener {
        private FrameListener() {
        }

        @Override
        public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, Buffer payload) {
            if (streamId == 0) {
                return;
            }
            Http2FrameCodec.this.onHttp2Frame(ctx, new DefaultHttp2UnknownFrame(frameType, flags, payload.split()).stream(this.requireStream(streamId)));
        }

        @Override
        public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
            Http2FrameCodec.this.onHttp2Frame(ctx, new DefaultHttp2SettingsFrame(settings));
        }

        @Override
        public void onPingRead(ChannelHandlerContext ctx, long data) {
            Http2FrameCodec.this.onHttp2Frame(ctx, new DefaultHttp2PingFrame(data, false));
        }

        @Override
        public void onPingAckRead(ChannelHandlerContext ctx, long data) {
            Http2FrameCodec.this.onHttp2Frame(ctx, new DefaultHttp2PingFrame(data, true));
        }

        @Override
        public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
            Http2FrameCodec.this.onHttp2Frame(ctx, new DefaultHttp2ResetFrame(errorCode).stream(this.requireStream(streamId)));
        }

        @Override
        public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
            if (streamId == 0) {
                return;
            }
            Http2FrameCodec.this.onHttp2Frame(ctx, new DefaultHttp2WindowUpdateFrame(windowSizeIncrement).stream(this.requireStream(streamId)));
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
            this.onHeadersRead(ctx, streamId, headers, padding, endStream);
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) {
            Http2FrameCodec.this.onHttp2Frame(ctx, new DefaultHttp2HeadersFrame(headers, endOfStream, padding).stream(this.requireStream(streamId)));
        }

        @Override
        public int onDataRead(ChannelHandlerContext ctx, int streamId, Buffer data, int padding, boolean endOfStream) {
            Http2FrameCodec.this.onHttp2Frame(ctx, new DefaultHttp2DataFrame((Send<Buffer>)data.send(), endOfStream, padding).stream(this.requireStream(streamId)));
            return 0;
        }

        @Override
        public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, Buffer debugData) {
            Http2FrameCodec.this.onHttp2Frame(ctx, new DefaultHttp2GoAwayFrame(lastStreamId, errorCode, (Send<Buffer>)debugData.send()));
        }

        @Override
        public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
            Http2Stream stream = Http2FrameCodec.this.connection().stream(streamId);
            if (stream == null) {
                return;
            }
            Http2FrameCodec.this.onHttp2Frame(ctx, new DefaultHttp2PriorityFrame(streamDependency, weight, exclusive).stream(this.requireStream(streamId)));
        }

        @Override
        public void onSettingsAckRead(ChannelHandlerContext ctx) {
            Http2FrameCodec.this.onHttp2Frame(ctx, Http2SettingsAckFrame.INSTANCE);
        }

        @Override
        public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
            Http2FrameCodec.this.onHttp2Frame(ctx, new DefaultHttp2PushPromiseFrame(headers, padding, promisedStreamId).pushStream(new DefaultHttp2FrameStream().setStreamAndProperty(Http2FrameCodec.this.streamKey, Http2FrameCodec.this.connection().stream(promisedStreamId))).stream(this.requireStream(streamId)));
        }

        private Http2FrameStream requireStream(int streamId) {
            Http2FrameStream stream = (Http2FrameStream)Http2FrameCodec.this.connection().stream(streamId).getProperty(Http2FrameCodec.this.streamKey);
            if (stream == null) {
                throw new IllegalStateException("Stream object required for identifier: " + streamId);
            }
            return stream;
        }
    }

    private final class ConnectionListener
    extends Http2ConnectionAdapter {
        private ConnectionListener() {
        }

        @Override
        public void onStreamAdded(Http2Stream stream) {
            DefaultHttp2FrameStream frameStream = (DefaultHttp2FrameStream)Http2FrameCodec.this.frameStreamToInitializeMap.remove(stream.id());
            if (frameStream != null) {
                frameStream.setStreamAndProperty(Http2FrameCodec.this.streamKey, stream);
            }
        }

        @Override
        public void onStreamActive(Http2Stream stream) {
            Http2FrameCodec.this.onStreamActive0(stream);
        }

        @Override
        public void onStreamClosed(Http2Stream stream) {
            this.onHttp2StreamStateChanged0(stream);
        }

        @Override
        public void onStreamHalfClosed(Http2Stream stream) {
            this.onHttp2StreamStateChanged0(stream);
        }

        private void onHttp2StreamStateChanged0(Http2Stream stream) {
            DefaultHttp2FrameStream stream2 = (DefaultHttp2FrameStream)stream.getProperty(Http2FrameCodec.this.streamKey);
            if (stream2 != null) {
                Http2FrameCodec.this.onHttp2StreamStateChanged(Http2FrameCodec.this.ctx, stream2);
            }
        }
    }
}

