/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelPipeline;
import io.netty5.handler.codec.http2.Http2MultiplexHandler;
import io.netty5.handler.codec.http2.Http2StreamChannel;
import io.netty5.util.AttributeKey;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.UnstableApi;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@UnstableApi
public final class Http2StreamChannelBootstrap {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2StreamChannelBootstrap.class);
    private static final Map.Entry<ChannelOption<?>, Object>[] EMPTY_OPTION_ARRAY = new Map.Entry[0];
    private static final Map.Entry<AttributeKey<?>, Object>[] EMPTY_ATTRIBUTE_ARRAY = new Map.Entry[0];
    private final Map<ChannelOption<?>, Object> options = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> attrs = new ConcurrentHashMap();
    private final Channel channel;
    private volatile ChannelHandler handler;
    private volatile ChannelHandlerContext multiplexCtx;

    public Http2StreamChannelBootstrap(Channel channel) {
        this.channel = Objects.requireNonNull(channel, "channel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Http2StreamChannelBootstrap option(ChannelOption<T> option, T value) {
        Objects.requireNonNull(option, "option");
        Map<ChannelOption<?>, Object> map = this.options;
        synchronized (map) {
            if (value == null) {
                this.options.remove(option);
            } else {
                this.options.put(option, value);
            }
        }
        return this;
    }

    public <T> Http2StreamChannelBootstrap attr(AttributeKey<T> key, T value) {
        Objects.requireNonNull(key, "key");
        if (value == null) {
            this.attrs.remove(key);
        } else {
            this.attrs.put(key, value);
        }
        return this;
    }

    public Http2StreamChannelBootstrap handler(ChannelHandler handler) {
        this.handler = Objects.requireNonNull(handler, "handler");
        return this;
    }

    public Future<Http2StreamChannel> open() {
        return this.open((Promise<Http2StreamChannel>)this.channel.executor().newPromise());
    }

    public Future<Http2StreamChannel> open(Promise<Http2StreamChannel> promise) {
        try {
            ChannelHandlerContext ctx = this.findCtx();
            EventExecutor executor = ctx.executor();
            if (executor.inEventLoop()) {
                this.open0(ctx, promise);
            } else {
                ChannelHandlerContext finalCtx = ctx;
                executor.execute(() -> {
                    if (this.channel.isActive()) {
                        this.open0(finalCtx, promise);
                    } else {
                        promise.setFailure((Throwable)new ClosedChannelException());
                    }
                });
            }
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
        return promise.asFuture();
    }

    private ChannelHandlerContext findCtx() throws ClosedChannelException {
        ChannelHandlerContext ctx = this.multiplexCtx;
        if (ctx != null && !ctx.isRemoved()) {
            return ctx;
        }
        ChannelPipeline pipeline = this.channel.pipeline();
        ctx = pipeline.context(Http2MultiplexHandler.class);
        if (ctx == null) {
            if (this.channel.isActive()) {
                throw new IllegalStateException(StringUtil.simpleClassName(Http2MultiplexHandler.class) + " must be in the ChannelPipeline of Channel " + this.channel);
            }
            throw new ClosedChannelException();
        }
        this.multiplexCtx = ctx;
        return ctx;
    }

    @Deprecated
    public void open0(ChannelHandlerContext ctx, Promise<Http2StreamChannel> promise) {
        Http2StreamChannel streamChannel;
        assert (ctx.executor().inEventLoop());
        if (!promise.setUncancellable()) {
            return;
        }
        try {
            streamChannel = ((Http2MultiplexHandler)ctx.handler()).newOutboundStream();
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            return;
        }
        try {
            this.init(streamChannel);
        }
        catch (Exception e) {
            streamChannel.close();
            promise.setFailure((Throwable)e);
            return;
        }
        Future future = streamChannel.register();
        future.addListener(future1 -> {
            if (future1.isSuccess()) {
                promise.setSuccess((Object)streamChannel);
            } else if (future1.isCancelled()) {
                promise.cancel();
            } else {
                streamChannel.close();
                promise.setFailure(future1.cause());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Channel channel) {
        Map.Entry<ChannelOption<?>, Object>[] optionArray;
        ChannelPipeline p = channel.pipeline();
        ChannelHandler handler = this.handler;
        if (handler != null) {
            p.addLast(new ChannelHandler[]{handler});
        }
        Map<ChannelOption<?>, Object> map = this.options;
        synchronized (map) {
            optionArray = this.options.entrySet().toArray(EMPTY_OPTION_ARRAY);
        }
        Http2StreamChannelBootstrap.setChannelOptions(channel, optionArray);
        Http2StreamChannelBootstrap.setAttributes(channel, this.attrs.entrySet().toArray(EMPTY_ATTRIBUTE_ARRAY));
    }

    private static void setChannelOptions(Channel channel, Map.Entry<ChannelOption<?>, Object>[] options) {
        for (Map.Entry<ChannelOption<?>, Object> e : options) {
            Http2StreamChannelBootstrap.setChannelOption(channel, e.getKey(), e.getValue());
        }
    }

    private static void setChannelOption(Channel channel, ChannelOption<?> option, Object value) {
        try {
            ChannelOption<?> opt = option;
            if (!channel.isOptionSupported(option)) {
                logger.warn("Unknown channel option '{}' for channel '{}'", option, (Object)channel);
            } else {
                channel.setOption(opt, value);
            }
        }
        catch (Throwable t) {
            logger.warn("Failed to set channel option '{}' with value '{}' for channel '{}'", new Object[]{option, value, channel, t});
        }
    }

    private static void setAttributes(Channel channel, Map.Entry<AttributeKey<?>, Object>[] options) {
        for (Map.Entry<AttributeKey<?>, Object> e : options) {
            AttributeKey<?> key = e.getKey();
            channel.attr(key).set(e.getValue());
        }
    }
}

