/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferUtil;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import io.netty5.handler.codec.http2.Http2ConnectionAdapter;
import io.netty5.handler.codec.http2.Http2ConnectionEncoder;
import io.netty5.handler.codec.http2.Http2Error;
import io.netty5.handler.codec.http2.Http2Exception;
import io.netty5.handler.codec.http2.Http2Settings;
import io.netty5.handler.codec.http2.Http2Stream;
import io.netty5.handler.codec.http2.headers.Http2Headers;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.SilentDispose;
import io.netty5.util.internal.UnstableApi;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;

@UnstableApi
public class StreamBufferingEncoder
extends DecoratingHttp2ConnectionEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(StreamBufferingEncoder.class);
    private final TreeMap<Integer, PendingStream> pendingStreams = new TreeMap();
    private int maxConcurrentStreams;
    private boolean closed;
    private GoAwayDetail goAwayDetail;

    public StreamBufferingEncoder(Http2ConnectionEncoder delegate) {
        this(delegate, 100);
    }

    public StreamBufferingEncoder(Http2ConnectionEncoder delegate, int initialMaxConcurrentStreams) {
        super(delegate);
        this.maxConcurrentStreams = initialMaxConcurrentStreams;
        this.connection().addListener(new Http2ConnectionAdapter(){

            @Override
            public void onGoAwayReceived(int lastStreamId, long errorCode, Buffer debugData) {
                StreamBufferingEncoder.this.goAwayDetail = new GoAwayDetail(lastStreamId, errorCode, BufferUtil.getBytes((Buffer)debugData, (int)debugData.readerOffset(), (int)debugData.readableBytes()));
                StreamBufferingEncoder.this.cancelGoAwayStreams(StreamBufferingEncoder.this.goAwayDetail);
            }

            @Override
            public void onStreamClosed(Http2Stream stream) {
                StreamBufferingEncoder.this.tryCreatePendingStreams();
            }
        });
    }

    public int numBufferedStreams() {
        return this.pendingStreams.size();
    }

    @Override
    public Future<Void> writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) {
        return this.writeHeaders(ctx, streamId, headers, 0, (short)16, false, padding, endStream);
    }

    @Override
    public Future<Void> writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
        if (this.closed) {
            return ctx.newFailedFuture((Throwable)new Http2ChannelClosedException());
        }
        if (this.isExistingStream(streamId) || this.canCreateStream()) {
            return super.writeHeaders(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endOfStream);
        }
        if (this.goAwayDetail != null) {
            return ctx.newFailedFuture((Throwable)new Http2GoAwayException(this.goAwayDetail));
        }
        PendingStream pendingStream = this.pendingStreams.get(streamId);
        if (pendingStream == null) {
            pendingStream = new PendingStream(ctx, streamId);
            this.pendingStreams.put(streamId, pendingStream);
        }
        Promise promise = ctx.newPromise();
        pendingStream.frames.add(new HeadersFrame(headers, streamDependency, weight, exclusive, padding, endOfStream, (Promise<Void>)promise));
        return promise.asFuture();
    }

    @Override
    public Future<Void> writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode) {
        if (this.isExistingStream(streamId)) {
            return super.writeRstStream(ctx, streamId, errorCode);
        }
        PendingStream stream = this.pendingStreams.remove(streamId);
        if (stream != null) {
            stream.close(null);
            return ctx.newSucceededFuture();
        }
        return ctx.newFailedFuture((Throwable)Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream does not exist %d", streamId));
    }

    @Override
    public Future<Void> writeData(ChannelHandlerContext ctx, int streamId, Buffer data, int padding, boolean endOfStream) {
        if (this.isExistingStream(streamId)) {
            return super.writeData(ctx, streamId, data, padding, endOfStream);
        }
        PendingStream pendingStream = this.pendingStreams.get(streamId);
        if (pendingStream != null) {
            Promise promise = ctx.newPromise();
            pendingStream.frames.add(new DataFrame(data, padding, endOfStream, (Promise<Void>)promise));
            return promise.asFuture();
        }
        SilentDispose.dispose((Object)data, (InternalLogger)logger);
        return ctx.newFailedFuture((Throwable)Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream does not exist %d", streamId));
    }

    @Override
    public void remoteSettings(Http2Settings settings) throws Http2Exception {
        super.remoteSettings(settings);
        this.maxConcurrentStreams = this.connection().local().maxActiveStreams();
        this.tryCreatePendingStreams();
    }

    @Override
    public void close() {
        try {
            if (!this.closed) {
                this.closed = true;
                Http2ChannelClosedException e = new Http2ChannelClosedException();
                while (!this.pendingStreams.isEmpty()) {
                    PendingStream stream = this.pendingStreams.pollFirstEntry().getValue();
                    stream.close(e);
                }
            }
        }
        finally {
            super.close();
        }
    }

    private void tryCreatePendingStreams() {
        while (!this.pendingStreams.isEmpty() && this.canCreateStream()) {
            Map.Entry<Integer, PendingStream> entry = this.pendingStreams.pollFirstEntry();
            PendingStream pendingStream = entry.getValue();
            try {
                pendingStream.sendFrames();
            }
            catch (Throwable t) {
                pendingStream.close(t);
            }
        }
    }

    private void cancelGoAwayStreams(GoAwayDetail goAwayDetail) {
        Iterator<PendingStream> iter = this.pendingStreams.values().iterator();
        Http2GoAwayException e = new Http2GoAwayException(goAwayDetail);
        while (iter.hasNext()) {
            PendingStream stream = iter.next();
            if (stream.streamId <= goAwayDetail.lastStreamId) continue;
            iter.remove();
            stream.close(e);
        }
    }

    private boolean canCreateStream() {
        return this.connection().local().numActiveStreams() < this.maxConcurrentStreams;
    }

    private boolean isExistingStream(int streamId) {
        return streamId <= this.connection().local().lastStreamCreated();
    }

    private final class DataFrame
    extends Frame {
        final Buffer data;
        final int padding;
        final boolean endOfStream;

        DataFrame(Buffer data, int padding, boolean endOfStream, Promise<Void> promise) {
            super(promise);
            this.data = data;
            this.padding = padding;
            this.endOfStream = endOfStream;
        }

        @Override
        void release(Throwable t) {
            super.release(t);
            SilentDispose.dispose((Object)this.data, (InternalLogger)logger);
        }

        @Override
        void send(ChannelHandlerContext ctx, int streamId) {
            StreamBufferingEncoder.this.writeData(ctx, streamId, this.data, this.padding, this.endOfStream).cascadeTo(this.promise);
        }
    }

    private final class HeadersFrame
    extends Frame {
        final Http2Headers headers;
        final int streamDependency;
        final short weight;
        final boolean exclusive;
        final int padding;
        final boolean endOfStream;

        HeadersFrame(Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream, Promise<Void> promise) {
            super(promise);
            this.headers = headers;
            this.streamDependency = streamDependency;
            this.weight = weight;
            this.exclusive = exclusive;
            this.padding = padding;
            this.endOfStream = endOfStream;
        }

        @Override
        void send(ChannelHandlerContext ctx, int streamId) {
            StreamBufferingEncoder.this.writeHeaders(ctx, streamId, this.headers, this.streamDependency, this.weight, this.exclusive, this.padding, this.endOfStream).cascadeTo(this.promise);
        }
    }

    private static abstract class Frame {
        final Promise<Void> promise;

        Frame(Promise<Void> promise) {
            this.promise = promise;
        }

        void release(Throwable t) {
            if (t == null) {
                this.promise.setSuccess(null);
            } else {
                this.promise.setFailure(t);
            }
        }

        abstract void send(ChannelHandlerContext var1, int var2);
    }

    private static final class PendingStream {
        final ChannelHandlerContext ctx;
        final int streamId;
        final Queue<Frame> frames = new ArrayDeque<Frame>(2);

        PendingStream(ChannelHandlerContext ctx, int streamId) {
            this.ctx = ctx;
            this.streamId = streamId;
        }

        void sendFrames() {
            for (Frame frame : this.frames) {
                frame.send(this.ctx, this.streamId);
            }
        }

        void close(Throwable t) {
            for (Frame frame : this.frames) {
                frame.release(t);
            }
        }
    }

    public static final class Http2GoAwayException
    extends Http2Exception {
        private static final long serialVersionUID = 1326785622777291198L;
        private final GoAwayDetail goAwayDetail;

        public Http2GoAwayException(int lastStreamId, long errorCode, byte[] debugData) {
            this(new GoAwayDetail(lastStreamId, errorCode, debugData));
        }

        Http2GoAwayException(GoAwayDetail goAwayDetail) {
            super(Http2Error.STREAM_CLOSED);
            this.goAwayDetail = goAwayDetail;
        }

        public int lastStreamId() {
            return this.goAwayDetail.lastStreamId;
        }

        public long errorCode() {
            return this.goAwayDetail.errorCode;
        }

        public byte[] debugData() {
            return (byte[])this.goAwayDetail.debugData.clone();
        }
    }

    private static final class GoAwayDetail {
        private final int lastStreamId;
        private final long errorCode;
        private final byte[] debugData;

        GoAwayDetail(int lastStreamId, long errorCode, byte[] debugData) {
            this.lastStreamId = lastStreamId;
            this.errorCode = errorCode;
            this.debugData = (byte[])debugData.clone();
        }
    }

    public static final class Http2ChannelClosedException
    extends Http2Exception {
        private static final long serialVersionUID = 4768543442094476971L;

        public Http2ChannelClosedException() {
            super(Http2Error.REFUSED_STREAM, "Connection closed");
        }
    }
}

