/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http2.headers;

import io.netty5.handler.codec.http.headers.DefaultHttpHeaders;
import io.netty5.handler.codec.http.headers.HeaderValidationException;
import io.netty5.handler.codec.http.headers.HttpCookiePair;
import io.netty5.handler.codec.http.headers.HttpHeaderValidationUtil;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.handler.codec.http.headers.HttpSetCookie;
import io.netty5.handler.codec.http.headers.MultiMap;
import io.netty5.handler.codec.http2.headers.Http2Headers;
import io.netty5.util.AsciiString;
import io.netty5.util.ByteProcessor;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class DefaultHttp2Headers
extends DefaultHttpHeaders
implements Http2Headers {
    private static final ByteProcessor HTTP2_NAME_VALIDATOR_PROCESSOR = value -> !AsciiString.isUpperCase((byte)value);

    public DefaultHttp2Headers(int arraySizeHint, boolean validateNames, boolean validateCookies, boolean validateValues) {
        super(arraySizeHint, validateNames, validateCookies, validateValues);
    }

    protected CharSequence validateKey(@Nullable CharSequence name, boolean forAdd) {
        if (name == null || name.length() == 0) {
            throw new HeaderValidationException("empty headers are not allowed");
        }
        if (this.validateNames) {
            if (Http2Headers.PseudoHeaderName.hasPseudoHeaderFormat(name)) {
                if (!Http2Headers.PseudoHeaderName.isPseudoHeader(name)) {
                    throw new HeaderValidationException("'" + name + "' is not a standard pseudo-header.");
                }
                if (forAdd && this.contains(name)) {
                    throw new HeaderValidationException("Duplicate HTTP/2 pseudo-header '" + name + "' encountered.");
                }
            } else {
                DefaultHttp2Headers.validateHeaderName((CharSequence)name);
                if (name instanceof AsciiString) {
                    int index = ((AsciiString)name).forEachByte(HTTP2_NAME_VALIDATOR_PROCESSOR);
                    if (index != -1) {
                        throw new HeaderValidationException("'" + name + "' is an invalid header name.");
                    }
                } else {
                    for (int i = 0; i < name.length(); ++i) {
                        if (!AsciiString.isUpperCase((char)name.charAt(i))) continue;
                        throw new HeaderValidationException("'" + name + "' is an invalid header name.");
                    }
                }
                if (HttpHeaderValidationUtil.isConnectionHeader((CharSequence)name, (boolean)true)) {
                    throw new HeaderValidationException("Illegal connection-specific header '" + name + "' encountered.");
                }
            }
        }
        return name;
    }

    protected CharSequence validateValue(CharSequence key, CharSequence value) {
        if (this.validateValues && HttpHeaderValidationUtil.isTeNotTrailers((CharSequence)key, (CharSequence)value)) {
            throw new HeaderValidationException("Illegal value specified for the 'TE' header (only 'trailers' is allowed).");
        }
        return super.validateValue(key, value);
    }

    @Override
    public Http2Headers copy() {
        DefaultHttp2Headers copy = new DefaultHttp2Headers(this.size(), this.validateNames, this.validateCookies, this.validateValues);
        copy.add(this);
        return copy;
    }

    @Override
    public Http2Headers add(CharSequence name, CharSequence value) {
        super.add(name, value);
        return this;
    }

    @Override
    public Http2Headers add(CharSequence name, Iterable<? extends CharSequence> values) {
        super.add(name, values);
        return this;
    }

    @Override
    public Http2Headers add(CharSequence name, Iterator<? extends CharSequence> valuesItr) {
        super.add(name, valuesItr);
        return this;
    }

    @Override
    public Http2Headers add(CharSequence name, CharSequence ... values) {
        super.add(name, values);
        return this;
    }

    @Override
    public Http2Headers add(HttpHeaders headers) {
        super.add(headers);
        return this;
    }

    @Override
    public Http2Headers set(CharSequence name, CharSequence value) {
        super.set(name, value);
        return this;
    }

    @Override
    public Http2Headers set(CharSequence name, Iterable<? extends CharSequence> values) {
        super.set(name, values);
        return this;
    }

    @Override
    public Http2Headers set(CharSequence name, Iterator<? extends CharSequence> valueItr) {
        super.set(name, valueItr);
        return this;
    }

    @Override
    public Http2Headers set(CharSequence name, CharSequence ... values) {
        super.set(name, values);
        return this;
    }

    @Override
    public Http2Headers set(HttpHeaders headers) {
        super.set(headers);
        return this;
    }

    @Override
    public Http2Headers replace(HttpHeaders headers) {
        super.replace(headers);
        return this;
    }

    @Override
    public Http2Headers clear() {
        super.clear();
        return this;
    }

    @Override
    public Http2Headers addCookie(HttpCookiePair cookie) {
        super.addCookie(cookie);
        return this;
    }

    @Override
    public Http2Headers addCookie(CharSequence name, CharSequence value) {
        super.addCookie(name, value);
        return this;
    }

    @Override
    public Http2Headers addSetCookie(HttpSetCookie cookie) {
        super.addSetCookie(cookie);
        return this;
    }

    @Override
    public Http2Headers addSetCookie(CharSequence name, CharSequence value) {
        super.addSetCookie(name, value);
        return this;
    }

    @Override
    public Http2Headers method(CharSequence value) {
        this.set((CharSequence)Http2Headers.PseudoHeaderName.METHOD.value(), value);
        return this;
    }

    @Override
    public Http2Headers scheme(CharSequence value) {
        this.set((CharSequence)Http2Headers.PseudoHeaderName.SCHEME.value(), value);
        return this;
    }

    @Override
    public Http2Headers authority(CharSequence value) {
        this.set((CharSequence)Http2Headers.PseudoHeaderName.AUTHORITY.value(), value);
        return this;
    }

    @Override
    public Http2Headers path(CharSequence value) {
        this.set((CharSequence)Http2Headers.PseudoHeaderName.PATH.value(), value);
        return this;
    }

    @Override
    public Http2Headers status(CharSequence value) {
        this.set((CharSequence)Http2Headers.PseudoHeaderName.STATUS.value(), value);
        return this;
    }

    @Override
    public CharSequence method() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.METHOD.value());
    }

    @Override
    public CharSequence scheme() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.SCHEME.value());
    }

    @Override
    public CharSequence authority() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.AUTHORITY.value());
    }

    @Override
    public CharSequence path() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.PATH.value());
    }

    @Override
    public CharSequence status() {
        return this.get((CharSequence)Http2Headers.PseudoHeaderName.STATUS.value());
    }

    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
        return DefaultHttp2Headers.concat(DefaultHttp2Headers.filter(super.iterator(), entry -> Http2Headers.PseudoHeaderName.isPseudoHeader((CharSequence)entry.getKey())), () -> DefaultHttp2Headers.filter(super.iterator(), entry -> !Http2Headers.PseudoHeaderName.isPseudoHeader((CharSequence)entry.getKey())));
    }

    private static <T> Iterator<T> concat(final Iterator<T> first, final Supplier<Iterator<T>> secondSupplier) {
        return new Iterator<T>(){
            private Iterator<T> current;
            private Supplier<Iterator<T>> supplierOfSecond;
            {
                this.current = first;
                this.supplierOfSecond = secondSupplier;
            }

            @Override
            public boolean hasNext() {
                while (!this.current.hasNext()) {
                    if (this.supplierOfSecond == null) {
                        return false;
                    }
                    this.current = this.supplierOfSecond.get();
                    this.supplierOfSecond = null;
                }
                return true;
            }

            @Override
            public void remove() {
                this.current.remove();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.current.next();
            }
        };
    }

    private static <T> Iterator<T> filter(Iterator<T> iterator, final Predicate<T> predicate) {
        if (!iterator.hasNext()) {
            return iterator;
        }
        final MultiMap.EntryIterator entryIterator = (MultiMap.EntryIterator)iterator;
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                while (entryIterator.hasNext() && !predicate.test(entryIterator.peekNext())) {
                    entryIterator.next();
                }
                return entryIterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return entryIterator.next();
            }

            @Override
            public void remove() {
                entryIterator.remove();
            }
        };
    }
}

