/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec;

import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.socket.DatagramPacket;
import io.netty5.handler.codec.MessageToMessageDecoder;
import java.util.Objects;

public class DatagramPacketDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private final MessageToMessageDecoder<Buffer> decoder;

    public DatagramPacketDecoder(MessageToMessageDecoder<Buffer> decoder) {
        this.decoder = Objects.requireNonNull(decoder, "decoder");
    }

    @Override
    public boolean acceptInboundMessage(Object msg) throws Exception {
        if (msg instanceof DatagramPacket) {
            return this.decoder.acceptInboundMessage(((DatagramPacket)msg).content());
        }
        return false;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
        this.decoder.decode(ctx, (Buffer)msg.content());
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.decoder.channelRegistered(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.decoder.channelUnregistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.decoder.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.decoder.channelInactive(ctx);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.decoder.channelReadComplete(ctx);
    }

    public void channelInboundEvent(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.decoder.channelInboundEvent(ctx, evt);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.decoder.channelWritabilityChanged(ctx);
    }

    public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.decoder.channelExceptionCaught(ctx, cause);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.decoder.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.decoder.handlerRemoved(ctx);
    }

    public boolean isSharable() {
        return this.decoder.isSharable();
    }
}

