/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec;

import io.netty5.buffer.BufferUtil;
import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.CorruptedFrameException;
import io.netty5.handler.codec.DecoderException;
import io.netty5.handler.codec.TooLongFrameException;
import io.netty5.util.internal.ObjectUtil;
import java.nio.ByteOrder;
import java.util.Objects;

public class LengthFieldBasedFrameDecoder
extends ByteToMessageDecoder {
    private final ByteOrder byteOrder;
    private final int maxFrameLength;
    private final int lengthFieldOffset;
    private final int lengthFieldLength;
    private final int lengthFieldEndOffset;
    private final int lengthAdjustment;
    private final int initialBytesToStrip;
    private final boolean failFast;
    private long tooLongFrameLength;
    private long bytesToDiscard;
    private int currentFrameLength = -1;

    public LengthFieldBasedFrameDecoder(int maxFrameLength, int lengthFieldOffset, int lengthFieldLength) {
        this(maxFrameLength, lengthFieldOffset, lengthFieldLength, 0, 0);
    }

    public LengthFieldBasedFrameDecoder(int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip) {
        this(maxFrameLength, lengthFieldOffset, lengthFieldLength, lengthAdjustment, initialBytesToStrip, true);
    }

    public LengthFieldBasedFrameDecoder(int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip, boolean failFast) {
        this(ByteOrder.BIG_ENDIAN, maxFrameLength, lengthFieldOffset, lengthFieldLength, lengthAdjustment, initialBytesToStrip, failFast);
    }

    public LengthFieldBasedFrameDecoder(ByteOrder byteOrder, int maxFrameLength, int lengthFieldOffset, int lengthFieldLength, int lengthAdjustment, int initialBytesToStrip, boolean failFast) {
        Objects.requireNonNull(byteOrder, "byteOrder");
        ObjectUtil.checkPositive((int)maxFrameLength, (String)"maxFrameLength");
        ObjectUtil.checkPositiveOrZero((int)lengthFieldOffset, (String)"lengthFieldOffset");
        ObjectUtil.checkPositiveOrZero((int)initialBytesToStrip, (String)"initialBytesToStrip");
        if (lengthFieldOffset > maxFrameLength - lengthFieldLength) {
            throw new IllegalArgumentException("maxFrameLength (" + maxFrameLength + ") must be equal to or greater than lengthFieldOffset (" + lengthFieldOffset + ") + lengthFieldLength (" + lengthFieldLength + ").");
        }
        this.byteOrder = byteOrder;
        this.maxFrameLength = maxFrameLength;
        this.lengthFieldOffset = lengthFieldOffset;
        this.lengthFieldLength = lengthFieldLength;
        this.lengthAdjustment = lengthAdjustment;
        this.lengthFieldEndOffset = lengthFieldOffset + lengthFieldLength;
        this.initialBytesToStrip = initialBytesToStrip;
        this.failFast = failFast;
    }

    @Override
    protected final void decode(ChannelHandlerContext ctx, Buffer in) throws Exception {
        Object decoded = this.decode0(ctx, in);
        if (decoded != null) {
            ctx.fireChannelRead(decoded);
        }
    }

    private void discardTooLongFrame(Buffer in) {
        int bytesToDiscardNow = (int)Math.min(this.bytesToDiscard, (long)in.readableBytes());
        in.skipReadableBytes(bytesToDiscardNow);
        this.bytesToDiscard -= (long)bytesToDiscardNow;
        this.failOnLengthExceededIfNecessary(false);
    }

    private static void failOnNegativeLengthField(Buffer buffer, long frameLength, int lengthFieldEndOffset) {
        buffer.skipReadableBytes(lengthFieldEndOffset);
        throw new CorruptedFrameException("negative pre-adjustment length field: " + frameLength);
    }

    private static void failOnFrameLengthLessThanLengthFieldEndOffset(Buffer buffer, long frameLength, int lengthFieldEndOffset) {
        buffer.skipReadableBytes(lengthFieldEndOffset);
        throw new CorruptedFrameException("Adjusted frame length (" + frameLength + ") is less than lengthFieldEndOffset: " + lengthFieldEndOffset);
    }

    private void handleFrameLengthExceeded(Buffer buffer, long frameLength) {
        long discard = frameLength - (long)buffer.readableBytes();
        this.tooLongFrameLength = frameLength;
        if (discard < 0L) {
            buffer.skipReadableBytes((int)frameLength);
        } else {
            this.bytesToDiscard = discard;
            buffer.skipReadableBytes(buffer.readableBytes());
        }
        this.failOnLengthExceededIfNecessary(true);
    }

    private static void failOnFrameLengthLessThanInitialBytesToStrip(Buffer buffer, int frameLength, int initialBytesToStrip) {
        buffer.skipReadableBytes(frameLength);
        throw new CorruptedFrameException("Adjusted frame length (" + frameLength + ") is less than initialBytesToStrip: " + initialBytesToStrip);
    }

    protected Object decode0(ChannelHandlerContext ctx, Buffer buffer) throws Exception {
        if (this.currentFrameLength == -1) {
            if (this.bytesToDiscard > 0L) {
                this.discardTooLongFrame(buffer);
            }
            if (buffer.readableBytes() < this.lengthFieldEndOffset) {
                return null;
            }
            int actualLengthFieldOffset = buffer.readerOffset() + this.lengthFieldOffset;
            long frameLength = this.getUnadjustedFrameLength(buffer, actualLengthFieldOffset, this.lengthFieldLength, this.byteOrder);
            if (frameLength < 0L) {
                LengthFieldBasedFrameDecoder.failOnNegativeLengthField(buffer, frameLength, this.lengthFieldEndOffset);
            }
            if ((frameLength += (long)(this.lengthAdjustment + this.lengthFieldEndOffset)) < (long)this.lengthFieldEndOffset) {
                LengthFieldBasedFrameDecoder.failOnFrameLengthLessThanLengthFieldEndOffset(buffer, frameLength, this.lengthFieldEndOffset);
            }
            if (frameLength > (long)this.maxFrameLength) {
                this.handleFrameLengthExceeded(buffer, frameLength);
                return null;
            }
            this.currentFrameLength = (int)frameLength;
        }
        if (buffer.readableBytes() < this.currentFrameLength) {
            return null;
        }
        if (this.initialBytesToStrip > this.currentFrameLength) {
            LengthFieldBasedFrameDecoder.failOnFrameLengthLessThanInitialBytesToStrip(buffer, this.currentFrameLength, this.initialBytesToStrip);
        }
        buffer.skipReadableBytes(this.initialBytesToStrip);
        Buffer frame = this.extractFrame(ctx, buffer, this.currentFrameLength - this.initialBytesToStrip);
        this.currentFrameLength = -1;
        return frame;
    }

    protected long getUnadjustedFrameLength(Buffer buffer, int offset, int length, ByteOrder byteOrder) {
        boolean reverseBytes = byteOrder == ByteOrder.LITTLE_ENDIAN;
        switch (length) {
            case 1: {
                return buffer.getUnsignedByte(offset);
            }
            case 2: {
                int shortLength = buffer.getUnsignedShort(offset);
                return reverseBytes ? (long)BufferUtil.reverseUnsignedShort((int)shortLength) : (long)shortLength;
            }
            case 3: {
                int mediumLength = buffer.getUnsignedMedium(offset);
                return reverseBytes ? (long)BufferUtil.reverseUnsignedMedium((int)mediumLength) : (long)mediumLength;
            }
            case 4: {
                long intLength = buffer.getUnsignedInt(offset);
                return reverseBytes ? BufferUtil.reverseUnsignedInt((long)intLength) : intLength;
            }
            case 8: {
                long longLength = buffer.getLong(offset);
                return reverseBytes ? Long.reverseBytes(longLength) : longLength;
            }
        }
        throw new DecoderException("unsupported lengthFieldLength: " + length + " (expected: 1, 2, 3, 4, or 8)");
    }

    private void failOnLengthExceededIfNecessary(boolean firstDetectionOfTooLongFrame) {
        if (this.bytesToDiscard == 0L) {
            long tooLongFrameLength = this.tooLongFrameLength;
            this.tooLongFrameLength = 0L;
            if (!this.failFast || firstDetectionOfTooLongFrame) {
                this.failOnLengthExceeded(tooLongFrameLength);
            }
        } else if (this.failFast && firstDetectionOfTooLongFrame) {
            this.failOnLengthExceeded(this.tooLongFrameLength);
        }
    }

    private void failOnLengthExceeded(long frameLength) {
        if (frameLength > 0L) {
            throw new TooLongFrameException("Adjusted frame length exceeds " + this.maxFrameLength + ": " + frameLength + " - discarded");
        }
        throw new TooLongFrameException("Adjusted frame length exceeds " + this.maxFrameLength + " - discarding");
    }

    protected Buffer extractFrame(ChannelHandlerContext ctx, Buffer buffer, int length) {
        return buffer.readSplit(length);
    }
}

