/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import com.aayushatharva.brotli4j.encoder.Encoder;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.handler.codec.compression.BrotliOptions;
import io.netty5.handler.codec.compression.CompressionException;
import io.netty5.handler.codec.compression.Compressor;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;

public final class BrotliCompressor
implements Compressor {
    private final Encoder.Parameters parameters;
    private State state = State.PROCESSING;

    private BrotliCompressor(Encoder.Parameters parameters) {
        this.parameters = Objects.requireNonNull(parameters, "Parameters");
    }

    public static Supplier<BrotliCompressor> newFactory(Encoder.Parameters parameters) {
        Objects.requireNonNull(parameters, "parameters");
        return () -> new BrotliCompressor(parameters);
    }

    public static Supplier<BrotliCompressor> newFactory(BrotliOptions brotliOptions) {
        return BrotliCompressor.newFactory(brotliOptions.parameters());
    }

    public static Supplier<BrotliCompressor> newFactory() {
        return BrotliCompressor.newFactory(BrotliOptions.DEFAULT);
    }

    @Override
    public Buffer compress(Buffer input, BufferAllocator allocator) throws CompressionException {
        switch (this.state) {
            case CLOSED: {
                throw new CompressionException("Compressor closed");
            }
            case FINISHED: {
                return allocator.allocate(0);
            }
            case PROCESSING: {
                if (input.readableBytes() == 0) {
                    return allocator.allocate(0);
                }
                byte[] uncompressed = new byte[input.readableBytes()];
                try {
                    input.readBytes(uncompressed, 0, uncompressed.length);
                    byte[] compressed = Encoder.compress((byte[])uncompressed, (Encoder.Parameters)this.parameters);
                    return allocator.copyOf(compressed);
                }
                catch (IOException e) {
                    this.state = State.FINISHED;
                    throw new CompressionException(e);
                }
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Buffer finish(BufferAllocator allocator) {
        switch (this.state) {
            case CLOSED: {
                throw new CompressionException("Compressor closed");
            }
            case FINISHED: 
            case PROCESSING: {
                this.state = State.FINISHED;
                return allocator.allocate(0);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isFinished() {
        return this.state != State.PROCESSING;
    }

    @Override
    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    @Override
    public void close() {
        this.state = State.CLOSED;
    }

    private static enum State {
        PROCESSING,
        FINISHED,
        CLOSED;

    }
}

