/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.handler.codec.compression.Bzip2BitReader;
import io.netty5.handler.codec.compression.Bzip2BlockDecompressor;
import io.netty5.handler.codec.compression.Bzip2HuffmanStageDecoder;
import io.netty5.handler.codec.compression.Bzip2MoveToFrontTable;
import io.netty5.handler.codec.compression.DecompressionException;
import io.netty5.handler.codec.compression.Decompressor;
import java.util.function.Supplier;

public final class Bzip2Decompressor
implements Decompressor {
    private State currentState = State.INIT;
    private final Bzip2BitReader reader = new Bzip2BitReader();
    private Bzip2BlockDecompressor blockDecompressor;
    private Bzip2HuffmanStageDecoder huffmanStageDecoder;
    private int blockSize;
    private int blockCRC;
    private int streamCRC;

    private Bzip2Decompressor() {
    }

    public static Supplier<Bzip2Decompressor> newFactory() {
        return Bzip2Decompressor::new;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer decompress(Buffer in, BufferAllocator allocator) throws DecompressionException {
        switch (this.currentState) {
            case CLOSED: {
                throw new DecompressionException("Decompressor closed");
            }
            case EOF: {
                return allocator.allocate(0);
            }
        }
        if (in.readableBytes() == 0) {
            return null;
        }
        Bzip2BitReader reader = this.reader;
        reader.setBuffer(in);
        block19: while (true) {
            switch (this.currentState) {
                case INIT: {
                    if (in.readableBytes() < 4) {
                        return null;
                    }
                    int magicNumber = in.readUnsignedMedium();
                    if (magicNumber != 4348520) {
                        this.currentState = State.EOF;
                        throw new DecompressionException("Unexpected stream identifier contents. Mismatched bzip2 protocol version?");
                    }
                    int blockSize = in.readByte() - 48;
                    if (blockSize < 1 || blockSize > 9) {
                        this.currentState = State.EOF;
                        throw new DecompressionException("block size is invalid");
                    }
                    this.blockSize = blockSize * 100000;
                    this.streamCRC = 0;
                    this.currentState = State.INIT_BLOCK;
                }
                case INIT_BLOCK: {
                    if (!reader.hasReadableBytes(10)) {
                        return null;
                    }
                    int magic1 = reader.readBits(24);
                    int magic2 = reader.readBits(24);
                    if (magic1 == 1536581 && magic2 == 3690640) {
                        int storedCombinedCRC = reader.readInt();
                        if (storedCombinedCRC != this.streamCRC) {
                            this.currentState = State.EOF;
                            throw new DecompressionException("stream CRC error");
                        }
                        this.currentState = State.EOF;
                        continue block19;
                    }
                    if (magic1 != 3227993 || magic2 != 2511705) {
                        this.currentState = State.EOF;
                        throw new DecompressionException("bad block header");
                    }
                    this.blockCRC = reader.readInt();
                    this.currentState = State.INIT_BLOCK_PARAMS;
                }
                case INIT_BLOCK_PARAMS: {
                    if (!reader.hasReadableBits(25)) {
                        return null;
                    }
                    boolean blockRandomised = reader.readBoolean();
                    int bwtStartPointer = reader.readBits(24);
                    this.blockDecompressor = new Bzip2BlockDecompressor(this.blockSize, this.blockCRC, blockRandomised, bwtStartPointer, reader);
                    this.currentState = State.RECEIVE_HUFFMAN_USED_MAP;
                }
                case RECEIVE_HUFFMAN_USED_MAP: {
                    if (!reader.hasReadableBits(16)) {
                        return null;
                    }
                    this.blockDecompressor.huffmanInUse16 = reader.readBits(16);
                    this.currentState = State.RECEIVE_HUFFMAN_USED_BITMAPS;
                }
                case RECEIVE_HUFFMAN_USED_BITMAPS: {
                    Bzip2BlockDecompressor blockDecompressor = this.blockDecompressor;
                    int inUse16 = blockDecompressor.huffmanInUse16;
                    int bitNumber = Integer.bitCount(inUse16);
                    byte[] huffmanSymbolMap = blockDecompressor.huffmanSymbolMap;
                    if (!reader.hasReadableBits(bitNumber * 16 + 3)) {
                        return null;
                    }
                    int huffmanSymbolCount = 0;
                    if (bitNumber > 0) {
                        for (int i = 0; i < 16; ++i) {
                            if ((inUse16 & 32768 >>> i) == 0) continue;
                            int j = 0;
                            int k = i << 4;
                            while (j < 16) {
                                if (reader.readBoolean()) {
                                    huffmanSymbolMap[huffmanSymbolCount++] = (byte)k;
                                }
                                ++j;
                                ++k;
                            }
                        }
                    }
                    blockDecompressor.huffmanEndOfBlockSymbol = huffmanSymbolCount + 1;
                    int totalTables = reader.readBits(3);
                    if (totalTables < 2 || totalTables > 6) {
                        throw new DecompressionException("incorrect huffman groups number");
                    }
                    int alphaSize = huffmanSymbolCount + 2;
                    if (alphaSize > 258) {
                        throw new DecompressionException("incorrect alphabet size");
                    }
                    this.huffmanStageDecoder = new Bzip2HuffmanStageDecoder(reader, totalTables, alphaSize);
                    this.currentState = State.RECEIVE_SELECTORS_NUMBER;
                }
                case RECEIVE_SELECTORS_NUMBER: {
                    if (!reader.hasReadableBits(15)) {
                        return null;
                    }
                    int totalSelectors = reader.readBits(15);
                    if (totalSelectors < 1 || totalSelectors > 18002) {
                        this.currentState = State.EOF;
                        throw new DecompressionException("incorrect selectors number");
                    }
                    this.huffmanStageDecoder.selectors = new byte[totalSelectors];
                    this.currentState = State.RECEIVE_SELECTORS;
                }
                case RECEIVE_SELECTORS: {
                    Bzip2HuffmanStageDecoder huffmanStageDecoder = this.huffmanStageDecoder;
                    byte[] selectors = huffmanStageDecoder.selectors;
                    int totalSelectors = selectors.length;
                    Bzip2MoveToFrontTable tableMtf = huffmanStageDecoder.tableMTF;
                    for (int currSelector = huffmanStageDecoder.currentSelector; currSelector < totalSelectors; ++currSelector) {
                        if (!reader.hasReadableBits(6)) {
                            huffmanStageDecoder.currentSelector = currSelector;
                            return null;
                        }
                        int index = 0;
                        while (reader.readBoolean()) {
                            ++index;
                        }
                        selectors[currSelector] = tableMtf.indexToFront(index);
                    }
                    this.currentState = State.RECEIVE_HUFFMAN_LENGTH;
                }
                case RECEIVE_HUFFMAN_LENGTH: {
                    int currGroup;
                    Bzip2HuffmanStageDecoder huffmanStageDecoder = this.huffmanStageDecoder;
                    int totalTables = huffmanStageDecoder.totalTables;
                    byte[][] codeLength = huffmanStageDecoder.tableCodeLengths;
                    int alphaSize = huffmanStageDecoder.alphabetSize;
                    int currLength = huffmanStageDecoder.currentLength;
                    int currAlpha = 0;
                    boolean modifyLength = huffmanStageDecoder.modifyLength;
                    boolean saveStateAndReturn = false;
                    block24: for (currGroup = huffmanStageDecoder.currentGroup; currGroup < totalTables; ++currGroup) {
                        if (!reader.hasReadableBits(5)) {
                            saveStateAndReturn = true;
                            break;
                        }
                        if (currLength < 0) {
                            currLength = reader.readBits(5);
                        }
                        for (currAlpha = huffmanStageDecoder.currentAlpha; currAlpha < alphaSize; ++currAlpha) {
                            if (!reader.isReadable()) {
                                saveStateAndReturn = true;
                                break block24;
                            }
                            while (modifyLength || reader.readBoolean()) {
                                if (!reader.isReadable()) {
                                    modifyLength = true;
                                    saveStateAndReturn = true;
                                    break block24;
                                }
                                currLength += reader.readBoolean() ? -1 : 1;
                                modifyLength = false;
                                if (reader.isReadable()) continue;
                                saveStateAndReturn = true;
                                break block24;
                            }
                            codeLength[currGroup][currAlpha] = (byte)currLength;
                        }
                        currLength = -1;
                        huffmanStageDecoder.currentAlpha = 0;
                        currAlpha = 0;
                        modifyLength = false;
                    }
                    if (saveStateAndReturn) {
                        huffmanStageDecoder.currentGroup = currGroup;
                        huffmanStageDecoder.currentLength = currLength;
                        huffmanStageDecoder.currentAlpha = currAlpha;
                        huffmanStageDecoder.modifyLength = modifyLength;
                        return null;
                    }
                    huffmanStageDecoder.createHuffmanDecodingTables();
                    this.currentState = State.DECODE_HUFFMAN_DATA;
                }
                case DECODE_HUFFMAN_DATA: {
                    Bzip2BlockDecompressor blockDecompressor = this.blockDecompressor;
                    int oldReaderIndex = in.readerOffset();
                    boolean decoded = blockDecompressor.decodeHuffmanData(this.huffmanStageDecoder);
                    if (!decoded) {
                        return null;
                    }
                    if (in.readerOffset() == oldReaderIndex && in.readableBytes() > 0) {
                        reader.refill();
                    }
                    int blockLength = blockDecompressor.blockLength();
                    try (Buffer uncompressed = allocator.allocate(blockLength);){
                        int uncByte;
                        while ((uncByte = blockDecompressor.read()) >= 0) {
                            uncompressed.writeByte((byte)uncByte);
                        }
                        this.currentState = State.INIT_BLOCK;
                        int currentBlockCRC = blockDecompressor.checkCRC();
                        this.streamCRC = (this.streamCRC << 1 | this.streamCRC >>> 31) ^ currentBlockCRC;
                        Buffer data = uncompressed;
                        uncompressed = null;
                        Buffer buffer = data;
                        return buffer;
                    }
                }
                case EOF: {
                    return allocator.allocate(0);
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isFinished() {
        return this.currentState == State.EOF || this.currentState == State.CLOSED;
    }

    @Override
    public void close() {
        this.currentState = State.CLOSED;
    }

    @Override
    public boolean isClosed() {
        return this.currentState == State.CLOSED;
    }

    private static enum State {
        INIT,
        INIT_BLOCK,
        INIT_BLOCK_PARAMS,
        RECEIVE_HUFFMAN_USED_MAP,
        RECEIVE_HUFFMAN_USED_BITMAPS,
        RECEIVE_SELECTORS_NUMBER,
        RECEIVE_SELECTORS,
        RECEIVE_HUFFMAN_LENGTH,
        DECODE_HUFFMAN_DATA,
        EOF,
        CLOSED;

    }
}

