/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.buffer.api.ComponentIterator;
import io.netty5.buffer.api.ReadableComponent;
import io.netty5.buffer.api.WritableComponent;
import io.netty5.handler.codec.compression.BufferChecksum;
import io.netty5.handler.codec.compression.CompressionUtil;
import io.netty5.handler.codec.compression.DecompressionException;
import io.netty5.handler.codec.compression.Decompressor;
import io.netty5.handler.codec.compression.Lz4XXHash32;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public final class Lz4Decompressor
implements Decompressor {
    private State currentState = State.INIT_BLOCK;
    private LZ4FastDecompressor decompressor;
    private BufferChecksum checksum;
    private int blockType;
    private int compressedLength;
    private int decompressedLength;
    private int currentChecksum;

    private Lz4Decompressor(LZ4Factory factory, Checksum checksum) {
        this.decompressor = factory.fastDecompressor();
        this.checksum = checksum == null ? null : (checksum instanceof Lz4XXHash32 ? (Lz4XXHash32)checksum : new BufferChecksum(checksum));
    }

    public static Supplier<Lz4Decompressor> newFactory() {
        return Lz4Decompressor.newFactory(false);
    }

    public static Supplier<Lz4Decompressor> newFactory(boolean validateChecksums) {
        return Lz4Decompressor.newFactory(LZ4Factory.fastestInstance(), validateChecksums);
    }

    public static Supplier<Lz4Decompressor> newFactory(LZ4Factory factory, boolean validateChecksums) {
        return Lz4Decompressor.newFactory(factory, validateChecksums ? new Lz4XXHash32(-1756908916) : null);
    }

    public static Supplier<Lz4Decompressor> newFactory(LZ4Factory factory, Checksum checksum) {
        Objects.requireNonNull(factory, "factory");
        return () -> new Lz4Decompressor(factory, checksum);
    }

    private void decompress(Buffer compressed, Buffer uncompressed) {
        assert (compressed.countReadableComponents() == 1);
        try (ComponentIterator writableIteration = uncompressed.forEachWritable();){
            WritableComponent writableComponent = (WritableComponent)writableIteration.first();
            try (ComponentIterator readableIteration = compressed.forEachReadable();){
                ReadableComponent readableComponent = (ReadableComponent)readableIteration.first();
                this.decompressor.decompress(readableComponent.readableBuffer(), writableComponent.writableBuffer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Buffer decompress(Buffer in, BufferAllocator allocator) throws DecompressionException {
        try {
            switch (this.currentState) {
                case CORRUPTED: 
                case FINISHED: {
                    return allocator.allocate(0);
                }
                case CLOSED: {
                    throw new DecompressionException("Decompressor closed");
                }
                case INIT_BLOCK: {
                    if (in.readableBytes() < 21) {
                        return null;
                    }
                    long magic = in.readLong();
                    if (magic != 5501767354678207339L) {
                        this.streamCorrupted("unexpected block identifier");
                    }
                    byte token = in.readByte();
                    int compressionLevel = (token & 0xF) + 10;
                    int blockType = token & 0xF0;
                    int compressedLength = Integer.reverseBytes(in.readInt());
                    if (compressedLength < 0 || compressedLength > 0x2000000) {
                        this.streamCorrupted(String.format("invalid compressedLength: %d (expected: 0-%d)", compressedLength, 0x2000000));
                    }
                    int decompressedLength = Integer.reverseBytes(in.readInt());
                    int maxDecompressedLength = 1 << compressionLevel;
                    if (decompressedLength < 0 || decompressedLength > maxDecompressedLength) {
                        this.streamCorrupted(String.format("invalid decompressedLength: %d (expected: 0-%d)", decompressedLength, maxDecompressedLength));
                    }
                    if (decompressedLength == 0 && compressedLength != 0 || decompressedLength != 0 && compressedLength == 0 || blockType == 16 && decompressedLength != compressedLength) {
                        this.streamCorrupted(String.format("stream corrupted: compressedLength(%d) and decompressedLength(%d) mismatch", compressedLength, decompressedLength));
                    }
                    int currentChecksum = Integer.reverseBytes(in.readInt());
                    if (decompressedLength == 0 && compressedLength == 0) {
                        if (currentChecksum != 0) {
                            this.streamCorrupted("stream corrupted: checksum error");
                        }
                        this.currentState = State.FINISHED;
                        this.decompressor = null;
                        this.checksum = null;
                        return null;
                    }
                    this.blockType = blockType;
                    this.compressedLength = compressedLength;
                    this.decompressedLength = decompressedLength;
                    this.currentChecksum = currentChecksum;
                    this.currentState = State.DECOMPRESS_DATA;
                }
                case DECOMPRESS_DATA: {
                    Buffer buffer;
                    int blockType = this.blockType;
                    int compressedLength = this.compressedLength;
                    int decompressedLength = this.decompressedLength;
                    int currentChecksum = this.currentChecksum;
                    if (in.readableBytes() < compressedLength) {
                        return null;
                    }
                    BufferChecksum checksum = this.checksum;
                    Buffer uncompressed = null;
                    try {
                        switch (blockType) {
                            case 16: {
                                assert (compressedLength == decompressedLength);
                                uncompressed = in.readSplit(decompressedLength);
                                break;
                            }
                            case 32: {
                                uncompressed = allocator.allocate(decompressedLength);
                                assert (uncompressed.countWritableComponents() == 1);
                                if (in.countReadableComponents() > 1) {
                                    try (Buffer inBuffer = allocator.allocate(compressedLength);){
                                        in.copyInto(in.readerOffset(), inBuffer, inBuffer.writerOffset(), compressedLength);
                                        inBuffer.skipWritableBytes(compressedLength);
                                        this.decompress(inBuffer, uncompressed);
                                    }
                                } else {
                                    this.decompress(in, uncompressed);
                                }
                                in.skipReadableBytes(compressedLength);
                                uncompressed.skipWritableBytes(decompressedLength);
                                break;
                            }
                            default: {
                                this.streamCorrupted(String.format("unexpected blockType: %d (expected: %d or %d)", blockType, 16, 32));
                            }
                        }
                        if (checksum != null) {
                            CompressionUtil.checkChecksum(checksum, uncompressed, currentChecksum);
                        }
                        Buffer buffer2 = uncompressed;
                        uncompressed = null;
                        this.currentState = State.INIT_BLOCK;
                        buffer = buffer2;
                        if (uncompressed == null) return buffer;
                    }
                    catch (LZ4Exception e) {
                        try {
                            this.streamCorrupted((Exception)((Object)e));
                            if (uncompressed == null) throw new IllegalStateException();
                        }
                        catch (Throwable throwable) {
                            if (uncompressed == null) throw throwable;
                            uncompressed.close();
                            throw throwable;
                        }
                        uncompressed.close();
                        throw new IllegalStateException();
                    }
                    uncompressed.close();
                    return buffer;
                }
            }
            throw new IllegalStateException();
        }
        catch (Exception e) {
            this.currentState = State.CORRUPTED;
            throw e;
        }
    }

    @Override
    public boolean isFinished() {
        switch (this.currentState) {
            case CORRUPTED: 
            case FINISHED: 
            case CLOSED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.currentState == State.CLOSED;
    }

    @Override
    public void close() {
        this.currentState = State.CLOSED;
    }

    private void streamCorrupted(String message) {
        this.currentState = State.CORRUPTED;
        throw new DecompressionException(message);
    }

    private void streamCorrupted(Exception cause) {
        this.currentState = State.CORRUPTED;
        throw new DecompressionException(cause);
    }

    private static enum State {
        INIT_BLOCK,
        DECOMPRESS_DATA,
        FINISHED,
        CORRUPTED,
        CLOSED;

    }
}

