/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;

public final class Zstd {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Zstd.class);
    private static final Throwable cause;

    public static boolean isAvailable() {
        return cause == null;
    }

    public static void ensureAvailability() throws Throwable {
        if (cause != null) {
            throw cause;
        }
    }

    public static Throwable cause() {
        return cause;
    }

    private Zstd() {
    }

    static {
        Throwable t = null;
        try {
            Class.forName("com.github.luben.zstd.Zstd", false, PlatformDependent.getClassLoader(Zstd.class));
        }
        catch (ClassNotFoundException e) {
            t = e;
            logger.debug("zstd-jni not in the classpath; Zstd support will be unavailable.");
        }
        catch (Throwable e) {
            t = e;
            logger.debug("Failed to load zstd-jni; Zstd support will be unavailable.", t);
        }
        cause = t;
    }
}

