/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.LineBasedFrameDecoder;
import io.netty5.handler.codec.TooLongFrameException;
import io.netty5.util.internal.ObjectUtil;
import java.util.Objects;

public class DelimiterBasedFrameDecoder
extends ByteToMessageDecoder {
    private final Buffer[] delimiters;
    private final int maxFrameLength;
    private final boolean stripDelimiter;
    private final boolean failFast;
    private boolean discardingTooLongFrame;
    private int tooLongFrameLength;
    private final LineBasedFrameDecoder lineBasedDecoder;

    public DelimiterBasedFrameDecoder(int maxFrameLength, Buffer ... delimiters) {
        this(maxFrameLength, true, delimiters);
    }

    public DelimiterBasedFrameDecoder(int maxFrameLength, boolean stripDelimiter, Buffer ... delimiters) {
        this(maxFrameLength, stripDelimiter, true, delimiters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelimiterBasedFrameDecoder(int maxFrameLength, boolean stripDelimiter, boolean failFast, Buffer ... delimiters) {
        DelimiterBasedFrameDecoder.validateMaxFrameLength(maxFrameLength);
        Objects.requireNonNull(delimiters, "delimiters");
        if (delimiters.length == 0) {
            throw new IllegalArgumentException("empty delimiters");
        }
        if (DelimiterBasedFrameDecoder.isLineBased(delimiters) && !this.isSubclass()) {
            this.lineBasedDecoder = new LineBasedFrameDecoder(maxFrameLength, stripDelimiter, failFast);
            this.delimiters = null;
            DelimiterBasedFrameDecoder.closeDelimiters(delimiters);
        } else {
            this.delimiters = new Buffer[delimiters.length];
            RuntimeException re = null;
            try {
                for (int i = 0; i < delimiters.length; ++i) {
                    Buffer d = delimiters[i];
                    DelimiterBasedFrameDecoder.validateDelimiter(d);
                    this.delimiters[i] = d.copy(true);
                }
            }
            catch (IllegalArgumentException e) {
                re = e;
                try {
                    DelimiterBasedFrameDecoder.closeDelimiters(this.delimiters);
                }
                catch (RuntimeException e1) {
                    re.addSuppressed(e1);
                }
            }
            finally {
                try {
                    DelimiterBasedFrameDecoder.closeDelimiters(delimiters);
                }
                catch (RuntimeException e) {
                    if (re == null) {
                        re = e;
                    }
                    re.addSuppressed(e);
                }
            }
            if (re != null) {
                throw re;
            }
            this.lineBasedDecoder = null;
        }
        this.maxFrameLength = maxFrameLength;
        this.stripDelimiter = stripDelimiter;
        this.failFast = failFast;
    }

    private static boolean isLineBased(Buffer[] delimiters) {
        if (delimiters.length != 2) {
            return false;
        }
        Buffer a = delimiters[0];
        Buffer b = delimiters[1];
        if (a.capacity() < b.capacity()) {
            a = delimiters[1];
            b = delimiters[0];
        }
        return a.capacity() == 2 && b.capacity() == 1 && a.getByte(0) == 13 && a.getByte(1) == 10 && b.getByte(0) == 10;
    }

    private boolean isSubclass() {
        return ((Object)((Object)this)).getClass() != DelimiterBasedFrameDecoder.class;
    }

    @Override
    protected final void decode(ChannelHandlerContext ctx, Buffer in) throws Exception {
        Object decoded = this.decode0(ctx, in);
        if (decoded != null) {
            ctx.fireChannelRead(decoded);
        }
    }

    protected Object decode0(ChannelHandlerContext ctx, Buffer buffer) {
        if (this.lineBasedDecoder != null) {
            return this.lineBasedDecoder.decode0(ctx, buffer);
        }
        int minFrameLength = Integer.MAX_VALUE;
        Buffer minDelim = null;
        for (Buffer delim : this.delimiters) {
            int frameLength = DelimiterBasedFrameDecoder.indexOf(buffer, delim);
            if (frameLength < 0 || frameLength >= minFrameLength) continue;
            minFrameLength = frameLength;
            minDelim = delim;
        }
        if (minDelim != null) {
            Buffer frame;
            int minDelimLength = minDelim.capacity();
            if (this.discardingTooLongFrame) {
                this.discardingTooLongFrame = false;
                buffer.skipReadableBytes(minFrameLength + minDelimLength);
                int tooLongFrameLength = this.tooLongFrameLength;
                this.tooLongFrameLength = 0;
                if (!this.failFast) {
                    this.fail(tooLongFrameLength);
                }
                return null;
            }
            if (minFrameLength > this.maxFrameLength) {
                buffer.skipReadableBytes(minFrameLength + minDelimLength);
                this.fail(minFrameLength);
                return null;
            }
            if (this.stripDelimiter) {
                frame = buffer.readSplit(minFrameLength);
                buffer.skipReadableBytes(minDelimLength);
            } else {
                frame = buffer.readSplit(minFrameLength + minDelimLength);
            }
            return frame;
        }
        if (!this.discardingTooLongFrame) {
            if (buffer.readableBytes() > this.maxFrameLength) {
                this.tooLongFrameLength = buffer.readableBytes();
                buffer.skipReadableBytes(buffer.readableBytes());
                this.discardingTooLongFrame = true;
                if (this.failFast) {
                    this.fail(this.tooLongFrameLength);
                }
            }
        } else {
            this.tooLongFrameLength += buffer.readableBytes();
            buffer.skipReadableBytes(buffer.readableBytes());
        }
        return null;
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        if (this.delimiters != null) {
            DelimiterBasedFrameDecoder.closeDelimiters(this.delimiters);
        }
        super.handlerRemoved0(ctx);
    }

    private static void closeDelimiters(Buffer[] delimiters) {
        RuntimeException re = null;
        for (Buffer delimiter : delimiters) {
            try {
                if (delimiter == null) continue;
                delimiter.close();
            }
            catch (RuntimeException e) {
                if (re == null) {
                    re = e;
                    continue;
                }
                re.addSuppressed(e);
            }
        }
        if (re != null) {
            throw re;
        }
    }

    private void fail(long frameLength) {
        if (frameLength > 0L) {
            throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + ": " + frameLength + " - discarded");
        }
        throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + " - discarding");
    }

    private static int indexOf(Buffer haystack, Buffer needle) {
        for (int i = haystack.readerOffset(); i < haystack.writerOffset(); ++i) {
            int needleIndex;
            int haystackIndex = i;
            for (needleIndex = 0; needleIndex < needle.capacity() && haystack.getByte(haystackIndex) == needle.getByte(needleIndex); ++needleIndex) {
                if (++haystackIndex != haystack.writerOffset() || needleIndex == needle.capacity() - 1) continue;
                return -1;
            }
            if (needleIndex != needle.capacity()) continue;
            return i - haystack.readerOffset();
        }
        return -1;
    }

    private static void validateDelimiter(Buffer delimiter) {
        Objects.requireNonNull(delimiter, "delimiter");
        if (delimiter.readableBytes() == 0) {
            throw new IllegalArgumentException("empty delimiter");
        }
    }

    private static void validateMaxFrameLength(int maxFrameLength) {
        ObjectUtil.checkPositive((int)maxFrameLength, (String)"maxFrameLength");
    }
}

