/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.codec.TooLongFrameException;
import io.netty5.util.ByteProcessor;

public class LineBasedFrameDecoder
extends ByteToMessageDecoder {
    private final int maxLength;
    private final boolean failFast;
    private final boolean stripDelimiter;
    private boolean discarding;
    private int discardedBytes;
    private int offset;

    public LineBasedFrameDecoder(int maxLength) {
        this(maxLength, true, false);
    }

    public LineBasedFrameDecoder(int maxLength, boolean stripDelimiter, boolean failFast) {
        this.maxLength = maxLength;
        this.failFast = failFast;
        this.stripDelimiter = stripDelimiter;
    }

    @Override
    protected final void decode(ChannelHandlerContext ctx, Buffer in) throws Exception {
        Object decoded = this.decode0(ctx, in);
        if (decoded != null) {
            ctx.fireChannelRead(decoded);
        }
    }

    protected Object decode0(ChannelHandlerContext ctx, Buffer buffer) {
        int eol = this.findEndOfLine(buffer);
        if (!this.discarding) {
            if (eol >= 0) {
                Buffer frame;
                int delimLength;
                int length = eol - buffer.readerOffset();
                int n = delimLength = buffer.getByte(eol) == 13 ? 2 : 1;
                if (length > this.maxLength) {
                    buffer.readerOffset(eol + delimLength);
                    this.fail(ctx, length);
                    return null;
                }
                if (this.stripDelimiter) {
                    frame = buffer.readSplit(length);
                    buffer.skipReadableBytes(delimLength);
                } else {
                    frame = buffer.readSplit(length + delimLength);
                }
                return frame;
            }
            int length = buffer.readableBytes();
            if (length > this.maxLength) {
                this.discardedBytes = length;
                buffer.readerOffset(buffer.writerOffset());
                this.discarding = true;
                this.offset = 0;
                if (this.failFast) {
                    this.fail(ctx, "over " + this.discardedBytes);
                }
            }
            return null;
        }
        if (eol >= 0) {
            int length = this.discardedBytes + eol - buffer.readerOffset();
            int delimLength = buffer.getByte(eol) == 13 ? 2 : 1;
            buffer.readerOffset(eol + delimLength);
            this.discardedBytes = 0;
            this.discarding = false;
            if (!this.failFast) {
                this.fail(ctx, length);
            }
        } else {
            this.discardedBytes += buffer.readableBytes();
            buffer.readerOffset(buffer.writerOffset());
            this.offset = 0;
        }
        return null;
    }

    private void fail(ChannelHandlerContext ctx, int length) {
        this.fail(ctx, String.valueOf(length));
    }

    private void fail(ChannelHandlerContext ctx, String length) {
        ctx.fireChannelExceptionCaught((Throwable)new TooLongFrameException("frame length (" + length + ") exceeds the allowed maximum (" + this.maxLength + ")"));
    }

    private int findEndOfLine(Buffer buffer) {
        int totalLength = buffer.readableBytes();
        int index = buffer.readerOffset() + this.offset;
        int i = buffer.openCursor(index, totalLength - this.offset).process(ByteProcessor.FIND_LF);
        int n = i = i == -1 ? -1 : index + i;
        if (i >= 0) {
            this.offset = 0;
            if (i > 0 && buffer.getByte(i - 1) == 13) {
                --i;
            }
        } else {
            this.offset = totalLength;
        }
        return i;
    }
}

