/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerAdapter;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.util.concurrent.Future;
import io.netty5.util.internal.SilentDispose;
import io.netty5.util.internal.TypeParameterMatcher;
import java.util.Objects;

public abstract class MessageToByteEncoder<I>
extends ChannelHandlerAdapter {
    private final TypeParameterMatcher matcher;

    protected MessageToByteEncoder() {
        this.matcher = TypeParameterMatcher.find((Object)((Object)this), MessageToByteEncoder.class, (String)"I");
    }

    protected MessageToByteEncoder(Class<? extends I> outboundMessageType) {
        this.matcher = TypeParameterMatcher.get(Objects.requireNonNull(outboundMessageType, "outboundMessageType"));
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        Future future;
        try (Buffer buf = null;){
            if (this.acceptOutboundMessage(msg)) {
                Object cast = msg;
                buf = this.allocateBuffer(ctx, cast);
                try (AutoCloseable ignore = SilentDispose.autoClosing((Object)cast);){
                    this.encode(ctx, cast, buf);
                }
                if (buf.readableBytes() > 0) {
                    Future f = ctx.write((Object)buf);
                    buf = null;
                    Future future2 = f;
                    return future2;
                }
                future = ctx.write((Object)ctx.bufferAllocator().allocate(0));
                return future;
            }
            Future cast = ctx.write(msg);
            return cast;
        }
    }

    protected abstract Buffer allocateBuffer(ChannelHandlerContext var1, I var2) throws Exception;

    protected abstract void encode(ChannelHandlerContext var1, I var2, Buffer var3) throws Exception;
}

