/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.base64;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToMessageEncoder;
import io.netty5.handler.codec.base64.Base64;
import io.netty5.handler.codec.base64.Base64Dialect;
import java.util.List;
import java.util.Objects;

public class Base64Encoder
extends MessageToMessageEncoder<Buffer> {
    private final boolean breakLines;
    private final Base64Dialect dialect;

    public Base64Encoder() {
        this(true);
    }

    public Base64Encoder(boolean breakLines) {
        this(breakLines, Base64Dialect.STANDARD);
    }

    public Base64Encoder(boolean breakLines, Base64Dialect dialect) {
        Objects.requireNonNull(dialect, "dialect");
        this.breakLines = breakLines;
        this.dialect = dialect;
    }

    public boolean isSharable() {
        return true;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Buffer msg, List<Object> out) throws Exception {
        out.add(Base64.encode(msg, msg.readerOffset(), msg.readableBytes(), this.breakLines, this.dialect));
    }
}

