/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import com.aayushatharva.brotli4j.decoder.DecoderJNI;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.handler.codec.compression.Brotli;
import io.netty5.handler.codec.compression.DecompressionException;
import io.netty5.handler.codec.compression.Decompressor;
import io.netty5.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;

public final class BrotliDecompressor
implements Decompressor {
    private State state = State.PROCESSING;
    private final DecoderJNI.Wrapper decoder;

    public static Supplier<BrotliDecompressor> newFactory() {
        return BrotliDecompressor.newFactory(8192);
    }

    public static Supplier<BrotliDecompressor> newFactory(int inputBufferSize) {
        ObjectUtil.checkPositive((int)inputBufferSize, (String)"inputBufferSize");
        return () -> {
            try {
                return new BrotliDecompressor(inputBufferSize);
            }
            catch (IOException e) {
                throw new DecompressionException(e);
            }
        };
    }

    private BrotliDecompressor(int inputBufferSize) throws IOException {
        this.decoder = new DecoderJNI.Wrapper(inputBufferSize);
    }

    private Buffer pull(BufferAllocator alloc) {
        ByteBuffer nativeBuffer = this.decoder.pull();
        return alloc.copyOf(nativeBuffer);
    }

    private static int readBytes(Buffer in, ByteBuffer dest) {
        int limit = Math.min(in.readableBytes(), dest.remaining());
        ByteBuffer slice = dest.slice();
        slice.limit(limit);
        in.readBytes(slice);
        dest.position(dest.position() + limit);
        return limit;
    }

    @Override
    public Buffer decompress(Buffer input, BufferAllocator allocator) throws DecompressionException {
        switch (this.state) {
            case CLOSED: {
                throw new DecompressionException("Decompressor closed");
            }
            case FINISHED: {
                return allocator.allocate(0);
            }
            case PROCESSING: {
                block11: while (true) {
                    switch (this.decoder.getStatus()) {
                        case DONE: {
                            this.state = State.FINISHED;
                            return null;
                        }
                        case OK: {
                            this.decoder.push(0);
                            continue block11;
                        }
                        case NEEDS_MORE_INPUT: {
                            if (this.decoder.hasOutput()) {
                                return this.pull(allocator);
                            }
                            if (input.readableBytes() == 0) {
                                return null;
                            }
                            ByteBuffer decoderInputBuffer = this.decoder.getInputBuffer();
                            decoderInputBuffer.clear();
                            int readBytes = BrotliDecompressor.readBytes(input, decoderInputBuffer);
                            this.decoder.push(readBytes);
                            continue block11;
                        }
                        case NEEDS_MORE_OUTPUT: {
                            return this.pull(allocator);
                        }
                    }
                    break;
                }
                this.state = State.FINISHED;
                throw new DecompressionException("Brotli stream corrupted");
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isFinished() {
        return this.state != State.PROCESSING;
    }

    @Override
    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    @Override
    public void close() {
        if (this.state != State.FINISHED) {
            this.state = State.FINISHED;
            this.decoder.destroy();
        }
    }

    static {
        try {
            Brotli.ensureAvailability();
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
    }

    private static enum State {
        PROCESSING,
        FINISHED,
        CLOSED;

    }
}

