/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.ChunkEncoder;
import com.ning.compress.lzf.LZFChunk;
import com.ning.compress.lzf.LZFEncoder;
import com.ning.compress.lzf.util.ChunkEncoderFactory;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.handler.codec.compression.CompressionException;
import io.netty5.handler.codec.compression.Compressor;
import java.util.function.Supplier;

public final class LzfCompressor
implements Compressor {
    private static final int MIN_BLOCK_TO_COMPRESS = 16;
    private final int compressThreshold;
    private final ChunkEncoder encoder;
    private final BufferRecycler recycler;
    private State state = State.PROCESSING;

    private LzfCompressor(boolean safeInstance, int totalLength, int compressThreshold) {
        this.compressThreshold = compressThreshold;
        this.encoder = safeInstance ? ChunkEncoderFactory.safeNonAllocatingInstance((int)totalLength) : ChunkEncoderFactory.optimalNonAllocatingInstance((int)totalLength);
        this.recycler = BufferRecycler.instance();
    }

    public static Supplier<LzfCompressor> newFactory() {
        return LzfCompressor.newFactory(false);
    }

    public static Supplier<LzfCompressor> newFactory(boolean safeInstance) {
        return LzfCompressor.newFactory(safeInstance, 65535);
    }

    public static Supplier<LzfCompressor> newFactory(boolean safeInstance, int totalLength) {
        return LzfCompressor.newFactory(safeInstance, totalLength, 16);
    }

    public static Supplier<LzfCompressor> newFactory(int totalLength) {
        return LzfCompressor.newFactory(false, totalLength);
    }

    public static Supplier<LzfCompressor> newFactory(boolean safeInstance, int totalLength, int compressThreshold) {
        if (totalLength < 16 || totalLength > 65535) {
            throw new IllegalArgumentException("totalLength: " + totalLength + " (expected: 16-65535)");
        }
        if (compressThreshold < 16) {
            throw new IllegalArgumentException("compressThreshold:" + compressThreshold + " expected >=16");
        }
        return () -> new LzfCompressor(safeInstance, totalLength, compressThreshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer compress(Buffer in, BufferAllocator allocator) throws CompressionException {
        switch (this.state) {
            case CLOSED: {
                throw new CompressionException("Compressor closed");
            }
            case FINISHED: {
                return allocator.allocate(0);
            }
            case PROCESSING: {
                if (in.readableBytes() == 0) {
                    return allocator.allocate(0);
                }
                try (ComponentIterator readableIteration = in.forEachComponent();){
                    Buffer buffer;
                    int inputPtr;
                    byte[] input;
                    BufferComponent readableComponent = (BufferComponent)readableIteration.firstReadable();
                    int length = readableComponent.readableBytes();
                    if (readableComponent.hasReadableArray()) {
                        input = readableComponent.readableArray();
                        inputPtr = readableComponent.readableArrayOffset();
                    } else {
                        input = this.recycler.allocInputBuffer(length);
                        readableComponent.readableBuffer().get(input, 0, length);
                        inputPtr = 0;
                    }
                    byte[] output = this.recycler.allocOutputBuffer(LZFEncoder.estimateMaxWorkspaceSize((int)length) + 1);
                    try {
                        int outputLength = length >= this.compressThreshold ? this.encodeCompress(input, inputPtr, length, output, 0) : LzfCompressor.encodeNonCompress(input, inputPtr, length, output, 0);
                        readableComponent.skipReadableBytes(length);
                        if (!readableComponent.hasReadableArray()) {
                            this.recycler.releaseInputBuffer(input);
                        }
                        buffer = allocator.allocate(outputLength).writeBytes(output, 0, outputLength);
                    }
                    catch (Throwable throwable) {
                        this.recycler.releaseOutputBuffer(output);
                        throw throwable;
                    }
                    this.recycler.releaseOutputBuffer(output);
                    return buffer;
                }
            }
        }
        throw new IllegalStateException();
    }

    private int encodeCompress(byte[] input, int inputPtr, int length, byte[] output, int outputPtr) {
        return LZFEncoder.appendEncoded((ChunkEncoder)this.encoder, (byte[])input, (int)inputPtr, (int)length, (byte[])output, (int)outputPtr) - outputPtr;
    }

    private static int lzfEncodeNonCompress(byte[] input, int inputPtr, int length, byte[] output, int outputPtr) {
        int left = length;
        int chunkLen = Math.min(65535, left);
        outputPtr = LZFChunk.appendNonCompressed((byte[])input, (int)inputPtr, (int)chunkLen, (byte[])output, (int)outputPtr);
        if ((left -= chunkLen) < 1) {
            return outputPtr;
        }
        inputPtr += chunkLen;
        do {
            chunkLen = Math.min(left, 65535);
            outputPtr = LZFChunk.appendNonCompressed((byte[])input, (int)inputPtr, (int)chunkLen, (byte[])output, (int)outputPtr);
            inputPtr += chunkLen;
        } while ((left -= chunkLen) > 0);
        return outputPtr;
    }

    private static int encodeNonCompress(byte[] input, int inputPtr, int length, byte[] output, int outputPtr) {
        return LzfCompressor.lzfEncodeNonCompress(input, inputPtr, length, output, outputPtr) - outputPtr;
    }

    @Override
    public Buffer finish(BufferAllocator allocator) {
        switch (this.state) {
            case CLOSED: {
                throw new CompressionException("Compressor closed");
            }
            case FINISHED: 
            case PROCESSING: {
                this.state = State.FINISHED;
                return allocator.allocate(0);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isFinished() {
        return this.state != State.PROCESSING;
    }

    @Override
    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    @Override
    public void close() {
        if (this.state != State.CLOSED) {
            this.state = State.CLOSED;
            this.encoder.close();
        }
    }

    private static enum State {
        PROCESSING,
        FINISHED,
        CLOSED;

    }
}

