/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.compression;

import io.netty5.channel.ChannelHandler;
import io.netty5.handler.codec.compression.CompressionHandler;
import io.netty5.handler.codec.compression.DecompressionHandler;
import io.netty5.handler.codec.compression.ZlibCompressor;
import io.netty5.handler.codec.compression.ZlibDecompressor;
import io.netty5.handler.codec.compression.ZlibWrapper;

public final class ZlibCodecFactory {
    private static final boolean supportsWindowSizeAndMemLevel = true;

    public static boolean isSupportingWindowSizeAndMemLevel() {
        return true;
    }

    public static ChannelHandler newZlibEncoder(int compressionLevel) {
        return new CompressionHandler(ZlibCompressor.newFactory(compressionLevel));
    }

    public static ChannelHandler newZlibEncoder(ZlibWrapper wrapper) {
        return new CompressionHandler(ZlibCompressor.newFactory(wrapper));
    }

    public static ChannelHandler newZlibEncoder(ZlibWrapper wrapper, int compressionLevel) {
        return new CompressionHandler(ZlibCompressor.newFactory(wrapper, compressionLevel));
    }

    public static ChannelHandler newZlibEncoder(ZlibWrapper wrapper, int compressionLevel, int windowBits, int memLevel) {
        return new CompressionHandler(ZlibCompressor.newFactory(wrapper, compressionLevel));
    }

    public static ChannelHandler newZlibEncoder(byte[] dictionary) {
        return new CompressionHandler(ZlibCompressor.newFactory(dictionary));
    }

    public static ChannelHandler newZlibEncoder(int compressionLevel, byte[] dictionary) {
        return new CompressionHandler(ZlibCompressor.newFactory(compressionLevel, dictionary));
    }

    public static ChannelHandler newZlibEncoder(int compressionLevel, int windowBits, int memLevel, byte[] dictionary) {
        return new CompressionHandler(ZlibCompressor.newFactory(compressionLevel, dictionary));
    }

    public static ChannelHandler newZlibDecoder() {
        return new DecompressionHandler(ZlibDecompressor.newFactory(true));
    }

    public static ChannelHandler newZlibDecoder(ZlibWrapper wrapper) {
        return new DecompressionHandler(ZlibDecompressor.newFactory(wrapper, true));
    }

    public static ChannelHandler newZlibDecoder(byte[] dictionary) {
        return new DecompressionHandler(ZlibDecompressor.newFactory(dictionary));
    }

    private ZlibCodecFactory() {
    }
}

