/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.string;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToMessageEncoder;
import io.netty5.handler.codec.string.LineSeparator;
import io.netty5.util.CharsetUtil;
import io.netty5.util.internal.SilentDispose;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;

public class LineEncoder
extends MessageToMessageEncoder<CharSequence> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(LineEncoder.class);
    private final Charset charset;
    private final byte[] lineSeparator;

    public LineEncoder() {
        this(LineSeparator.DEFAULT, StandardCharsets.UTF_8);
    }

    public LineEncoder(LineSeparator lineSeparator) {
        this(lineSeparator, StandardCharsets.UTF_8);
    }

    public LineEncoder(Charset charset) {
        this(LineSeparator.DEFAULT, charset);
    }

    public LineEncoder(LineSeparator lineSeparator, Charset charset) {
        this.charset = Objects.requireNonNull(charset, "charset");
        this.lineSeparator = Objects.requireNonNull(lineSeparator, "lineSeparator").value().getBytes(charset);
    }

    public boolean isSharable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, CharSequence msg, List<Object> out) throws Exception {
        CharsetEncoder encoder = CharsetUtil.encoder((Charset)this.charset);
        int size = (int)((float)msg.length() * encoder.maxBytesPerChar() + (float)this.lineSeparator.length);
        Buffer buf = ctx.bufferAllocator().allocate(size);
        assert (buf.countWritableComponents() == 1);
        boolean release = true;
        CharBuffer chars = CharBuffer.wrap(msg);
        try (ComponentIterator iterator = buf.forEachComponent();){
            BufferComponent component = Objects.requireNonNull((BufferComponent)iterator.firstWritable(), "writable component");
            ByteBuffer byteBuffer = component.writableBuffer();
            int start = byteBuffer.position();
            CoderResult result = encoder.encode(chars, byteBuffer, true);
            if (!result.isUnderflow()) {
                result.throwException();
            }
            encoder.flush(byteBuffer);
            if (!result.isUnderflow()) {
                result.throwException();
            }
            component.skipWritableBytes(byteBuffer.position() - start);
            release = false;
        }
        finally {
            if (release) {
                SilentDispose.dispose((Object)buf, (InternalLogger)logger);
            }
        }
        buf.writeBytes(this.lineSeparator);
        out.add(buf);
    }
}

