/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util;

import io.netty5.util.ReferenceCounted;
import io.netty5.util.ResourceLeakDetector;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;

public final class ReferenceCountUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountUtil.class);

    public static boolean isReferenceCounted(Object obj) {
        return obj instanceof io.netty.util.ReferenceCounted || obj instanceof ReferenceCounted;
    }

    public static <T> T retain(T msg) {
        if (msg instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)msg).retain();
        }
        if (msg instanceof io.netty.util.ReferenceCounted) {
            return (T)((io.netty.util.ReferenceCounted)msg).retain();
        }
        return msg;
    }

    public static <T> T retain(T msg, int increment) {
        ObjectUtil.checkPositive(increment, "increment");
        if (msg instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)msg).retain(increment);
        }
        if (msg instanceof io.netty.util.ReferenceCounted) {
            return (T)((io.netty.util.ReferenceCounted)msg).retain(increment);
        }
        return msg;
    }

    public static <T> T touch(T msg) {
        if (msg instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)msg).touch();
        }
        if (msg instanceof io.netty.util.ReferenceCounted) {
            return (T)((io.netty.util.ReferenceCounted)msg).touch();
        }
        return msg;
    }

    public static <T> T touch(T msg, Object hint) {
        if (msg instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)msg).touch(hint);
        }
        if (msg instanceof io.netty.util.ReferenceCounted) {
            return (T)((io.netty.util.ReferenceCounted)msg).touch(hint);
        }
        return msg;
    }

    public static boolean release(Object msg) {
        if (msg instanceof ReferenceCounted) {
            return ((ReferenceCounted)msg).release();
        }
        if (msg instanceof io.netty.util.ReferenceCounted) {
            return ((io.netty.util.ReferenceCounted)msg).release();
        }
        return false;
    }

    public static boolean release(Object msg, int decrement) {
        ObjectUtil.checkPositive(decrement, "decrement");
        if (msg instanceof ReferenceCounted) {
            return ((ReferenceCounted)msg).release(decrement);
        }
        if (msg instanceof io.netty.util.ReferenceCounted) {
            return ((io.netty.util.ReferenceCounted)msg).release(decrement);
        }
        return false;
    }

    public static void safeRelease(Object msg) {
        try {
            ReferenceCountUtil.release(msg);
        }
        catch (Throwable t) {
            logger.warn("Failed to release a message: {}", msg, (Object)t);
        }
    }

    public static void safeRelease(Object msg, int decrement) {
        block2: {
            try {
                ObjectUtil.checkPositive(decrement, "decrement");
                ReferenceCountUtil.release(msg, decrement);
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to release a message: {} (decrement: {})", msg, decrement, t);
            }
        }
    }

    public static int refCnt(Object msg) {
        return msg instanceof ReferenceCounted ? ((ReferenceCounted)msg).refCnt() : (msg instanceof io.netty.util.ReferenceCounted ? ((io.netty.util.ReferenceCounted)msg).refCnt() : -1);
    }

    private ReferenceCountUtil() {
    }

    static {
        ResourceLeakDetector.addExclusions(ReferenceCountUtil.class, "touch");
    }
}

