/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.DefaultPromise;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.concurrent.RunnableFuture;
import io.netty5.util.concurrent.RunnableFutureAdapter;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;

public abstract class AbstractEventExecutor
implements EventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractEventExecutor.class);
    static final long DEFAULT_SHUTDOWN_QUIET_PERIOD = 2L;
    static final long DEFAULT_SHUTDOWN_TIMEOUT = 15L;
    private final Future<?> successfulVoidFuture = DefaultPromise.newSuccessfulPromise(this, null).asFuture();

    @Override
    public <V> Future<V> newSucceededFuture(V result) {
        if (result == null) {
            Future<?> f = this.successfulVoidFuture;
            return f;
        }
        return EventExecutor.super.newSucceededFuture(result);
    }

    @Override
    public final Future<Void> submit(Runnable task) {
        RunnableFuture<Void> futureTask = this.newTaskFor(task, null);
        this.execute(futureTask);
        return futureTask;
    }

    @Override
    public final <T> Future<T> submit(Runnable task, T result) {
        RunnableFuture<T> futureTask = this.newTaskFor(task, result);
        this.execute(futureTask);
        return futureTask;
    }

    @Override
    public final <T> Future<T> submit(Callable<T> task) {
        RunnableFuture<T> futureTask = this.newTaskFor(task);
        this.execute(futureTask);
        return futureTask;
    }

    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return AbstractEventExecutor.newRunnableFuture(this.newPromise(), runnable, value);
    }

    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return AbstractEventExecutor.newRunnableFuture(this.newPromise(), callable);
    }

    static void safeExecute(Runnable task) {
        try {
            task.run();
        }
        catch (Throwable t) {
            logger.warn("A task raised an exception. Task: {}", (Object)task, (Object)t);
        }
    }

    private static <V> RunnableFuture<V> newRunnableFuture(Promise<V> promise, Callable<V> task) {
        return new RunnableFutureAdapter<V>(promise, Objects.requireNonNull(task, "task"));
    }

    private static <V> RunnableFuture<V> newRunnableFuture(Promise<V> promise, Runnable task, V value) {
        return new RunnableFutureAdapter<V>(promise, Executors.callable(Objects.requireNonNull(task, "task"), value));
    }
}

