/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.AbstractEventExecutor;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureContextListener;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.concurrent.RunnableFuture;
import io.netty5.util.concurrent.RunnableScheduledFuture;
import io.netty5.util.concurrent.RunnableScheduledFutureAdapter;
import io.netty5.util.internal.DefaultPriorityQueue;
import io.netty5.util.internal.PriorityQueue;
import io.netty5.util.internal.PriorityQueueNode;
import java.util.Comparator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractScheduledEventExecutor
extends AbstractEventExecutor {
    static final long START_TIME = System.nanoTime();
    private static final Comparator<RunnableScheduledFutureNode<?>> SCHEDULED_FUTURE_TASK_COMPARATOR = Comparable::compareTo;
    private static final RunnableScheduledFutureNode<?>[] EMPTY_RUNNABLE_SCHEDULED_FUTURE_NODES = new RunnableScheduledFutureNode[0];
    private PriorityQueue<RunnableScheduledFutureNode<?>> scheduledTaskQueue;

    protected AbstractScheduledEventExecutor() {
    }

    public static long nanoTime() {
        return System.nanoTime() - START_TIME;
    }

    static long deadlineNanos(long delay) {
        long deadlineNanos = AbstractScheduledEventExecutor.nanoTime() + delay;
        return deadlineNanos < 0L ? Long.MAX_VALUE : deadlineNanos;
    }

    PriorityQueue<RunnableScheduledFutureNode<?>> scheduledTaskQueue() {
        if (this.scheduledTaskQueue == null) {
            this.scheduledTaskQueue = new DefaultPriorityQueue(SCHEDULED_FUTURE_TASK_COMPARATOR, 11);
        }
        return this.scheduledTaskQueue;
    }

    private static boolean isNullOrEmpty(Queue<RunnableScheduledFutureNode<?>> queue) {
        return queue == null || queue.isEmpty();
    }

    protected final void cancelScheduledTasks() {
        RunnableScheduledFutureNode<?>[] scheduledTasks;
        assert (this.inEventLoop());
        PriorityQueue<RunnableScheduledFutureNode<?>> scheduledTaskQueue = this.scheduledTaskQueue;
        if (AbstractScheduledEventExecutor.isNullOrEmpty(scheduledTaskQueue)) {
            return;
        }
        for (RunnableScheduledFutureNode<?> task : scheduledTasks = scheduledTaskQueue.toArray(EMPTY_RUNNABLE_SCHEDULED_FUTURE_NODES)) {
            task.cancel();
        }
        scheduledTaskQueue.clearIgnoringIndexes();
    }

    protected final RunnableScheduledFuture<?> pollScheduledTask() {
        return this.pollScheduledTask(AbstractScheduledEventExecutor.nanoTime());
    }

    protected final RunnableScheduledFuture<?> pollScheduledTask(long nanoTime) {
        RunnableScheduledFutureNode scheduledTask;
        assert (this.inEventLoop());
        PriorityQueue<RunnableScheduledFutureNode<?>> scheduledTaskQueue = this.scheduledTaskQueue;
        RunnableScheduledFutureNode runnableScheduledFutureNode = scheduledTask = scheduledTaskQueue == null ? null : (RunnableScheduledFutureNode)scheduledTaskQueue.peek();
        if (scheduledTask == null) {
            return null;
        }
        if (scheduledTask.deadlineNanos() <= nanoTime) {
            scheduledTaskQueue.remove();
            return scheduledTask;
        }
        return null;
    }

    protected final long nextScheduledTaskNano() {
        RunnableScheduledFutureNode scheduledTask;
        PriorityQueue<RunnableScheduledFutureNode<?>> scheduledTaskQueue = this.scheduledTaskQueue;
        RunnableScheduledFutureNode runnableScheduledFutureNode = scheduledTask = scheduledTaskQueue == null ? null : (RunnableScheduledFutureNode)scheduledTaskQueue.peek();
        if (scheduledTask == null) {
            return -1L;
        }
        return Math.max(0L, scheduledTask.deadlineNanos() - AbstractScheduledEventExecutor.nanoTime());
    }

    final RunnableScheduledFuture<?> peekScheduledTask() {
        PriorityQueue<RunnableScheduledFutureNode<?>> scheduledTaskQueue = this.scheduledTaskQueue;
        if (scheduledTaskQueue == null) {
            return null;
        }
        return (RunnableScheduledFuture)scheduledTaskQueue.peek();
    }

    protected final boolean hasScheduledTasks() {
        assert (this.inEventLoop());
        PriorityQueue<RunnableScheduledFutureNode<?>> scheduledTaskQueue = this.scheduledTaskQueue;
        RunnableScheduledFutureNode scheduledTask = scheduledTaskQueue == null ? null : (RunnableScheduledFutureNode)scheduledTaskQueue.peek();
        return scheduledTask != null && scheduledTask.deadlineNanos() <= AbstractScheduledEventExecutor.nanoTime();
    }

    @Override
    public Future<Void> schedule(Runnable command, long delay, TimeUnit unit) {
        Objects.requireNonNull(command, "command");
        Objects.requireNonNull(unit, "unit");
        if (delay < 0L) {
            delay = 0L;
        }
        RunnableScheduledFuture<Object> task = this.newScheduledTaskFor(Executors.callable(command, null), AbstractScheduledEventExecutor.deadlineNanos(unit.toNanos(delay)), 0L);
        return this.schedule(task);
    }

    @Override
    public <V> Future<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        Objects.requireNonNull(callable, "callable");
        Objects.requireNonNull(unit, "unit");
        if (delay < 0L) {
            delay = 0L;
        }
        RunnableScheduledFuture<V> task = this.newScheduledTaskFor(callable, AbstractScheduledEventExecutor.deadlineNanos(unit.toNanos(delay)), 0L);
        return this.schedule(task);
    }

    @Override
    public Future<Void> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        Objects.requireNonNull(command, "command");
        Objects.requireNonNull(unit, "unit");
        if (initialDelay < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", initialDelay));
        }
        if (period <= 0L) {
            throw new IllegalArgumentException(String.format("period: %d (expected: > 0)", period));
        }
        RunnableScheduledFuture<Object> task = this.newScheduledTaskFor(Executors.callable(command, null), AbstractScheduledEventExecutor.deadlineNanos(unit.toNanos(initialDelay)), unit.toNanos(period));
        return this.schedule(task);
    }

    @Override
    public Future<Void> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        Objects.requireNonNull(command, "command");
        Objects.requireNonNull(unit, "unit");
        if (initialDelay < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", initialDelay));
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: > 0)", delay));
        }
        RunnableScheduledFuture<Object> task = this.newScheduledTaskFor(Executors.callable(command, null), AbstractScheduledEventExecutor.deadlineNanos(unit.toNanos(initialDelay)), -unit.toNanos(delay));
        return this.schedule(task);
    }

    protected final <V> Future<V> schedule(RunnableScheduledFuture<V> task) {
        if (this.inEventLoop()) {
            this.add0(task);
        } else {
            this.execute(() -> this.add0(task));
        }
        return task;
    }

    private <V> void add0(RunnableScheduledFuture<V> task) {
        DefaultRunnableScheduledFutureNode<V> node = task instanceof RunnableScheduledFutureNode ? (DefaultRunnableScheduledFutureNode<V>)task : new DefaultRunnableScheduledFutureNode<V>(task);
        this.scheduledTaskQueue().add(node);
    }

    final void removeScheduled(RunnableScheduledFutureNode<?> task) {
        if (this.inEventLoop()) {
            this.scheduledTaskQueue().removeTyped(task);
        } else {
            this.execute(() -> this.removeScheduled(task));
        }
    }

    protected static <V> RunnableScheduledFuture<V> newRunnableScheduledFuture(AbstractScheduledEventExecutor executor, Promise<V> promise, Callable<V> task, long deadlineNanos, long periodNanos) {
        return new RunnableScheduledFutureAdapter<V>(executor, promise, task, deadlineNanos, periodNanos);
    }

    protected <V> RunnableScheduledFuture<V> newScheduledTaskFor(Callable<V> callable, long deadlineNanos, long period) {
        return AbstractScheduledEventExecutor.newRunnableScheduledFuture(this, this.newPromise(), callable, deadlineNanos, period);
    }

    private static final class DefaultRunnableScheduledFutureNode<V>
    implements RunnableScheduledFutureNode<V> {
        private final RunnableScheduledFuture<V> future;
        private int queueIndex = -1;

        DefaultRunnableScheduledFutureNode(RunnableScheduledFuture<V> future) {
            this.future = future;
        }

        @Override
        public EventExecutor executor() {
            return this.future.executor();
        }

        @Override
        public long deadlineNanos() {
            return this.future.deadlineNanos();
        }

        @Override
        public long delayNanos() {
            return this.future.delayNanos();
        }

        @Override
        public long delayNanos(long currentTimeNanos) {
            return this.future.delayNanos(currentTimeNanos);
        }

        @Override
        public RunnableScheduledFuture<V> addListener(FutureListener<? super V> listener) {
            this.future.addListener((FutureListener)listener);
            return this;
        }

        @Override
        public <C> RunnableScheduledFuture<V> addListener(C context, FutureContextListener<? super C, ? super V> listener) {
            this.future.addListener((Object)context, (FutureContextListener)listener);
            return this;
        }

        @Override
        public boolean isPeriodic() {
            return this.future.isPeriodic();
        }

        @Override
        public int priorityQueueIndex(DefaultPriorityQueue<?> queue) {
            return this.queueIndex;
        }

        @Override
        public void priorityQueueIndex(DefaultPriorityQueue<?> queue, int i) {
            this.queueIndex = i;
        }

        @Override
        public void run() {
            this.future.run();
        }

        @Override
        public boolean cancel() {
            return this.future.cancel();
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.future.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.future.get(timeout, unit);
        }

        @Override
        public int compareTo(RunnableScheduledFuture<?> o) {
            return this.future.compareTo(o);
        }

        @Override
        public RunnableFuture<V> sync() throws InterruptedException {
            this.future.sync();
            return this;
        }

        @Override
        public RunnableFuture<V> syncUninterruptibly() {
            this.future.syncUninterruptibly();
            return this;
        }

        @Override
        public RunnableFuture<V> await() throws InterruptedException {
            this.future.await();
            return this;
        }

        @Override
        public RunnableFuture<V> awaitUninterruptibly() {
            this.future.awaitUninterruptibly();
            return this;
        }

        @Override
        public boolean isSuccess() {
            return this.future.isSuccess();
        }

        @Override
        public boolean isFailed() {
            return this.future.isFailed();
        }

        @Override
        public boolean isCancellable() {
            return this.future.isCancellable();
        }

        @Override
        public Throwable cause() {
            return this.future.cause();
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.future.await(timeout, unit);
        }

        @Override
        public boolean await(long timeoutMillis) throws InterruptedException {
            return this.future.await(timeoutMillis);
        }

        @Override
        public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
            return this.future.awaitUninterruptibly(timeout, unit);
        }

        @Override
        public boolean awaitUninterruptibly(long timeoutMillis) {
            return this.future.awaitUninterruptibly(timeoutMillis);
        }

        @Override
        public V getNow() {
            return this.future.getNow();
        }
    }

    static interface RunnableScheduledFutureNode<V>
    extends PriorityQueueNode,
    RunnableScheduledFuture<V> {
    }
}

