/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureCompletionStage;
import io.netty5.util.concurrent.Promise;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

final class DefaultFutureCompletionStage<V>
implements FutureCompletionStage<V>,
java.util.concurrent.Future<V> {
    private static final Executor SAME_AS_FUTURE = task -> {
        throw new UnsupportedOperationException("Marker executor. Should never be called!");
    };
    private final Future<V> future;

    DefaultFutureCompletionStage(Future<V> future) {
        this.future = future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel();
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    @Override
    public Future<V> future() {
        return this.future;
    }

    @Override
    public <U> FutureCompletionStage<U> thenApply(Function<? super V, ? extends U> fn) {
        return this.thenApplyAsync((Function)fn, SAME_AS_FUTURE);
    }

    @Override
    public <U> FutureCompletionStage<U> thenApplyAsync(Function<? super V, ? extends U> fn) {
        return this.thenApplyAsync((Function)fn, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public FutureCompletionStage<Void> thenAccept(Consumer<? super V> action) {
        return this.thenAcceptAsync((Consumer)action, SAME_AS_FUTURE);
    }

    @Override
    public FutureCompletionStage<Void> thenAcceptAsync(Consumer<? super V> action) {
        return this.thenAcceptAsync((Consumer)action, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public FutureCompletionStage<Void> thenRun(Runnable action) {
        return this.thenRunAsync(action, SAME_AS_FUTURE);
    }

    @Override
    public FutureCompletionStage<Void> thenRunAsync(Runnable action) {
        return this.thenRunAsync(action, ForkJoinPool.commonPool());
    }

    @Override
    public <U, V1> FutureCompletionStage<V1> thenCombine(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return this.thenCombineAsync((CompletionStage)other, (BiFunction)fn, SAME_AS_FUTURE);
    }

    @Override
    public <U, V1> FutureCompletionStage<V1> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return this.thenCombineAsync((CompletionStage)other, (BiFunction)fn, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public <U> FutureCompletionStage<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return this.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, SAME_AS_FUTURE);
    }

    @Override
    public <U> FutureCompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return this.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public FutureCompletionStage<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.runAfterBothAsync((CompletionStage)other, action, SAME_AS_FUTURE);
    }

    @Override
    public FutureCompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterBothAsync((CompletionStage)other, action, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public <U> FutureCompletionStage<U> applyToEither(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return this.applyToEitherAsync((CompletionStage)other, (Function)fn, SAME_AS_FUTURE);
    }

    @Override
    public <U> FutureCompletionStage<U> applyToEitherAsync(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return this.applyToEitherAsync((CompletionStage)other, (Function)fn, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public FutureCompletionStage<Void> acceptEither(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return this.acceptEitherAsync((CompletionStage)other, (Consumer)action, SAME_AS_FUTURE);
    }

    @Override
    public FutureCompletionStage<Void> acceptEitherAsync(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return this.acceptEitherAsync((CompletionStage)other, (Consumer)action, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public FutureCompletionStage<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.runAfterEitherAsync((CompletionStage)other, action, SAME_AS_FUTURE);
    }

    @Override
    public FutureCompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterEitherAsync((CompletionStage)other, action, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public <U> FutureCompletionStage<U> thenCompose(Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.thenComposeAsync((Function)fn, SAME_AS_FUTURE);
    }

    @Override
    public <U> FutureCompletionStage<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.thenComposeAsync((Function)fn, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public FutureCompletionStage<V> whenComplete(BiConsumer<? super V, ? super Throwable> action) {
        return this.whenCompleteAsync((BiConsumer)action, SAME_AS_FUTURE);
    }

    @Override
    public FutureCompletionStage<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action) {
        return this.whenCompleteAsync((BiConsumer)action, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public <U> FutureCompletionStage<U> handle(BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.handleAsync((BiFunction)fn, SAME_AS_FUTURE);
    }

    @Override
    public <U> FutureCompletionStage<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.handleAsync((BiFunction)fn, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public <U> FutureCompletionStage<U> thenApplyAsync(Function<? super V, ? extends U> fn, Executor executor) {
        Objects.requireNonNull(fn, "fn");
        Objects.requireNonNull(executor, "executor");
        Promise promise = this.executor().newPromise();
        this.future.addListener(future -> {
            Throwable cause = future.cause();
            if (cause == null) {
                Object value = future.getNow();
                if (DefaultFutureCompletionStage.executeDirectly(executor)) {
                    DefaultFutureCompletionStage.thenApplyAsync0(promise, value, fn);
                } else {
                    DefaultFutureCompletionStage.safeExecute(executor, () -> DefaultFutureCompletionStage.thenApplyAsync0(promise, value, fn), promise);
                }
            } else {
                promise.setFailure(cause);
            }
        });
        return promise.asFuture().asStage();
    }

    private static <U, V> void thenApplyAsync0(Promise<U> promise, V value, Function<? super V, ? extends U> fn) {
        U result;
        try {
            result = fn.apply(value);
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
            return;
        }
        promise.setSuccess(result);
    }

    @Override
    public FutureCompletionStage<Void> thenAcceptAsync(Consumer<? super V> action, Executor executor) {
        Objects.requireNonNull(action, "action");
        Objects.requireNonNull(executor, "executor");
        Promise promise = this.executor().newPromise();
        this.future.addListener(future -> {
            Throwable cause = future.cause();
            if (cause == null) {
                Object value = future.getNow();
                if (DefaultFutureCompletionStage.executeDirectly(executor)) {
                    DefaultFutureCompletionStage.thenAcceptAsync0(promise, value, action);
                } else {
                    DefaultFutureCompletionStage.safeExecute(executor, () -> DefaultFutureCompletionStage.thenAcceptAsync0(promise, value, action), promise);
                }
            } else {
                promise.setFailure(cause);
            }
        });
        return promise.asFuture().asStage();
    }

    private static <U, V> void thenAcceptAsync0(Promise<U> promise, V value, Consumer<? super V> action) {
        try {
            action.accept(value);
            promise.setSuccess(null);
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
    }

    @Override
    public FutureCompletionStage<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.thenAcceptAsync((T ignore) -> action.run(), executor);
    }

    @Override
    public <U, V1> FutureCompletionStage<V1> thenCombineAsync(CompletionStage<? extends U> other, final BiFunction<? super V, ? super U, ? extends V1> fn, Executor executor) {
        Objects.requireNonNull(other, "other");
        Objects.requireNonNull(fn, "fn");
        Objects.requireNonNull(executor, "executor");
        final Promise promise = this.executor().newPromise();
        final AtomicReference<Marker> reference = new AtomicReference<Marker>(Marker.EMPTY);
        abstract class CombineBiConsumer<T1, T2, T>
        implements BiConsumer<T, Throwable> {
            final /* synthetic */ AtomicReference val$reference;
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ BiFunction val$fn;

            CombineBiConsumer() {
                this.val$reference = atomicReference;
                this.val$promise = promise;
                this.val$fn = biFunction;
            }

            @Override
            public void accept(T v, Throwable error) {
                if (error == null) {
                    if (!this.val$reference.compareAndSet(Marker.EMPTY, v)) {
                        Object rawValue = this.val$reference.get();
                        if (rawValue == Marker.ERROR) {
                            return;
                        }
                        this.applyAndNotify0(this.val$promise, v, rawValue, this.val$fn);
                    }
                } else if (this.val$reference.getAndSet(Marker.ERROR) != Marker.ERROR) {
                    this.val$promise.setFailure(error);
                }
            }

            abstract void applyAndNotify0(Promise<V1> var1, T1 var2, T2 var3, BiFunction<? super V, ? super U, ? extends V1> var4);
        }
        this.whenCompleteAsync((BiConsumer)new CombineBiConsumer<V, U, V>(){
            {
                super(DefaultFutureCompletionStage.this, atomicReference, promise2, biFunction);
            }

            @Override
            void applyAndNotify0(Promise<V1> promise2, V value1, U value2, BiFunction<? super V, ? super U, ? extends V1> fn2) {
                DefaultFutureCompletionStage.applyAndNotify(promise2, value1, value2, fn2);
            }
        }, executor);
        other.whenCompleteAsync(new CombineBiConsumer<U, V, U>(){
            {
                super(DefaultFutureCompletionStage.this, atomicReference, promise2, biFunction);
            }

            @Override
            void applyAndNotify0(Promise<V1> promise2, U value1, V value2, BiFunction<? super V, ? super U, ? extends V1> fn2) {
                DefaultFutureCompletionStage.applyAndNotify(promise2, value2, value1, fn2);
            }
        }, this.otherExecutor(executor));
        return promise.asFuture().asStage();
    }

    private Executor otherExecutor(Executor executor) {
        return executor == SAME_AS_FUTURE ? this.executor() : executor;
    }

    @Override
    public <U> FutureCompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action, Executor executor) {
        Objects.requireNonNull(action, "action");
        return this.thenCombineAsync((CompletionStage)other, (T value, U value2) -> {
            action.accept((Object)value, (Object)value2);
            return null;
        }, executor);
    }

    @Override
    public FutureCompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        Objects.requireNonNull(action, "action");
        return this.thenCombineAsync(other, (T ignoreOtherValue, U ignoreError) -> {
            action.run();
            return null;
        }, executor);
    }

    @Override
    public <U> FutureCompletionStage<U> applyToEitherAsync(CompletionStage<? extends V> other, final Function<? super V, U> fn, Executor executor) {
        Objects.requireNonNull(other, "other");
        Objects.requireNonNull(fn, "fn");
        Promise promise = this.executor().newPromise();
        AtomicBiConsumer consumer = new AtomicBiConsumer<V, U>(promise){
            private static final long serialVersionUID = -8454630185124276599L;

            @Override
            protected U apply(V value) {
                return fn.apply(value);
            }
        };
        this.whenCompleteAsync((BiConsumer)consumer, executor);
        other.whenCompleteAsync(consumer, this.otherExecutor(executor));
        return promise.asFuture().asStage();
    }

    @Override
    public FutureCompletionStage<Void> acceptEitherAsync(CompletionStage<? extends V> other, final Consumer<? super V> action, Executor executor) {
        Objects.requireNonNull(other, "other");
        Objects.requireNonNull(action, "action");
        Promise promise = this.executor().newPromise();
        AtomicBiConsumer consumer = new AtomicBiConsumer<V, Void>(promise){
            private static final long serialVersionUID = -8429618092318150682L;

            @Override
            protected Void apply(V value) {
                action.accept(value);
                return null;
            }
        };
        this.whenCompleteAsync((BiConsumer)consumer, executor);
        other.whenCompleteAsync(consumer, this.otherExecutor(executor));
        return promise.asFuture().asStage();
    }

    @Override
    public FutureCompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, final Runnable action, Executor executor) {
        Objects.requireNonNull(other, "other");
        Objects.requireNonNull(action, "action");
        Promise promise = this.executor().newPromise();
        AtomicBiConsumer<Object, Void> consumer = new AtomicBiConsumer<Object, Void>(promise){
            private static final long serialVersionUID = 5994110691767731494L;

            @Override
            protected Void apply(Object value) {
                action.run();
                return null;
            }
        };
        this.whenCompleteAsync(consumer, executor);
        other.whenCompleteAsync(consumer, this.otherExecutor(executor));
        return promise.asFuture().asStage();
    }

    @Override
    public <U> FutureCompletionStage<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn, Executor executor) {
        Objects.requireNonNull(fn, "fn");
        Objects.requireNonNull(executor, "executor");
        Promise promise = this.executor().newPromise();
        this.future.addListener(f -> {
            Throwable cause = f.cause();
            if (cause == null) {
                Object value = f.getNow();
                if (DefaultFutureCompletionStage.executeDirectly(executor)) {
                    DefaultFutureCompletionStage.thenComposeAsync0(promise, fn, value);
                } else {
                    DefaultFutureCompletionStage.safeExecute(executor, () -> DefaultFutureCompletionStage.thenComposeAsync0(promise, fn, value), promise);
                }
            } else {
                promise.setFailure(cause);
            }
        });
        return promise.asFuture().asStage();
    }

    private static <V, U> void thenComposeAsync0(Promise<U> promise, Function<? super V, ? extends CompletionStage<U>> fn, V value) {
        CompletionStage<U> result;
        try {
            result = fn.apply(value);
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
            return;
        }
        result.whenComplete((? super T v, ? super Throwable error) -> {
            if (error == null) {
                promise.setSuccess(v);
            } else {
                promise.setFailure((Throwable)error);
            }
        });
    }

    @Override
    public FutureCompletionStage<V> exceptionally(Function<Throwable, ? extends V> fn) {
        Objects.requireNonNull(fn, "fn");
        Promise promise = this.executor().newPromise();
        this.future.addListener(f -> {
            Throwable error = f.cause();
            if (error == null) {
                Object value = f.getNow();
                promise.setSuccess(value);
            } else {
                Object result;
                try {
                    result = fn.apply(error);
                }
                catch (Throwable cause) {
                    promise.setFailure(cause);
                    return;
                }
                promise.setSuccess(result);
            }
        });
        return promise.asFuture().asStage();
    }

    @Override
    public FutureCompletionStage<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action, Executor executor) {
        Objects.requireNonNull(action, "action");
        Objects.requireNonNull(executor, "executor");
        Promise promise = this.executor().newPromise();
        this.future.addListener(f -> {
            if (DefaultFutureCompletionStage.executeDirectly(executor)) {
                DefaultFutureCompletionStage.whenCompleteAsync0(promise, f, action);
            } else {
                DefaultFutureCompletionStage.safeExecute(executor, () -> DefaultFutureCompletionStage.whenCompleteAsync0(promise, f, action), promise);
            }
        });
        return promise.asFuture().asStage();
    }

    private static <V> void whenCompleteAsync0(Promise<V> promise, Future<? extends V> f, BiConsumer<? super V, ? super Throwable> action) {
        Throwable cause = f.cause();
        Object value = cause == null ? (Object)f.getNow() : null;
        try {
            action.accept(value, cause);
        }
        catch (Throwable error) {
            promise.setFailure(error);
            return;
        }
        if (cause == null) {
            promise.setSuccess(value);
        } else {
            promise.setFailure(cause);
        }
    }

    @Override
    public <U> FutureCompletionStage<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn, Executor executor) {
        Objects.requireNonNull(fn, "fn");
        Objects.requireNonNull(executor, "executor");
        Promise promise = this.executor().newPromise();
        this.future.addListener(f -> {
            if (DefaultFutureCompletionStage.executeDirectly(executor)) {
                DefaultFutureCompletionStage.handleAsync0(promise, f, fn);
            } else {
                DefaultFutureCompletionStage.safeExecute(executor, () -> DefaultFutureCompletionStage.handleAsync0(promise, f, fn), promise);
            }
        });
        return promise.asFuture().asStage();
    }

    private static <U, V> void handleAsync0(Promise<U> promise, Future<? super V> f, BiFunction<? super V, Throwable, ? extends U> fn) {
        Throwable cause = f.cause();
        DefaultFutureCompletionStage.applyAndNotify(promise, cause == null ? (V)f.getNow() : null, cause, fn);
    }

    private static <U, V, T> void applyAndNotify(Promise<U> promise, V value, T value2, BiFunction<? super V, ? super T, ? extends U> fn) {
        U result;
        try {
            result = fn.apply(value, value2);
        }
        catch (Throwable error) {
            promise.setFailure(error);
            return;
        }
        promise.setSuccess(result);
    }

    private static boolean executeDirectly(Executor executor) {
        return executor == SAME_AS_FUTURE;
    }

    private static void safeExecute(Executor executor, Runnable task, Promise<?> promise) {
        try {
            executor.execute(task);
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
    }

    private static abstract class AtomicBiConsumer<V, U>
    extends AtomicReference<Object>
    implements BiConsumer<V, Throwable> {
        private static final long serialVersionUID = 880039612531973027L;
        private final Promise<U> promise;

        AtomicBiConsumer(Promise<U> promise) {
            super(Marker.EMPTY);
            this.promise = promise;
        }

        @Override
        public void accept(V v, Throwable error) {
            if (error == null) {
                if (this.compareAndSet(Marker.EMPTY, v)) {
                    U value;
                    try {
                        value = this.apply(v);
                    }
                    catch (Throwable cause) {
                        this.promise.setFailure(cause);
                        return;
                    }
                    this.promise.setSuccess(value);
                }
            } else if (this.compareAndSet(Marker.EMPTY, Marker.ERROR)) {
                this.promise.setFailure(error);
            }
        }

        protected abstract U apply(V var1);
    }

    private static enum Marker {
        EMPTY,
        ERROR;

    }
}

