/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.DefaultPromise;
import io.netty5.util.concurrent.FutureContextListener;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.internal.logging.InternalLogger;
import java.util.Arrays;
import java.util.EventListener;

final class DefaultFutureListeners {
    private Object[] listeners = new Object[4];
    private int size;

    DefaultFutureListeners() {
    }

    public void add(Object listener, Object context) {
        int index = this.size << 1;
        Object[] listeners = this.listeners;
        if (index == listeners.length) {
            this.listeners = listeners = Arrays.copyOf(listeners, listeners.length << 1);
        }
        listeners[index] = listener;
        listeners[index + 1] = context;
        ++this.size;
    }

    public void remove(EventListener listener) {
        Object[] listeners = this.listeners;
        int len = listeners.length;
        for (int i = 0; i < len; i += 2) {
            Object candidateListener = listeners[i];
            if (candidateListener != listener) continue;
            int listenersToMove = len - i - 2;
            if (listenersToMove > 0) {
                System.arraycopy(listeners, i + 2, listeners, i, listenersToMove);
            }
            listeners[len - 2] = null;
            listeners[len - 1] = null;
            --this.size;
            return;
        }
    }

    public <V> void notifyListeners(DefaultPromise<V> promise, InternalLogger logger) {
        int size = this.size;
        Object[] listeners = this.listeners;
        int len = size << 1;
        for (int i = 0; i < len; i += 2) {
            Object listener = listeners[i];
            Object context = listeners[i + 1];
            try {
                if (context != null) {
                    FutureContextListener fcl = (FutureContextListener)listener;
                    fcl.operationComplete(context == DefaultPromise.NULL_CONTEXT ? null : context, promise);
                    continue;
                }
                if (listener instanceof FutureListener) {
                    FutureListener fl = (FutureListener)listener;
                    fl.operationComplete(promise);
                    continue;
                }
                if (listener == null) break;
                logger.warn("Unknown future listener type: {} of type {}", listener, (Object)listener.getClass());
                continue;
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) continue;
                String className = listener.getClass().getName();
                logger.warn("An exception was thrown by " + className + ".operationComplete()", t);
            }
        }
    }
}

