/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.DefaultPromise;
import io.netty5.util.concurrent.EventExecutorGroup;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import java.util.Collections;
import java.util.Iterator;

public interface EventExecutor
extends EventExecutorGroup {
    @Override
    default public EventExecutor next() {
        return this;
    }

    @Override
    default public Iterator<EventExecutor> iterator() {
        return Collections.singleton(this).iterator();
    }

    default public boolean inEventLoop() {
        return this.inEventLoop(Thread.currentThread());
    }

    public boolean inEventLoop(Thread var1);

    default public <V> Promise<V> newPromise() {
        return new DefaultPromise(this);
    }

    default public <V> Future<V> newSucceededFuture(V result) {
        return DefaultPromise.newSuccessfulPromise(this, result).asFuture();
    }

    default public <V> Future<V> newFailedFuture(Throwable cause) {
        return DefaultPromise.newFailedPromise(this, cause).asFuture();
    }
}

