/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public interface EventExecutorGroup
extends Iterable<EventExecutor>,
Executor {
    public boolean isShuttingDown();

    public boolean isShutdown();

    default public boolean isTerminated() {
        return this.terminationFuture().isDone();
    }

    default public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.terminationFuture().await(timeout, unit);
    }

    default public Future<Void> shutdownGracefully() {
        return this.shutdownGracefully(2L, 15L, TimeUnit.SECONDS);
    }

    public Future<Void> shutdownGracefully(long var1, long var3, TimeUnit var5);

    public Future<Void> terminationFuture();

    public EventExecutor next();

    @Override
    public Iterator<EventExecutor> iterator();

    default public Future<Void> submit(Runnable task) {
        return this.next().submit(task);
    }

    default public <T> Future<T> submit(Runnable task, T result) {
        return this.next().submit(task, result);
    }

    default public <T> Future<T> submit(Callable<T> task) {
        return this.next().submit(task);
    }

    default public Future<Void> schedule(Runnable task, long delay, TimeUnit unit) {
        return this.next().schedule(task, delay, unit);
    }

    default public <V> Future<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
        return this.next().schedule(task, delay, unit);
    }

    default public Future<Void> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return this.next().scheduleAtFixedRate(task, initialDelay, period, unit);
    }

    default public Future<Void> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return this.next().scheduleWithFixedDelay(task, initialDelay, delay, unit);
    }

    @Override
    default public void execute(Runnable task) {
        this.next().execute(task);
    }
}

