/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.AsynchronousResult;
import io.netty5.util.concurrent.DefaultFutureCompletionStage;
import io.netty5.util.concurrent.FutureCompletionStage;
import io.netty5.util.concurrent.FutureContextListener;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.Futures;
import io.netty5.util.concurrent.Promise;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public interface Future<V>
extends AsynchronousResult<V> {
    public Future<V> addListener(FutureListener<? super V> var1);

    public <C> Future<V> addListener(C var1, FutureContextListener<? super C, ? super V> var2);

    public Future<V> sync() throws InterruptedException;

    public Future<V> syncUninterruptibly();

    public Future<V> await() throws InterruptedException;

    public Future<V> awaitUninterruptibly();

    public boolean await(long var1, TimeUnit var3) throws InterruptedException;

    public boolean await(long var1) throws InterruptedException;

    public boolean awaitUninterruptibly(long var1, TimeUnit var3);

    public boolean awaitUninterruptibly(long var1);

    default public V get() throws InterruptedException, ExecutionException {
        this.await();
        Throwable cause = this.cause();
        if (cause == null) {
            return this.getNow();
        }
        if (cause instanceof CancellationException) {
            throw (CancellationException)cause;
        }
        throw new ExecutionException(cause);
    }

    default public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.await(timeout, unit)) {
            Throwable cause = this.cause();
            if (cause == null) {
                return this.getNow();
            }
            if (cause instanceof CancellationException) {
                throw (CancellationException)cause;
            }
            throw new ExecutionException(cause);
        }
        throw new TimeoutException();
    }

    default public FutureCompletionStage<V> asStage() {
        return new DefaultFutureCompletionStage(this);
    }

    default public java.util.concurrent.Future<V> asJdkFuture() {
        return new DefaultFutureCompletionStage(this);
    }

    default public <R> Future<R> map(Function<V, R> mapper) {
        return Futures.map(this, mapper);
    }

    default public <R> Future<R> flatMap(Function<V, Future<R>> mapper) {
        return Futures.flatMap(this, mapper);
    }

    default public Future<V> cascadeTo(Promise<? super V> promise) {
        Futures.cascade(this, promise);
        return this;
    }
}

