/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureContextListener;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.PromiseNotificationUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Function;

final class Futures {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Futures.class);
    private static final PassThrough<?> PASS_THROUGH = new PassThrough();
    private static final PropagateCancel PROPAGATE_CANCEL = new PropagateCancel();

    public static <V, R> Future<R> map(Future<V> future, Function<V, R> mapper) {
        Objects.requireNonNull(future, "future");
        Objects.requireNonNull(mapper, "mapper");
        if (future.isFailed()) {
            Future<Object> failed = future;
            return failed;
        }
        if (future.isSuccess()) {
            return future.executor().submit(new CallableMapper<R, V>(future, mapper));
        }
        Promise promise = future.executor().newPromise();
        future.addListener(new Mapper(promise, mapper));
        Future<Object> mappedFuture = promise.asFuture();
        mappedFuture.addListener(future, Futures.propagateCancel());
        return mappedFuture;
    }

    public static <V, R> Future<R> flatMap(Future<V> future, Function<V, Future<R>> mapper) {
        Objects.requireNonNull(future, "future");
        Objects.requireNonNull(mapper, "mapper");
        Promise promise = future.executor().newPromise();
        future.addListener(new FlatMapper(promise, mapper));
        Future<Object> mappedFuture = promise.asFuture();
        if (!future.isSuccess()) {
            mappedFuture.addListener(future, Futures.propagateCancel());
        }
        return mappedFuture;
    }

    static FutureContextListener<Future<?>, Object> propagateCancel() {
        return PROPAGATE_CANCEL;
    }

    static <R> FutureContextListener<Promise<R>, Object> passThrough() {
        return PASS_THROUGH;
    }

    static <A, B> void propagateUncommonCompletion(Future<? extends A> completed, Promise<B> recipient) {
        if (completed.isCancelled()) {
            recipient.cancel();
        } else {
            Throwable cause = completed.cause();
            recipient.tryFailure(cause);
        }
    }

    private Futures() {
    }

    static <V> void cascade(Future<V> future, Promise<? super V> promise) {
        Objects.requireNonNull(future, "future");
        Objects.requireNonNull(promise, "promise");
        if (!future.isSuccess()) {
            promise.asFuture().addListener(future, Futures.propagateCancel());
        }
        future.addListener(promise, Futures.passThrough());
    }

    private static final class FlatMapper<R, T>
    implements FutureListener<Object> {
        private final Promise<R> recipient;
        private final Function<T, Future<R>> mapper;

        FlatMapper(Promise<R> recipient, Function<T, Future<R>> mapper) {
            this.recipient = recipient;
            this.mapper = mapper;
        }

        @Override
        public void operationComplete(Future<?> completed) throws Exception {
            block6: {
                if (completed.isSuccess()) {
                    try {
                        Object result = completed.getNow();
                        Future<R> future = this.mapper.apply(result);
                        if (future.isSuccess()) {
                            this.recipient.trySuccess(future.getNow());
                            break block6;
                        }
                        if (future.isFailed()) {
                            Futures.propagateUncommonCompletion(future, this.recipient);
                            break block6;
                        }
                        future.addListener(this.recipient, Futures.passThrough());
                        this.recipient.asFuture().addListener(future, Futures.propagateCancel());
                    }
                    catch (Throwable e) {
                        PromiseNotificationUtil.tryFailure(this.recipient, e, logger);
                    }
                } else {
                    Futures.propagateUncommonCompletion(completed, this.recipient);
                }
            }
        }
    }

    private static final class Mapper<R, T>
    implements FutureListener<Object> {
        private final Promise<R> recipient;
        private final Function<T, R> mapper;

        Mapper(Promise<R> recipient, Function<T, R> mapper) {
            this.recipient = recipient;
            this.mapper = mapper;
        }

        @Override
        public void operationComplete(Future<?> completed) throws Exception {
            if (completed.isSuccess()) {
                try {
                    Object result = completed.getNow();
                    R mapped = this.mapper.apply(result);
                    this.recipient.trySuccess(mapped);
                }
                catch (Throwable e) {
                    PromiseNotificationUtil.tryFailure(this.recipient, e, logger);
                }
            } else {
                Futures.propagateUncommonCompletion(completed, this.recipient);
            }
        }
    }

    private static final class CallableMapper<R, T>
    implements Callable<R> {
        private final Future<T> future;
        private final Function<T, R> mapper;

        CallableMapper(Future<T> future, Function<T, R> mapper) {
            this.future = future;
            this.mapper = mapper;
        }

        @Override
        public R call() throws Exception {
            return this.mapper.apply(this.future.getNow());
        }
    }

    private static final class PassThrough<R>
    implements FutureContextListener<Promise<R>, Object> {
        private PassThrough() {
        }

        @Override
        public void operationComplete(Promise<R> recipient, Future<?> completed) throws Exception {
            if (completed.isSuccess()) {
                try {
                    Object result = completed.getNow();
                    recipient.trySuccess(result);
                }
                catch (Throwable e) {
                    PromiseNotificationUtil.tryFailure(recipient, e, logger);
                }
            } else {
                Futures.propagateUncommonCompletion(completed, recipient);
            }
        }
    }

    private static final class PropagateCancel
    implements FutureContextListener<Future<Object>, Object> {
        private PropagateCancel() {
        }

        @Override
        public void operationComplete(Future<Object> context, Future<?> future) throws Exception {
            if (future.isCancelled()) {
                context.cancel();
            }
        }
    }
}

