/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.internal.logging;

import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.JdkLoggerFactory;
import io.netty5.util.internal.logging.Log4J2LoggerFactory;
import io.netty5.util.internal.logging.Slf4JLoggerFactory;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public abstract class InternalLoggerFactory {
    public static InternalLoggerFactory getDefaultFactory() {
        return InternalLoggerFactoryHolder.HOLDER.getFactory();
    }

    public static void setDefaultFactory(InternalLoggerFactory defaultFactory) {
        Objects.requireNonNull(defaultFactory, "defaultFactory");
        InternalLoggerFactoryHolder.HOLDER.setFactory(defaultFactory);
    }

    public static InternalLogger getInstance(Class<?> clazz) {
        return InternalLoggerFactoryHolder.HOLDER.getInstance(clazz);
    }

    public static InternalLogger getInstance(String name) {
        return InternalLoggerFactoryHolder.HOLDER.getInstance(name);
    }

    protected abstract InternalLogger newInstance(String var1);

    static final class InternalLoggerFactoryHolder {
        static final InternalLoggerFactoryHolder HOLDER = new InternalLoggerFactoryHolder();
        private final AtomicReference<InternalLoggerFactory> reference;

        InternalLoggerFactoryHolder() {
            this.reference = new AtomicReference();
        }

        InternalLoggerFactoryHolder(InternalLoggerFactory delegate) {
            this.reference = new AtomicReference<InternalLoggerFactory>(delegate);
        }

        InternalLoggerFactory getFactory() {
            InternalLoggerFactory factory = this.reference.get();
            if (factory == null && !this.reference.compareAndSet(null, factory = InternalLoggerFactoryHolder.newDefaultFactory(InternalLoggerFactory.class.getName()))) {
                factory = this.reference.get();
            }
            return factory;
        }

        void setFactory(InternalLoggerFactory factory) {
            Objects.requireNonNull(factory, "factory");
            if (!this.reference.compareAndSet(null, factory)) {
                throw new IllegalStateException("factory is already set to [" + this.reference + "], rejecting [" + factory + "]");
            }
        }

        InternalLogger getInstance(Class<?> clazz) {
            return this.getInstance(clazz.getName());
        }

        InternalLogger getInstance(String name) {
            return this.newInstance(name);
        }

        InternalLogger newInstance(String name) {
            return this.getFactory().newInstance(name);
        }

        private static InternalLoggerFactory newDefaultFactory(String name) {
            InternalLoggerFactory f = InternalLoggerFactoryHolder.useSlf4JLoggerFactory(name);
            if (f != null) {
                return f;
            }
            f = InternalLoggerFactoryHolder.useLog4J2LoggerFactory(name);
            if (f != null) {
                return f;
            }
            return InternalLoggerFactoryHolder.useJdkLoggerFactory(name);
        }

        private static InternalLoggerFactory useSlf4JLoggerFactory(String name) {
            try {
                InternalLoggerFactory f = Slf4JLoggerFactory.getInstanceWithNopCheck();
                f.newInstance(name).debug("Using SLF4J as the default logging framework");
                return f;
            }
            catch (Exception | LinkageError ignore) {
                return null;
            }
        }

        private static InternalLoggerFactory useLog4J2LoggerFactory(String name) {
            try {
                InternalLoggerFactory f = Log4J2LoggerFactory.INSTANCE;
                f.newInstance(name).debug("Using Log4J2 as the default logging framework");
                return f;
            }
            catch (Exception | LinkageError ignore) {
                return null;
            }
        }

        private static InternalLoggerFactory useJdkLoggerFactory(String name) {
            InternalLoggerFactory f = JdkLoggerFactory.INSTANCE;
            f.newInstance(name).debug("Using java.util.logging as the default logging framework");
            return f;
        }
    }
}

