/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl;

import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.ChannelShutdownDirection;
import io.netty5.handler.codec.DecoderException;
import io.netty5.handler.ssl.SslHandler;
import io.netty5.handler.ssl.SslHandshakeCompletionEvent;
import io.netty5.util.internal.RecyclableArrayList;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.Objects;
import javax.net.ssl.SSLException;

public abstract class ApplicationProtocolNegotiationHandler
implements ChannelHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ApplicationProtocolNegotiationHandler.class);
    private final String fallbackProtocol;
    private final RecyclableArrayList bufferedMessages = RecyclableArrayList.newInstance();
    private ChannelHandlerContext ctx;
    private boolean sslHandlerChecked;

    protected ApplicationProtocolNegotiationHandler(String fallbackProtocol) {
        this.fallbackProtocol = Objects.requireNonNull(fallbackProtocol, "fallbackProtocol");
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.fireBufferedMessages();
        this.bufferedMessages.recycle();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.bufferedMessages.add(msg);
        if (!this.sslHandlerChecked) {
            this.sslHandlerChecked = true;
            if (ctx.pipeline().get(SslHandler.class) == null) {
                this.removeSelfIfPresent(ctx);
            }
        }
    }

    private void fireBufferedMessages() {
        if (!this.bufferedMessages.isEmpty()) {
            for (int i = 0; i < this.bufferedMessages.size(); ++i) {
                this.ctx.fireChannelRead(this.bufferedMessages.get(i));
            }
            this.ctx.fireChannelReadComplete();
            this.bufferedMessages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void channelInboundEvent(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            ctx.fireChannelInboundEvent(evt);
            SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
            try {
                if (!handshakeEvent.isSuccess()) return;
                String protocol = handshakeEvent.applicationProtocol();
                this.configurePipeline(ctx, protocol != null ? protocol : this.fallbackProtocol);
                return;
            }
            catch (Throwable cause) {
                this.channelExceptionCaught(ctx, cause);
                return;
            }
            finally {
                if (handshakeEvent.isSuccess()) {
                    this.removeSelfIfPresent(ctx);
                }
            }
        } else {
            ctx.fireChannelInboundEvent(evt);
        }
    }

    public void channelShutdown(ChannelHandlerContext ctx, ChannelShutdownDirection direction) {
        if (direction == ChannelShutdownDirection.Inbound) {
            this.fireBufferedMessages();
        }
        ctx.fireChannelShutdown(direction);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.fireBufferedMessages();
        ctx.fireChannelInactive();
    }

    private void removeSelfIfPresent(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.pipeline();
        if (!ctx.isRemoved()) {
            pipeline.remove((ChannelHandler)this);
        }
    }

    protected abstract void configurePipeline(ChannelHandlerContext var1, String var2) throws Exception;

    protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.warn("{} TLS handshake failed:", (Object)ctx.channel(), (Object)cause);
        ctx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Throwable wrapped;
        if (cause instanceof DecoderException && (wrapped = cause.getCause()) instanceof SSLException) {
            try {
                this.handshakeFailure(ctx, wrapped);
                return;
            }
            finally {
                this.removeSelfIfPresent(ctx);
            }
        }
        logger.warn("{} Failed to select the application-level protocol:", (Object)ctx.channel(), (Object)cause);
        ctx.fireChannelExceptionCaught(cause);
        ctx.close();
    }
}

