/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.ssl;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import io.netty5.handler.ssl.SslContext;
import io.netty5.handler.ssl.SslHandler;
import io.netty5.util.internal.SilentDispose;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.Objects;

public class OptionalSslHandler
extends ByteToMessageDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OptionalSslHandler.class);
    private final SslContext sslContext;

    public OptionalSslHandler(SslContext sslContext) {
        this.sslContext = Objects.requireNonNull(sslContext, "sslContext");
    }

    protected void decode(ChannelHandlerContext context, Buffer in) throws Exception {
        if (in.readableBytes() < 5) {
            return;
        }
        if (SslHandler.isEncrypted(in)) {
            this.handleSsl(context);
        } else {
            this.handleNonSsl(context);
        }
    }

    private void handleSsl(ChannelHandlerContext context) {
        SslHandler sslHandler = null;
        try {
            sslHandler = this.newSslHandler(context, this.sslContext);
            context.pipeline().replace((ChannelHandler)this, this.newSslHandlerName(), (ChannelHandler)sslHandler);
            sslHandler = null;
        }
        finally {
            if (sslHandler != null) {
                SilentDispose.dispose((Object)sslHandler.engine(), (InternalLogger)logger);
            }
        }
    }

    private void handleNonSsl(ChannelHandlerContext context) {
        ChannelHandler handler = this.newNonSslHandler(context);
        if (handler != null) {
            context.pipeline().replace((ChannelHandler)this, this.newNonSslHandlerName(), handler);
        } else {
            context.pipeline().remove((ChannelHandler)this);
        }
    }

    protected String newSslHandlerName() {
        return null;
    }

    protected SslHandler newSslHandler(ChannelHandlerContext context, SslContext sslContext) {
        return sslContext.newHandler(context.bufferAllocator());
    }

    protected String newNonSslHandlerName() {
        return null;
    }

    protected ChannelHandler newNonSslHandler(ChannelHandlerContext context) {
        return null;
    }
}

